/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import com.ibm.wala.util.strings.StringStuff;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.util.Map;

public final class TypeName
implements Serializable {
    private static final long serialVersionUID = -3256390509887654326L;
    private static final Map<TypeNameKey, TypeName> map = HashMapFactory.make();
    private final TypeNameKey key;

    private static TypeName findOrCreate(TypeNameKey typeNameKey) {
        TypeName typeName = map.get(typeNameKey);
        if (typeName == null) {
            typeName = new TypeName(typeNameKey);
            map.put(typeNameKey, typeName);
        }
        return typeName;
    }

    public static TypeName findOrCreate(ImmutableByteArray immutableByteArray, int n, int n2) throws IllegalArgumentException {
        Atom atom = Atom.findOrCreate(StringStuff.parseForClass(immutableByteArray, n, n2));
        ImmutableByteArray immutableByteArray2 = StringStuff.parseForPackage(immutableByteArray, n, n2);
        Atom atom2 = immutableByteArray2 == null ? null : Atom.findOrCreate(immutableByteArray2);
        short s = StringStuff.parseForArrayDimensionality(immutableByteArray, n, n2);
        boolean bl = StringStuff.classIsPrimitive(immutableByteArray, n, n2);
        if (bl && s == 0) {
            s = -1;
        }
        TypeNameKey typeNameKey = new TypeNameKey(atom2, atom, s, bl);
        return TypeName.findOrCreate(typeNameKey);
    }

    public static TypeName findOrCreate(ImmutableByteArray immutableByteArray) throws IllegalArgumentException {
        if (immutableByteArray == null) {
            throw new IllegalArgumentException("name is null");
        }
        return TypeName.findOrCreate(immutableByteArray, 0, immutableByteArray.length());
    }

    public static TypeName findOrCreate(String string) throws IllegalArgumentException {
        ImmutableByteArray immutableByteArray = ImmutableByteArray.make(string);
        return TypeName.findOrCreate(immutableByteArray);
    }

    public static TypeName findOrCreateClass(Atom atom, Atom atom2) {
        if (atom == null) {
            throw new IllegalArgumentException("null packageName");
        }
        if (atom2 == null) {
            throw new IllegalArgumentException("null className");
        }
        TypeNameKey typeNameKey = new TypeNameKey(atom, atom2, 0, false);
        return TypeName.findOrCreate(typeNameKey);
    }

    private static TypeName findOrCreate(Atom atom, Atom atom2, short s, boolean bl) {
        TypeNameKey typeNameKey = new TypeNameKey(atom, atom2, s, bl);
        return TypeName.findOrCreate(typeNameKey);
    }

    private TypeName(TypeNameKey typeNameKey) {
        this.key = typeNameKey;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key.toString();
    }

    public String toUnicodeString() {
        return this.key.toUnicodeString();
    }

    public static TypeName string2TypeName(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("s is null");
        }
        byte[] byArray = string.getBytes();
        return TypeName.findOrCreate(new ImmutableByteArray(byArray));
    }

    public static TypeName findOrCreateClassName(String string, String string2) {
        Atom atom = Atom.findOrCreateUnicodeAtom(string);
        Atom atom2 = Atom.findOrCreateUnicodeAtom(string2);
        return TypeName.findOrCreateClass(atom, atom2);
    }

    public TypeName parseForArrayElementName() {
        short s = (short)(this.key.dim - 1);
        if (s == 0 && this.key.innermostPrimitive) {
            s = -1;
        }
        return TypeName.findOrCreate(this.key.packageName, this.key.className, s, this.key.innermostPrimitive);
    }

    public TypeName getArrayTypeForElementType() {
        short s = (short)(this.key.dim + 1);
        if (s == 0) {
            s = 1;
        }
        return TypeName.findOrCreate(this.key.packageName, this.key.className, s, this.key.innermostPrimitive);
    }

    public final int getDimensionality() {
        return this.key.dim;
    }

    public final boolean isClassType() {
        return this.key.dim == 0;
    }

    public final boolean isArrayType() {
        return this.key.dim > 0;
    }

    public final boolean isPrimitiveType() {
        return this.key.dim == -1;
    }

    public final TypeName getInnermostElementType() {
        short s = this.key.innermostPrimitive ? (short)-1 : 0;
        return TypeName.findOrCreate(this.key.packageName, this.key.className, s, this.key.innermostPrimitive);
    }

    public Atom getPackage() {
        return this.key.packageName;
    }

    public Atom getClassName() {
        return this.key.className;
    }

    private static final class TypeNameKey
    implements Serializable {
        private final Atom packageName;
        private final Atom className;
        private final short dim;
        private final boolean innermostPrimitive;

        private TypeNameKey(Atom atom, Atom atom2, short s, boolean bl) {
            this.packageName = atom;
            this.className = atom2;
            this.dim = s;
            this.innermostPrimitive = bl;
        }

        public boolean equals(Object object) {
            if (object instanceof TypeNameKey) {
                TypeNameKey typeNameKey = (TypeNameKey)object;
                return this.className == typeNameKey.className && this.packageName == typeNameKey.packageName && this.dim == typeNameKey.dim && this.innermostPrimitive == typeNameKey.innermostPrimitive;
            }
            return false;
        }

        public int hashCode() {
            int n = this.className.hashCode() * 5009 + this.dim * 5011 + (this.innermostPrimitive ? 5021 : 5023);
            if (this.packageName != null) {
                n += this.packageName.hashCode();
            }
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            short s = 0;
            while (s < this.dim) {
                stringBuffer.append("[");
                s = (short)(s + 1);
            }
            if (!this.innermostPrimitive) {
                stringBuffer.append("L");
            }
            if (this.packageName != null) {
                stringBuffer.append(this.packageName.toString());
                stringBuffer.append("/");
            }
            stringBuffer.append(this.className.toString());
            return stringBuffer.toString();
        }

        public String toUnicodeString() {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                short s = 0;
                while (s < this.dim) {
                    stringBuffer.append("[");
                    s = (short)(s + 1);
                }
                if (!this.innermostPrimitive) {
                    stringBuffer.append("L");
                }
                if (this.packageName != null) {
                    stringBuffer.append(this.packageName.toUnicodeString());
                    stringBuffer.append("/");
                }
                stringBuffer.append(this.className.toUnicodeString());
                return stringBuffer.toString();
            }
            catch (UTFDataFormatException uTFDataFormatException) {
                uTFDataFormatException.printStackTrace();
                Assertions.UNREACHABLE();
                return null;
            }
        }
    }
}

