/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types;

import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.collections.HashMapFactory;
import java.io.Serializable;
import java.util.Map;

public final class TypeReference
implements Serializable {
    private static final long serialVersionUID = -3256390509887654327L;
    private static final Map<TypeName, TypeReference> primitiveMap = HashMapFactory.make();
    private static final Map<Key, TypeReference> dictionary = HashMapFactory.make();
    public static final TypeName BooleanName = TypeName.string2TypeName("Z");
    public static final byte BooleanTypeCode = 90;
    public static final TypeReference Boolean = TypeReference.makePrimitive(BooleanName);
    public static final TypeName ByteName = TypeName.string2TypeName("B");
    public static final byte ByteTypeCode = 66;
    public static final TypeReference Byte = TypeReference.makePrimitive(ByteName);
    public static final TypeName CharName = TypeName.string2TypeName("C");
    public static final byte CharTypeCode = 67;
    public static final TypeReference Char = TypeReference.makePrimitive(CharName);
    public static final TypeName DoubleName = TypeName.string2TypeName("D");
    public static final byte DoubleTypeCode = 68;
    public static final TypeReference Double = TypeReference.makePrimitive(DoubleName);
    public static final TypeName FloatName = TypeName.string2TypeName("F");
    public static final byte FloatTypeCode = 70;
    public static final TypeReference Float = TypeReference.makePrimitive(FloatName);
    public static final TypeName IntName = TypeName.string2TypeName("I");
    public static final byte IntTypeCode = 73;
    public static final TypeReference Int = TypeReference.makePrimitive(IntName);
    public static final TypeName LongName = TypeName.string2TypeName("J");
    public static final byte LongTypeCode = 74;
    public static final TypeReference Long = TypeReference.makePrimitive(LongName);
    public static final TypeName ShortName = TypeName.string2TypeName("S");
    public static final byte ShortTypeCode = 83;
    public static final TypeReference Short = TypeReference.makePrimitive(ShortName);
    public static final TypeName VoidName = TypeName.string2TypeName("V");
    public static final byte VoidTypeCode = 86;
    public static final TypeReference Void = TypeReference.makePrimitive(VoidName);
    public static final byte OtherPrimitiveTypeCode = 80;
    public static final TypeReference BooleanArray = TypeReference.findOrCreateArrayOf(Boolean);
    public static final TypeReference ByteArray = TypeReference.findOrCreateArrayOf(Byte);
    public static final TypeReference CharArray = TypeReference.findOrCreateArrayOf(Char);
    public static final TypeReference DoubleArray = TypeReference.findOrCreateArrayOf(Double);
    public static final TypeReference FloatArray = TypeReference.findOrCreateArrayOf(Float);
    public static final TypeReference IntArray = TypeReference.findOrCreateArrayOf(Int);
    public static final TypeReference LongArray = TypeReference.findOrCreateArrayOf(Long);
    public static final TypeReference ShortArray = TypeReference.findOrCreateArrayOf(Short);
    private static final TypeName JavaLangArithmeticExceptionName = TypeName.string2TypeName("Ljava/lang/ArithmeticException");
    public static final TypeReference JavaLangArithmeticException = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangArithmeticExceptionName);
    private static final TypeName JavaLangArrayStoreExceptionName = TypeName.string2TypeName("Ljava/lang/ArrayStoreException");
    public static final TypeReference JavaLangArrayStoreException = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangArrayStoreExceptionName);
    private static final TypeName JavaLangArrayIndexOutOfBoundsExceptionName = TypeName.string2TypeName("Ljava/lang/ArrayIndexOutOfBoundsException");
    public static final TypeReference JavaLangArrayIndexOutOfBoundsException = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangArrayIndexOutOfBoundsExceptionName);
    private static final TypeName JavaLangClassName = TypeName.string2TypeName("Ljava/lang/Class");
    public static final TypeReference JavaLangClass = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangClassName);
    private static final TypeName JavaLangClassCastExceptionName = TypeName.string2TypeName("Ljava/lang/ClassCastException");
    public static final TypeReference JavaLangClassCastException = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangClassCastExceptionName);
    private static final TypeName JavaLangComparableName = TypeName.string2TypeName("Ljava/lang/Comparable");
    public static final TypeReference JavaLangComparable = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangComparableName);
    private static final TypeName JavaLangReflectConstructorName = TypeName.string2TypeName("Ljava/lang/reflect/Constructor");
    public static final TypeReference JavaLangReflectConstructor = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangReflectConstructorName);
    private static final TypeName JavaLangReflectMethodName = TypeName.string2TypeName("Ljava/lang/reflect/Method");
    public static final TypeReference JavaLangReflectMethod = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangReflectMethodName);
    private static final TypeName JavaLangEnumName = TypeName.string2TypeName("Ljava/lang/Enum");
    public static final TypeReference JavaLangEnum = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangEnumName);
    private static final TypeName JavaLangErrorName = TypeName.string2TypeName("Ljava/lang/Error");
    public static final TypeReference JavaLangError = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangErrorName);
    private static final TypeName JavaLangExceptionName = TypeName.string2TypeName("Ljava/lang/Exception");
    public static final TypeReference JavaLangException = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangExceptionName);
    private static final TypeName JavaLangNegativeArraySizeExceptionName = TypeName.string2TypeName("Ljava/lang/NegativeArraySizeException");
    public static final TypeReference JavaLangNegativeArraySizeException = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangNegativeArraySizeExceptionName);
    private static final TypeName JavaLangNullPointerExceptionName = TypeName.string2TypeName("Ljava/lang/NullPointerException");
    public static final TypeReference JavaLangNullPointerException = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangNullPointerExceptionName);
    private static final TypeName JavaLangRuntimeExceptionName = TypeName.string2TypeName("Ljava/lang/RuntimeException");
    public static final TypeReference JavaLangRuntimeException = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangRuntimeExceptionName);
    private static final TypeName JavaLangClassNotFoundExceptionName = TypeName.string2TypeName("Ljava/lang/ClassNotFoundException");
    public static final TypeReference JavaLangClassNotFoundException = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangClassNotFoundExceptionName);
    private static final TypeName JavaLangOutOfMemoryErrorName = TypeName.string2TypeName("Ljava/lang/OutOfMemoryError");
    public static final TypeReference JavaLangOutOfMemoryError = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangOutOfMemoryErrorName);
    private static final TypeName JavaLangExceptionInInitializerErrorName = TypeName.string2TypeName("Ljava/lang/ExceptionInInitializerError");
    public static final TypeReference JavaLangExceptionInInitializerError = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangExceptionInInitializerErrorName);
    private static final TypeName JavaLangObjectName = TypeName.string2TypeName("Ljava/lang/Object");
    public static final TypeReference JavaLangObject = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangObjectName);
    private static final TypeName JavaLangStackTraceElementName = TypeName.string2TypeName("Ljava/lang/StackTraceElement");
    public static final TypeReference JavaLangStackTraceElement = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangStackTraceElementName);
    private static final TypeName JavaLangStringName = TypeName.string2TypeName("Ljava/lang/String");
    public static final TypeReference JavaLangString = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangStringName);
    private static final TypeName JavaLangStringBufferName = TypeName.string2TypeName("Ljava/lang/StringBuffer");
    public static final TypeReference JavaLangStringBuffer = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangStringBufferName);
    private static final TypeName JavaLangStringBuilderName = TypeName.string2TypeName("Ljava/lang/StringBuilder");
    public static final TypeReference JavaLangStringBuilder = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangStringBuilderName);
    private static final TypeName JavaLangThreadName = TypeName.string2TypeName("Ljava/lang/Thread");
    public static final TypeReference JavaLangThread = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangThreadName);
    private static final TypeName JavaLangThrowableName = TypeName.string2TypeName("Ljava/lang/Throwable");
    public static final TypeReference JavaLangThrowable = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangThrowableName);
    public static final TypeName JavaLangCloneableName = TypeName.string2TypeName("Ljava/lang/Cloneable");
    public static final TypeReference JavaLangCloneable = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangCloneableName);
    private static final TypeName JavaLangSystemName = TypeName.string2TypeName("Ljava/lang/System");
    public static final TypeReference JavaLangSystem = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangSystemName);
    private static final TypeName JavaLangIntegerName = TypeName.string2TypeName("Ljava/lang/Integer");
    public static final TypeReference JavaLangInteger = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangIntegerName);
    private static final TypeName JavaLangBooleanName = TypeName.string2TypeName("Ljava/lang/Boolean");
    public static final TypeReference JavaLangBoolean = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangBooleanName);
    private static final TypeName JavaLangDoubleName = TypeName.string2TypeName("Ljava/lang/Double");
    public static final TypeReference JavaLangDouble = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangDoubleName);
    private static final TypeName JavaLangFloatName = TypeName.string2TypeName("Ljava/lang/Float");
    public static final TypeReference JavaLangFloat = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangFloatName);
    private static final TypeName JavaLangShortName = TypeName.string2TypeName("Ljava/lang/Short");
    public static final TypeReference JavaLangShort = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangShortName);
    private static final TypeName JavaLangLongName = TypeName.string2TypeName("Ljava/lang/Long");
    public static final TypeReference JavaLangLong = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangLongName);
    private static final TypeName JavaLangByteName = TypeName.string2TypeName("Ljava/lang/Byte");
    public static final TypeReference JavaLangByte = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangByteName);
    private static final TypeName JavaLangCharacterName = TypeName.string2TypeName("Ljava/lang/Character");
    public static final TypeReference JavaLangCharacter = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaLangCharacterName);
    public static final TypeName JavaIoSerializableName = TypeName.string2TypeName("Ljava/io/Serializable");
    public static final TypeReference JavaIoSerializable = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaIoSerializableName);
    private static final TypeName JavaUtilCollectionName = TypeName.string2TypeName("Ljava/util/Collection");
    public static final TypeReference JavaUtilCollection = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaUtilCollectionName);
    private static final TypeName JavaUtilMapName = TypeName.string2TypeName("Ljava/util/Map");
    public static final TypeReference JavaUtilMap = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaUtilMapName);
    private static final TypeName JavaUtilHashSetName = TypeName.string2TypeName("Ljava/util/HashSet");
    public static final TypeReference JavaUtilHashSet = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaUtilHashSetName);
    private static final TypeName JavaUtilSetName = TypeName.string2TypeName("Ljava/util/Set");
    public static final TypeReference JavaUtilSet = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaUtilSetName);
    private static final TypeName JavaUtilEnumName = TypeName.string2TypeName("Ljava/util/Enumeration");
    public static final TypeReference JavaUtilEnum = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaUtilEnumName);
    private static final TypeName JavaUtilIteratorName = TypeName.string2TypeName("Ljava/util/Iterator");
    public static final TypeReference JavaUtilIterator = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaUtilIteratorName);
    private static final TypeName JavaUtilVectorName = TypeName.string2TypeName("Ljava/util/Vector");
    public static final TypeReference JavaUtilVector = TypeReference.findOrCreate(ClassLoaderReference.Primordial, JavaUtilVectorName);
    public static final byte ClassTypeCode = 76;
    public static final byte ArrayTypeCode = 91;
    static final TypeName NullName = TypeName.string2TypeName("null");
    public static final TypeReference Null = TypeReference.findOrCreate(ClassLoaderReference.Primordial, NullName);
    static final TypeName UnknownName = TypeName.string2TypeName("?unknown?");
    public static final TypeReference Unknown = TypeReference.findOrCreate(ClassLoaderReference.Primordial, UnknownName);
    private final ClassLoaderReference classloader;
    private final TypeName name;

    private static TypeReference makePrimitive(TypeName typeName) {
        TypeReference typeReference = new TypeReference(ClassLoaderReference.Primordial, typeName);
        primitiveMap.put(typeReference.name, typeReference);
        return typeReference;
    }

    public static boolean isPrimitiveType(TypeName typeName) {
        return typeName.isPrimitiveType();
    }

    public static synchronized TypeReference findOrCreate(ClassLoaderReference classLoaderReference, TypeName typeName) {
        TypeReference typeReference;
        Object object;
        if (classLoaderReference == null) {
            throw new IllegalArgumentException("null cl");
        }
        TypeReference typeReference2 = primitiveMap.get(typeName);
        if (typeReference2 != null) {
            return typeReference2;
        }
        if (typeName.isArrayType() && ((TypeName)(object = typeName.getInnermostElementType())).isPrimitiveType()) {
            classLoaderReference = ClassLoaderReference.Primordial;
        }
        if ((typeReference = dictionary.get(object = new Key(classLoaderReference, typeName))) != null) {
            return typeReference;
        }
        typeReference = new TypeReference(classLoaderReference, typeName);
        dictionary.put((Key)object, typeReference);
        return typeReference;
    }

    public static synchronized TypeReference findOrCreate(ClassLoaderReference classLoaderReference, String string) {
        return TypeReference.findOrCreate(classLoaderReference, TypeName.string2TypeName(string));
    }

    public static TypeReference findOrCreateArrayOf(TypeReference typeReference) {
        if (typeReference == null) {
            throw new IllegalArgumentException("t is null");
        }
        TypeName typeName = typeReference.getName();
        if (typeReference.isPrimitiveType()) {
            return TypeReference.findOrCreate(ClassLoaderReference.Primordial, typeName.getArrayTypeForElementType());
        }
        return TypeReference.findOrCreate(typeReference.getClassLoader(), typeName.getArrayTypeForElementType());
    }

    protected TypeReference(ClassLoaderReference classLoaderReference, TypeName typeName) {
        this.classloader = classLoaderReference;
        this.name = typeName;
    }

    public final ClassLoaderReference getClassLoader() {
        return this.classloader;
    }

    public final TypeName getName() {
        return this.name;
    }

    public final TypeReference getArrayElementType() {
        TypeName typeName = this.name.parseForArrayElementName();
        return TypeReference.findOrCreate(this.classloader, typeName);
    }

    public final TypeReference getArrayTypeForElementType() {
        return TypeReference.findOrCreate(this.classloader, this.name.getArrayTypeForElementType());
    }

    public final int getDimensionality() {
        return this.name.getDimensionality();
    }

    public final TypeReference getInnermostElementType() {
        return TypeReference.findOrCreate(this.classloader, this.name.getInnermostElementType());
    }

    public final boolean isClassType() {
        return !this.isArrayType() && !this.isPrimitiveType();
    }

    public final boolean isArrayType() {
        return this.name.isArrayType();
    }

    public final boolean isPrimitiveType() {
        return TypeReference.isPrimitiveType(this.name);
    }

    public final boolean isReferenceType() {
        return !this.isPrimitiveType();
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final String toString() {
        return "<" + this.classloader.getName() + "," + this.name + ">";
    }

    public static TypeReference findOrCreateClass(ClassLoaderReference classLoaderReference, String string, String string2) {
        TypeName typeName = TypeName.findOrCreateClassName(string, string2);
        return TypeReference.findOrCreate(classLoaderReference, typeName);
    }

    private static class Key {
        private final ClassLoaderReference classloader;
        private final TypeName name;

        Key(ClassLoaderReference classLoaderReference, TypeName typeName) {
            this.classloader = classLoaderReference;
            this.name = typeName;
        }

        public final int hashCode() {
            return this.name.hashCode();
        }

        public final boolean equals(Object object) {
            assert (object != null && object instanceof Key);
            Key key = (Key)object;
            return this.name.equals(key.name) && this.classloader.equals(key.classloader);
        }
    }
}

