/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.generics;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.generics.ClassTypeSignature;
import com.ibm.wala.types.generics.FormalTypeParameter;
import com.ibm.wala.types.generics.Signature;
import java.util.ArrayList;

public class ClassSignature
extends Signature {
    private ClassSignature(String string) {
        super(string);
    }

    public static ClassSignature make(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("empty or null sig");
        }
        return new ClassSignature(string);
    }

    public FormalTypeParameter[] getFormalTypeParameters() {
        if (this.rawString().charAt(0) != '<') {
            return null;
        }
        int n = this.endOfFormalTypeParameters();
        String[] stringArray = FormalTypeParameter.parseForFormalTypeParameters(this.rawString().substring(0, n));
        FormalTypeParameter[] formalTypeParameterArray = new FormalTypeParameter[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            formalTypeParameterArray[n2] = FormalTypeParameter.make(stringArray[n2]);
            ++n2;
        }
        return formalTypeParameterArray;
    }

    public ClassTypeSignature getSuperclassSignature() throws IllegalArgumentException {
        return ClassTypeSignature.makeClassTypeSig(this.rawString().substring(this.endOfFormalTypeParameters(), this.endOfClassTypeSig(this.endOfFormalTypeParameters())));
    }

    private int endOfClassTypeSig(int n) throws IllegalArgumentException {
        String string = this.rawString().substring(n);
        if (string.charAt(0) != 'L') {
            throw new IllegalArgumentException("malformed ClassSignature " + this.rawString());
        }
        int n2 = 1;
        int n3 = 0;
        while (n3 > 0 || string.charAt(n2) != ';') {
            if (string.charAt(n2) == '<') {
                ++n3;
            }
            if (string.charAt(n2) == '>') {
                --n3;
            }
            ++n2;
        }
        return n + n2 + 1;
    }

    public ClassTypeSignature[] getSuperinterfaceSignatures() throws IllegalArgumentException {
        int n = this.endOfClassTypeSig(this.endOfFormalTypeParameters());
        ArrayList<ClassTypeSignature> arrayList = new ArrayList<ClassTypeSignature>();
        while (n < this.rawString().length() - 1) {
            int n2 = this.endOfClassTypeSig(n);
            arrayList.add(ClassTypeSignature.makeClassTypeSig(this.rawString().substring(n, n2)));
            n = n2;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        ClassTypeSignature[] classTypeSignatureArray = new ClassTypeSignature[arrayList.size()];
        return arrayList.toArray(classTypeSignatureArray);
    }

    private int endOfFormalTypeParameters() {
        if (this.rawString().charAt(0) != '<') {
            return 0;
        }
        int n = 1;
        int n2 = 1;
        while (n2 > 0) {
            if (this.rawString().charAt(n) == '>') {
                --n2;
            }
            if (this.rawString().charAt(n) == '<') {
                ++n2;
            }
            ++n;
        }
        return n;
    }

    public static ClassSignature getClassSignature(IClass iClass) throws InvalidClassFileException {
        if (iClass instanceof ShrikeClass) {
            ShrikeClass shrikeClass = (ShrikeClass)iClass;
            return shrikeClass.getClassSignature();
        }
        return null;
    }
}

