/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.generics;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.generics.FormalTypeParameter;
import com.ibm.wala.types.generics.Signature;
import com.ibm.wala.types.generics.TypeSignature;

public class MethodTypeSignature
extends Signature {
    private MethodTypeSignature(String string) {
        super(string);
    }

    public static MethodTypeSignature make(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("genericsSignature is null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        return new MethodTypeSignature(string);
    }

    public TypeSignature[] getArguments() {
        String string = this.rawString().replaceAll(".*\\(", "\\(").replaceAll("\\).*", "\\)");
        String[] stringArray = TypeSignature.parseForTypeSignatures(string);
        if (stringArray == null) {
            return null;
        }
        TypeSignature[] typeSignatureArray = new TypeSignature[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            typeSignatureArray[n] = TypeSignature.make(stringArray[n]);
            ++n;
        }
        return typeSignatureArray;
    }

    public TypeSignature getReturnType() {
        String string = this.rawString().substring(this.rawString().indexOf(41) + 1);
        return TypeSignature.make(string);
    }

    public FormalTypeParameter[] getFormalTypeParameters() {
        if (this.rawString().charAt(0) != '<') {
            return null;
        }
        int n = this.endOfFormalTypeParameters();
        String[] stringArray = FormalTypeParameter.parseForFormalTypeParameters(this.rawString().substring(0, n));
        FormalTypeParameter[] formalTypeParameterArray = new FormalTypeParameter[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            formalTypeParameterArray[n2] = FormalTypeParameter.make(stringArray[n2]);
            ++n2;
        }
        return formalTypeParameterArray;
    }

    private int endOfFormalTypeParameters() {
        if (this.rawString().charAt(0) != '<') {
            return 0;
        }
        int n = 1;
        int n2 = 1;
        while (n2 > 0) {
            if (this.rawString().charAt(n) == '>') {
                --n2;
            }
            if (this.rawString().charAt(n) == '<') {
                ++n2;
            }
            ++n;
        }
        return n;
    }

    public static TypeSignature[] getArguments(IMethod iMethod) throws InvalidClassFileException {
        if (iMethod instanceof ShrikeCTMethod) {
            ShrikeCTMethod shrikeCTMethod = (ShrikeCTMethod)iMethod;
            if (shrikeCTMethod.getMethodTypeSignature() == null) {
                return null;
            }
            return shrikeCTMethod.getMethodTypeSignature().getArguments();
        }
        return null;
    }

    public static MethodTypeSignature getMethodTypeSignature(IMethod iMethod) throws InvalidClassFileException {
        if (iMethod instanceof ShrikeCTMethod) {
            ShrikeCTMethod shrikeCTMethod = (ShrikeCTMethod)iMethod;
            return shrikeCTMethod.getMethodTypeSignature();
        }
        return null;
    }
}

