/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types.generics;

import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.generics.ArrayTypeSignature;
import com.ibm.wala.types.generics.BaseType;
import com.ibm.wala.types.generics.ClassTypeSignature;
import com.ibm.wala.types.generics.Signature;
import com.ibm.wala.types.generics.TypeVariableSignature;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class TypeSignature
extends Signature {
    TypeSignature(String string) {
        super(string);
    }

    public static TypeSignature make(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("illegal empty string s");
        }
        assert (string.length() > 0);
        switch (string.charAt(0)) {
            case 'V': {
                Assertions.UNREACHABLE();
                return null;
            }
            case 'Z': {
                return BaseType.BOOLEAN;
            }
            case 'B': {
                return BaseType.BYTE;
            }
            case 'S': {
                return BaseType.SHORT;
            }
            case 'I': {
                return BaseType.INT;
            }
            case 'J': {
                return BaseType.LONG;
            }
            case 'F': {
                return BaseType.FLOAT;
            }
            case 'D': {
                return BaseType.DOUBLE;
            }
            case 'C': {
                return BaseType.CHAR;
            }
            case 'L': {
                return ClassTypeSignature.makeClassTypeSig(string);
            }
            case 'T': {
                return TypeVariableSignature.make(string);
            }
            case '[': {
                return ArrayTypeSignature.make(string);
            }
        }
        throw new IllegalArgumentException("malformed TypeSignature string:" + string);
    }

    public abstract boolean isTypeVariable();

    public abstract boolean isClassTypeSignature();

    public abstract boolean isArrayTypeSignature();

    public abstract boolean isBaseType();

    /*
     * Enabled aggressive block sorting
     */
    static String[] parseForTypeSignatures(String string) throws IllegalArgumentException {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (string.length() < 2) {
            throw new IllegalArgumentException("illegal string of TypeSignature " + string);
        }
        int n = 1;
        block19: while (true) {
            switch (string.charAt(n++)) {
                case 'V': {
                    arrayList.add(TypeReference.VoidName.toString());
                    continue block19;
                }
                case 'Z': {
                    arrayList.add(TypeReference.BooleanName.toString());
                    continue block19;
                }
                case 'B': {
                    arrayList.add(TypeReference.ByteName.toString());
                    continue block19;
                }
                case 'S': {
                    arrayList.add(TypeReference.ShortName.toString());
                    continue block19;
                }
                case 'I': {
                    arrayList.add(TypeReference.IntName.toString());
                    continue block19;
                }
                case 'J': {
                    arrayList.add(TypeReference.LongName.toString());
                    continue block19;
                }
                case 'F': {
                    arrayList.add(TypeReference.FloatName.toString());
                    continue block19;
                }
                case 'D': {
                    arrayList.add(TypeReference.DoubleName.toString());
                    continue block19;
                }
                case 'C': {
                    arrayList.add(TypeReference.CharName.toString());
                    continue block19;
                }
                case 'L': {
                    int n2 = n - 1;
                    int n3 = 0;
                    while (true) {
                        if (string.charAt(n++) == ';' && n3 <= 0) {
                            arrayList.add(string.substring(n2, n));
                            continue block19;
                        }
                        if (string.charAt(n - 1) == '<') {
                            ++n3;
                        }
                        if (string.charAt(n - 1) != '>') continue;
                        --n3;
                    }
                }
                case '[': {
                    int n3;
                    int n2;
                    switch (string.charAt(n)) {
                        case 'B': 
                        case 'I': 
                        case 'Z': {
                            arrayList.add(string.substring(n - 1, n + 1));
                            continue block19;
                        }
                        case 'L': 
                        case 'T': {
                            n2 = n - 1;
                            n3 = 0;
                            while (true) {
                                int n4 = ++n;
                                ++n;
                                if (string.charAt(n4) == ';' && n3 <= 0) {
                                    arrayList.add(string.substring(n2, n));
                                    continue block19;
                                }
                                if (string.charAt(n - 1) == '<') {
                                    ++n3;
                                }
                                if (string.charAt(n - 1) != '>') continue;
                                --n3;
                            }
                        }
                    }
                    Assertions.UNREACHABLE("BANG " + string.charAt(n));
                    continue block19;
                }
                case 'T': {
                    int n2 = n - 1;
                    while (string.charAt(n++) != ';') {
                    }
                    arrayList.add(string.substring(n2, n));
                    continue block19;
                }
                case ')': {
                    int n2 = arrayList.size();
                    if (n2 == 0) {
                        return null;
                    }
                    Iterator iterator = arrayList.iterator();
                    String[] stringArray = new String[n2];
                    int n5 = 0;
                    while (n5 < n2) {
                        stringArray[n5] = (String)iterator.next();
                        ++n5;
                    }
                    return stringArray;
                }
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError((Object)("bad type signature list " + string));
    }
}

