/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.Filter;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterIterator<T>
implements Iterator<T> {
    final Iterator<?> i;
    final Filter f;
    private T next = null;
    private boolean done = false;

    public FilterIterator(Iterator<?> iterator, Filter filter) {
        if (iterator == null) {
            throw new IllegalArgumentException("null i");
        }
        if (filter == null) {
            throw new IllegalArgumentException("null f");
        }
        this.i = iterator;
        this.f = filter;
        this.advance();
    }

    private void advance() {
        while (this.i.hasNext()) {
            Object obj = this.i.next();
            if (!this.f.accepts(obj)) continue;
            this.next = obj;
            return;
        }
        this.done = true;
    }

    @Override
    public T next() throws NoSuchElementException {
        if (this.done) {
            throw new NoSuchElementException();
        }
        T t = this.next;
        this.advance();
        return t;
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "filter " + this.f + " of " + this.i;
    }
}

