/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.Factory;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapUtil {
    public static <K, T> Set<T> findOrCreateSet(Map<K, Set<T>> map, K k) {
        if (map == null) {
            throw new IllegalArgumentException("M is null");
        }
        Set<T> set = map.get(k);
        if (set == null) {
            set = HashSetFactory.make(2);
            map.put(k, set);
        }
        return set;
    }

    public static <K> MutableIntSet findOrCreateMutableIntSet(Map<K, MutableIntSet> map, K k) {
        if (map == null) {
            throw new IllegalArgumentException("M is null");
        }
        MutableIntSet mutableIntSet = map.get(k);
        if (mutableIntSet == null) {
            mutableIntSet = MutableSparseIntSet.makeEmpty();
            map.put(k, mutableIntSet);
        }
        return mutableIntSet;
    }

    public static <K, T> Collection<T> findOrCreateCollection(Map<K, Collection<T>> map, K k) {
        if (map == null) {
            throw new IllegalArgumentException("M is null");
        }
        Collection<T> collection = map.get(k);
        if (collection == null) {
            collection = HashSetFactory.make(2);
            map.put(k, collection);
        }
        return collection;
    }

    public static <K, T> List<T> findOrCreateList(Map<K, List<T>> map, K k) {
        if (map == null) {
            throw new IllegalArgumentException("M is null");
        }
        List<T> list = map.get(k);
        if (list == null) {
            list = new ArrayList<T>();
            map.put(k, list);
        }
        return list;
    }

    public static <K, K2, V> Map<K2, V> findOrCreateMap(Map<K, Map<K2, V>> map, K k) {
        if (map == null) {
            throw new IllegalArgumentException("M is null");
        }
        Map<K2, V> map2 = map.get(k);
        if (map2 == null) {
            map2 = HashMapFactory.make(2);
            map.put(k, map2);
        }
        return map2;
    }

    public static <K, V> V findOrCreateValue(Map<K, V> map, K k, Factory<V> factory) {
        if (map == null) {
            throw new IllegalArgumentException("M is null");
        }
        V v = map.get(k);
        if (v == null) {
            v = factory.make();
            map.put(k, v);
        }
        return v;
    }

    public static <K, V> WeakHashMap<K, V> findOrCreateWeakHashMap(Map<Object, WeakHashMap<K, V>> map, Object object) {
        if (map == null) {
            throw new IllegalArgumentException("M is null");
        }
        WeakHashMap<K, V> weakHashMap = map.get(object);
        if (weakHashMap == null) {
            weakHashMap = new WeakHashMap(2);
            map.put(object, weakHashMap);
        }
        return weakHashMap;
    }

    public static <K, V> Map<V, Set<K>> inverseMap(Map<K, Set<V>> map) {
        if (map == null) {
            throw new IllegalArgumentException("m is null");
        }
        HashMap hashMap = HashMapFactory.make(map.size());
        for (Map.Entry<K, Set<V>> entry : map.entrySet()) {
            K k = entry.getKey();
            Set<V> set = entry.getValue();
            for (V v : set) {
                Set set2 = MapUtil.findOrCreateSet(hashMap, v);
                set2.add(k);
            }
        }
        return hashMap;
    }

    public static <K, V> Map<V, K> invertOneToOneMap(Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("m is null");
        }
        HashMap<V, K> hashMap = HashMapFactory.make(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K k = entry.getKey();
            V v = entry.getValue();
            if (hashMap.containsKey(v)) {
                throw new IllegalArgumentException("input map not one-to-one");
            }
            hashMap.put(v, k);
        }
        return hashMap;
    }

    public static <K, V> Map<Set<K>, V> groupKeysByValue(Map<K, V> map) {
        Object object;
        K k;
        if (map == null) {
            throw new IllegalArgumentException("m is null");
        }
        HashMap<V, K> hashMap = HashMapFactory.make();
        HashMap hashMap2 = HashMapFactory.make();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            k = entry.getKey();
            object = entry.getValue();
            MapUtil.findOrCreateSet(hashMap2, object).add(k);
        }
        for (Map.Entry<K, V> entry : hashMap2.entrySet()) {
            k = entry.getKey();
            object = (Set)entry.getValue();
            hashMap.put(object, k);
        }
        return hashMap;
    }
}

