/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrayMapping<T>
implements OrdinalSetMapping<T> {
    private final T[] array;
    private final HashMap<T, Integer> map = HashMapFactory.make();

    public ObjectArrayMapping(T[] TArray) {
        if (TArray == null) {
            throw new IllegalArgumentException("null array");
        }
        this.array = TArray;
        int n = 0;
        while (n < TArray.length) {
            this.map.put(TArray[n], n);
            ++n;
        }
    }

    @Override
    public T getMappedObject(int n) throws NoSuchElementException {
        try {
            return this.array[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid n: " + n);
        }
    }

    @Override
    public int getMappedIndex(Object object) {
        if (this.map.get(object) == null) {
            return -1;
        }
        return this.map.get(object);
    }

    @Override
    public boolean hasMappedIndex(Object object) {
        return this.map.get(object) != null;
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int add(Object object) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return 0;
    }

    @Override
    public int getMaximumIndex() {
        return this.array.length - 1;
    }

    @Override
    public int getSize() {
        return this.map.size();
    }
}

