/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.IVector;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleVector<T>
implements IVector<T> {
    private static final int MAX_SIZE = 0x1FFFFFFF;
    private static final double GROWTH_FACTOR = 1.5;
    Object[] store = new Object[1];
    int maxIndex = -1;

    @Override
    public T get(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal x: " + n);
        }
        if (n < this.store.length) {
            return (T)this.store[n];
        }
        return null;
    }

    @Override
    public void set(int n, T t) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal x value " + n);
        }
        if (n > 0x1FFFFFFF) {
            throw new IllegalArgumentException("x is too big: " + n);
        }
        this.maxIndex = Math.max(this.maxIndex, n);
        if (t == null) {
            if (n >= this.store.length) {
                return;
            }
            this.store[n] = null;
        } else {
            this.ensureCapacity(n);
            this.store[n] = t;
        }
    }

    private void ensureCapacity(int n) {
        if (n >= this.store.length) {
            Object[] objectArray = this.store;
            this.store = new Object[1 + (int)(1.5 * (double)n)];
            System.arraycopy(objectArray, 0, this.store, 0, objectArray.length);
        }
    }

    @Override
    public void performVerboseAction() {
        System.err.println("size:       " + this.store.length);
        System.err.println("occupancy:  " + this.computeOccupancy());
    }

    private double computeOccupancy() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.store.length) {
            if (this.store[n2] != null) {
                ++n;
            }
            ++n2;
        }
        return (double)n / (double)this.store.length;
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n <= this.maxIndex) {
            arrayList.add(this.store[n]);
            ++n;
        }
        return arrayList.iterator();
    }

    @Override
    public int getMaxIndex() {
        return this.maxIndex;
    }
}

