/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NodeManager;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraph<T>
implements Graph<T> {
    protected abstract NodeManager<T> getNodeManager();

    protected abstract EdgeManager<T> getEdgeManager();

    @Override
    public Iterator<T> iterator() {
        return this.getNodeManager().iterator();
    }

    @Override
    public int getNumberOfNodes() {
        return this.getNodeManager().getNumberOfNodes();
    }

    @Override
    public int getPredNodeCount(T t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("n cannot be null");
        }
        return this.getEdgeManager().getPredNodeCount(t);
    }

    @Override
    public Iterator<T> getPredNodes(T t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("n cannot be null");
        }
        return this.getEdgeManager().getPredNodes(t);
    }

    @Override
    public int getSuccNodeCount(T t) throws IllegalArgumentException {
        if (!this.containsNode(t) || t == null) {
            throw new IllegalArgumentException("node not in graph " + t);
        }
        return this.getEdgeManager().getSuccNodeCount(t);
    }

    @Override
    public Iterator<T> getSuccNodes(T t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("n cannot be null");
        }
        return this.getEdgeManager().getSuccNodes(t);
    }

    @Override
    public void addNode(T t) {
        this.getNodeManager().addNode(t);
    }

    @Override
    public void addEdge(T t, T t2) throws IllegalArgumentException {
        this.getEdgeManager().addEdge(t, t2);
    }

    @Override
    public void removeEdge(T t, T t2) throws IllegalArgumentException {
        this.getEdgeManager().removeEdge(t, t2);
    }

    @Override
    public boolean hasEdge(T t, T t2) {
        if (t == null) {
            throw new IllegalArgumentException("src is null");
        }
        if (t2 == null) {
            throw new IllegalArgumentException("dst is null");
        }
        return this.getEdgeManager().hasEdge(t, t2);
    }

    @Override
    public void removeAllIncidentEdges(T t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        this.getEdgeManager().removeAllIncidentEdges(t);
    }

    @Override
    public void removeIncomingEdges(T t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        this.getEdgeManager().removeIncomingEdges(t);
    }

    @Override
    public void removeOutgoingEdges(T t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        this.getEdgeManager().removeOutgoingEdges(t);
    }

    @Override
    public void removeNodeAndEdges(T t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("N cannot be null");
        }
        this.getEdgeManager().removeAllIncidentEdges(t);
        this.getNodeManager().removeNode(t);
    }

    @Override
    public void removeNode(T t) throws IllegalArgumentException {
        if (t == null) {
            throw new IllegalArgumentException("N cannot be null");
        }
        this.getNodeManager().removeNode(t);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (T t : this) {
            stringBuffer.append(t.toString()).append("\n");
            Iterator<T> iterator = this.getSuccNodes(t);
            while (iterator.hasNext()) {
                T t2 = iterator.next();
                stringBuffer.append("  --> ").append(t2);
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean containsNode(T t) {
        if (t == null) {
            throw new IllegalArgumentException("n cannot be null");
        }
        return this.getNodeManager().containsNode(t);
    }
}

