/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.graph.AbstractGraph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNumberedGraph<T>
extends AbstractGraph<T>
implements NumberedGraph<T> {
    @Override
    public int getMaxNumber() {
        return ((NumberedNodeManager)this.getNodeManager()).getMaxNumber();
    }

    @Override
    public T getNode(int n) {
        return ((NumberedNodeManager)this.getNodeManager()).getNode(n);
    }

    @Override
    public int getNumber(T t) {
        if (t == null) {
            throw new IllegalArgumentException("N cannot be null");
        }
        return ((NumberedNodeManager)this.getNodeManager()).getNumber(t);
    }

    @Override
    public Iterator<T> iterateNodes(IntSet intSet) {
        return new NumberedNodeIterator(intSet, this);
    }

    @Override
    public IntSet getPredNodeNumbers(T t) throws IllegalArgumentException {
        assert (this.getEdgeManager() != null);
        return ((NumberedEdgeManager)this.getEdgeManager()).getPredNodeNumbers(t);
    }

    @Override
    public IntSet getSuccNodeNumbers(T t) throws IllegalArgumentException {
        return ((NumberedEdgeManager)this.getEdgeManager()).getSuccNodeNumbers(t);
    }
}

