/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.collections.SimpleVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTree<T> {
    private final T value;
    private final SimpleVector<BasicTree<T>> children = new SimpleVector();

    protected BasicTree(T t) {
        this.value = t;
    }

    public static <T> BasicTree<T> make(T t) {
        if (t == null) {
            throw new IllegalArgumentException("null value");
        }
        return new BasicTree<T>(t);
    }

    public T getRootValue() {
        return this.value;
    }

    public T getChildValue(int n) {
        if (this.children.get(n) == null) {
            return null;
        }
        return this.children.get(n).getRootValue();
    }

    public BasicTree<T> getChild(int n) {
        return this.children.get(n);
    }

    public void setChild(int n, BasicTree<T> basicTree) {
        this.children.set(n, basicTree);
    }

    public int getMaxChildIndex() {
        return this.children.getMaxIndex();
    }
}

