/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BitVectorFramework;
import com.ibm.wala.dataflow.graph.BitVectorIdentity;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.BitVectorUnion;
import com.ibm.wala.dataflow.graph.BitVectorUnionConstant;
import com.ibm.wala.dataflow.graph.DataflowSolver;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixedpoint.impl.UnaryOperator;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphReachability<T> {
    private final Graph<T> g;
    private DataflowSolver solver;
    final OrdinalSetMapping<T> domain;

    public GraphReachability(Graph<T> graph, Filter filter) {
        if (graph == null) {
            throw new IllegalArgumentException("g is null");
        }
        this.g = graph;
        FilterIterator filterIterator = new FilterIterator(graph.iterator(), filter);
        this.domain = new MutableMapping(Iterator2Collection.toSet(filterIterator).toArray());
    }

    public OrdinalSet<T> getReachableSet(Object object) throws IllegalStateException {
        if (this.solver == null) {
            throw new IllegalStateException("must call solve() before calling getReachableSet()");
        }
        BitVectorVariable bitVectorVariable = (BitVectorVariable)this.solver.getOut(object);
        assert (bitVectorVariable != null) : "null variable for node " + object;
        if (bitVectorVariable.getValue() == null) {
            return OrdinalSet.empty();
        }
        return new OrdinalSet<T>(bitVectorVariable.getValue(), this.domain);
    }

    public boolean solve(IProgressMonitor iProgressMonitor) throws CancelException {
        ITransferFunctionProvider iTransferFunctionProvider = new ITransferFunctionProvider<T, BitVectorVariable>(){

            @Override
            public UnaryOperator<BitVectorVariable> getNodeTransferFunction(T t) {
                int n = GraphReachability.this.domain.getMappedIndex(t);
                if (n > -1) {
                    return new BitVectorUnionConstant(n);
                }
                return BitVectorIdentity.instance();
            }

            @Override
            public boolean hasNodeTransferFunctions() {
                return true;
            }

            @Override
            public UnaryOperator<BitVectorVariable> getEdgeTransferFunction(Object object, Object object2) {
                Assertions.UNREACHABLE();
                return null;
            }

            @Override
            public boolean hasEdgeTransferFunctions() {
                return false;
            }

            @Override
            public AbstractMeetOperator<BitVectorVariable> getMeetOperator() {
                return BitVectorUnion.instance();
            }
        };
        BitVectorFramework<T, T> bitVectorFramework = new BitVectorFramework<T, T>(GraphInverter.invert(this.g), iTransferFunctionProvider, this.domain);
        this.solver = new BitVectorSolver<T>(bitVectorFramework);
        return this.solver.solve(iProgressMonitor);
    }
}

