/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.dominators;

import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.AbstractGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.dominators.GenericDominators;
import com.ibm.wala.util.graph.dominators.NumberedDominators;
import com.ibm.wala.util.graph.traverse.SlowDFSDiscoverTimeIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Dominators<T> {
    static final boolean DEBUG = false;
    private final T[] vertex;
    protected final Graph<T> G;
    protected final T root;
    protected int reachableNodeCount = 0;

    public Dominators(Graph<T> graph, T t) throws IllegalArgumentException {
        if (graph == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.G = graph;
        this.root = t;
        if (graph.getNumberOfNodes() == 0) {
            throw new IllegalArgumentException("G has no nodes");
        }
        this.vertex = new Object[graph.getNumberOfNodes() + 1];
    }

    public static <T> Dominators<T> make(Graph<T> graph, T t) {
        if (graph instanceof NumberedGraph) {
            return new NumberedDominators<T>((NumberedGraph)graph, t);
        }
        return new GenericDominators<T>(graph, t);
    }

    public boolean isDominatedBy(T t, T t2) {
        T t3 = t;
        while (t3 != null) {
            if (t3.equals(t2)) {
                return true;
            }
            t3 = this.getIdom(t3);
        }
        return false;
    }

    public Graph<T> getGraph() {
        return this.G;
    }

    public T getIdom(T t) {
        return (T)this.getInfo(t).dominator;
    }

    public Iterator<T> dominators(T t) {
        return new Iterator<T>(t){
            private T current;
            {
                this.current = object;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public T next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Object t = this.current;
                this.current = Dominators.this.getIdom(this.current);
                return t;
            }
        };
    }

    public Graph<T> dominatorTree() {
        return new AbstractGraph<T>(){
            private final EdgeManager<T> edges = new EdgeManager<T>(){
                private final Map<T, Set<T>> nextMap = HashMapFactory.make();
                {
                    for (Object t : (this).Dominators.this.G) {
                        if (t == (this).Dominators.this.root) continue;
                        Object t2 = Dominators.this.getIdom(t);
                        Set set = this.nextMap.get(t2);
                        if (set == null) {
                            set = HashSetFactory.make(2);
                            this.nextMap.put(t2, set);
                        }
                        set.add(t);
                    }
                }

                @Override
                public Iterator<T> getPredNodes(T t) {
                    if (t == (this).Dominators.this.root) {
                        return EmptyIterator.instance();
                    }
                    return new NonNullSingletonIterator(Dominators.this.getIdom(t));
                }

                @Override
                public int getPredNodeCount(Object object) {
                    return object == (this).Dominators.this.root ? 0 : 1;
                }

                @Override
                public Iterator<T> getSuccNodes(Object object) {
                    if (this.nextMap.containsKey(object)) {
                        return this.nextMap.get(object).iterator();
                    }
                    return EmptyIterator.instance();
                }

                @Override
                public int getSuccNodeCount(Object object) {
                    if (this.nextMap.containsKey(object)) {
                        return this.nextMap.get(object).size();
                    }
                    return 0;
                }

                @Override
                public void addEdge(Object object, Object object2) {
                    Assertions.UNREACHABLE();
                }

                @Override
                public void removeEdge(Object object, Object object2) {
                    Assertions.UNREACHABLE();
                }

                @Override
                public void removeAllIncidentEdges(Object object) {
                    Assertions.UNREACHABLE();
                }

                @Override
                public void removeIncomingEdges(Object object) {
                    Assertions.UNREACHABLE();
                }

                @Override
                public void removeOutgoingEdges(Object object) {
                    Assertions.UNREACHABLE();
                }

                @Override
                public boolean hasEdge(Object object, Object object2) {
                    Assertions.UNREACHABLE();
                    return false;
                }
            };

            @Override
            protected NodeManager<T> getNodeManager() {
                return Dominators.this.G;
            }

            @Override
            protected EdgeManager<T> getEdgeManager() {
                return this.edges;
            }
        };
    }

    protected void analyze() {
        this.step1();
        this.step2();
        this.step3();
    }

    private void step1() {
        this.reachableNodeCount = 0;
        SlowDFSDiscoverTimeIterator slowDFSDiscoverTimeIterator = new SlowDFSDiscoverTimeIterator<T>(this.G, this.root){
            public static final long serialVersionUID = 88831771771711L;

            @Override
            protected void visitEdge(T t, T t2) {
                Dominators.this.setParent(t2, t);
            }
        };
        while (slowDFSDiscoverTimeIterator.hasNext()) {
            Object t = slowDFSDiscoverTimeIterator.next();
            assert (t != null);
            this.vertex[++this.reachableNodeCount] = t;
            this.setSemi(t, this.reachableNodeCount);
        }
    }

    private void step2() {
        int n = this.reachableNodeCount;
        while (n > 1) {
            Object object;
            Object object2;
            T t = this.vertex[n];
            Iterator<T> iterator = this.G.getPredNodes(t);
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object = this.EVAL(object2);
                if (this.getSemi(object) == 0 || this.getSemi(object) >= this.getSemi(t)) continue;
                this.setSemi(t, this.getSemi(object));
            }
            this.addToBucket(this.vertex[this.getSemi(t)], t);
            this.LINK(this.getParent(t), t);
            object2 = this.iterateBucket(this.getParent(t));
            while (object2.hasNext()) {
                object = object2.next();
                T t2 = this.EVAL(object);
                if (this.getSemi(t2) < this.getSemi(object)) {
                    this.setDominator(object, t2);
                    continue;
                }
                this.setDominator(object, this.getParent(t));
            }
            --n;
        }
    }

    private T EVAL(T t) {
        if (this.getAncestor(t) == null) {
            return this.getLabel(t);
        }
        this.compress(t);
        if (this.getSemi(this.getLabel(this.getAncestor(t))) >= this.getSemi(this.getLabel(t))) {
            return this.getLabel(t);
        }
        return this.getLabel(this.getAncestor(t));
    }

    private void compress(T t) {
        if (this.getAncestor(this.getAncestor(t)) != null) {
            this.compress(this.getAncestor(t));
            if (this.getSemi(this.getLabel(this.getAncestor(t))) < this.getSemi(this.getLabel(t))) {
                this.setLabel(t, this.getLabel(this.getAncestor(t)));
            }
            this.setAncestor(t, this.getAncestor(this.getAncestor(t)));
        }
    }

    private void LINK(T t, T t2) {
        T t3 = t2;
        while (this.getSemi(this.getLabel(t2)) < this.getSemi(this.getLabel(this.getChild(t3)))) {
            if (this.getSize(t3) + this.getSize(this.getChild(this.getChild(t3))) >= 2 * this.getSize(this.getChild(t3))) {
                this.setAncestor(this.getChild(t3), t3);
                this.setChild(t3, this.getChild(this.getChild(t3)));
                continue;
            }
            this.setSize(this.getChild(t3), this.getSize(t3));
            this.setAncestor(t3, this.getChild(t3));
            t3 = this.getChild(t3);
        }
        this.setLabel(t3, this.getLabel(t2));
        this.setSize(t, this.getSize(t) + this.getSize(t2));
        if (this.getSize(t) < 2 * this.getSize(t2)) {
            T t4 = t3;
            t3 = this.getChild(t);
            this.setChild(t, t4);
        }
        while (t3 != null) {
            this.setAncestor(t3, t);
            t3 = this.getChild(t3);
        }
    }

    private void step3() {
        int n = 2;
        while (n <= this.reachableNodeCount) {
            T t = this.vertex[n];
            if (this.getDominator(t) != this.vertex[this.getSemi(t)]) {
                this.setDominator(t, this.getDominator(this.getDominator(t)));
            }
            ++n;
        }
    }

    protected abstract DominatorInfo getInfo(T var1);

    private Iterator<T> iterateBucket(T t) {
        return this.getInfo(t).bucket.iterator();
    }

    private void addToBucket(T t, T t2) {
        this.getInfo(t).bucket.add(t2);
    }

    private T getDominator(T t) {
        assert (t != null);
        return (T)this.getInfo(t).dominator;
    }

    private void setDominator(T t, T t2) {
        this.getInfo(t).dominator = t2;
    }

    private T getParent(T t) {
        return (T)this.getInfo(t).parent;
    }

    private void setParent(T t, T t2) {
        this.getInfo(t).parent = t2;
    }

    private T getAncestor(T t) {
        return (T)this.getInfo(t).ancestor;
    }

    private void setAncestor(T t, T t2) {
        this.getInfo(t).ancestor = t2;
    }

    private T getLabel(T t) {
        if (t == null) {
            return null;
        }
        return (T)this.getInfo(t).label;
    }

    private void setLabel(T t, T t2) {
        this.getInfo(t).label = t2;
    }

    private int getSize(T t) {
        if (t == null) {
            return 0;
        }
        return this.getInfo(t).size;
    }

    private void setSize(T t, int n) {
        this.getInfo(t).size = n;
    }

    private T getChild(T t) {
        return (T)this.getInfo(t).child;
    }

    private void setChild(T t, T t2) {
        this.getInfo(t).child = t2;
    }

    private int getSemi(T t) {
        if (t == null) {
            return 0;
        }
        return this.getInfo(t).semiDominator;
    }

    private void setSemi(T t, int n) {
        this.getInfo(t).semiDominator = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object t : this.G) {
            stringBuffer.append("Dominators of " + t + ":\n");
            Iterator iterator = this.dominators(t);
            while (iterator.hasNext()) {
                stringBuffer.append("   " + iterator.next() + "\n");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class DominatorInfo {
        private T dominator = null;
        private T parent = null;
        private int semiDominator = 0;
        private final Set<T> bucket = HashSetFactory.make();
        private T label;
        private T ancestor = null;
        private int size;
        private T child;

        DominatorInfo(T t) {
            this.label = t;
            this.size = 1;
            this.child = null;
        }
    }
}

