/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.SimpleVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.OrderedMultiGraph;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicOrderedMultiGraph<T>
implements OrderedMultiGraph<T> {
    final Map<T, SimpleVector<T>> successorEdges = HashMapFactory.make();
    private final Graph<T> delegate = SlowSparseNumberedGraph.make();

    @Override
    public void addEdge(T t, T t2) throws IllegalArgumentException {
        this.delegate.addEdge(t, t2);
        SimpleVector<T> simpleVector = this.successorEdges.get(t);
        if (simpleVector == null) {
            simpleVector = new SimpleVector();
            this.successorEdges.put(t, simpleVector);
        }
        simpleVector.set(simpleVector.getMaxIndex() + 1, t2);
    }

    @Override
    public void addEdge(int n, T t, T t2) throws IllegalArgumentException {
        this.delegate.addEdge(t, t2);
        SimpleVector<T> simpleVector = this.successorEdges.get(t);
        if (simpleVector == null) {
            simpleVector = new SimpleVector();
            this.successorEdges.put(t, simpleVector);
        }
        simpleVector.set(n, t2);
    }

    @Override
    public void addNode(T t) {
        this.delegate.addNode(t);
    }

    @Override
    public boolean containsNode(T t) {
        return this.delegate.containsNode(t);
    }

    @Override
    public int getNumberOfNodes() {
        return this.delegate.getNumberOfNodes();
    }

    @Override
    public int getPredNodeCount(T t) throws IllegalArgumentException {
        return this.delegate.getPredNodeCount(t);
    }

    @Override
    public Iterator<T> getPredNodes(T t) throws IllegalArgumentException {
        return this.delegate.getPredNodes(t);
    }

    @Override
    public int getSuccNodeCount(T t) throws IllegalArgumentException {
        return this.delegate.getSuccNodeCount(t);
    }

    @Override
    public Iterator<T> getSuccNodes(T t) throws IllegalArgumentException {
        return this.delegate.getSuccNodes(t);
    }

    @Override
    public boolean hasEdge(T t, T t2) {
        return this.delegate.hasEdge(t, t2);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public void removeAllIncidentEdges(T t) throws UnimplementedError {
        Assertions.UNREACHABLE();
        this.delegate.removeAllIncidentEdges(t);
    }

    @Override
    public void removeEdge(T t, T t2) throws UnimplementedError {
        Assertions.UNREACHABLE();
        this.delegate.removeEdge(t, t2);
    }

    @Override
    public void removeIncomingEdges(T t) throws UnimplementedError {
        Assertions.UNREACHABLE();
        this.delegate.removeIncomingEdges(t);
    }

    @Override
    public void removeNode(T t) throws UnimplementedError {
        Assertions.UNREACHABLE();
        this.delegate.removeNode(t);
    }

    @Override
    public void removeNodeAndEdges(T t) throws UnimplementedError {
        Assertions.UNREACHABLE();
        this.delegate.removeNodeAndEdges(t);
    }

    @Override
    public void removeOutgoingEdges(T t) throws UnimplementedError {
        Assertions.UNREACHABLE();
        this.delegate.removeOutgoingEdges(t);
    }

    @Override
    public T getSuccessor(T t, int n) throws IllegalArgumentException {
        SimpleVector<T> simpleVector = this.successorEdges.get(t);
        if (simpleVector == null) {
            throw new IllegalArgumentException("no successors for node " + t);
        }
        if (n > simpleVector.getMaxIndex()) {
            throw new IllegalArgumentException("no successor number " + n + " for " + t);
        }
        return simpleVector.get(n);
    }
}

