/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SparseNumberedEdgeManager<T>
implements NumberedEdgeManager<T> {
    private final NumberedNodeManager<T> nodeManager;
    private final BitVector hasSuccessor = new BitVector();
    private static final byte[] defaultImpl = new byte[]{1};
    private final IBinaryNaturalRelation successors;
    private final IBinaryNaturalRelation predecessors;

    public SparseNumberedEdgeManager(NumberedNodeManager<T> numberedNodeManager) {
        this(numberedNodeManager, 0, 1);
    }

    public SparseNumberedEdgeManager(NumberedNodeManager<T> numberedNodeManager, int n, byte by) throws IllegalArgumentException {
        if (numberedNodeManager == null) {
            throw new IllegalArgumentException("null nodeManager");
        }
        if (n < 0) {
            throw new IllegalArgumentException("normalCase < 0");
        }
        this.nodeManager = numberedNodeManager;
        if (n == 0) {
            this.successors = new BasicNaturalRelation(defaultImpl, by);
            this.predecessors = new BasicNaturalRelation(defaultImpl, by);
        } else {
            byte[] byArray = new byte[n];
            Arrays.fill(byArray, (byte)0);
            this.successors = new BasicNaturalRelation(byArray, by);
            this.predecessors = new BasicNaturalRelation(byArray, by);
        }
    }

    @Override
    public Iterator<T> getPredNodes(T t) throws IllegalArgumentException {
        int n = this.nodeManager.getNumber(t);
        if (n < 0) {
            throw new IllegalArgumentException(t + " is not in graph");
        }
        IntSet intSet = this.predecessors.getRelated(n);
        EmptyIterator emptyIterator = EmptyIterator.instance();
        return intSet == null ? emptyIterator : this.nodeManager.iterateNodes(intSet);
    }

    @Override
    public int getPredNodeCount(T t) throws IllegalArgumentException {
        int n = this.nodeManager.getNumber(t);
        if (n < 0) {
            throw new IllegalArgumentException(t + "  is not in graph");
        }
        return this.predecessors.getRelatedCount(n);
    }

    @Override
    public Iterator<T> getSuccNodes(T t) throws IllegalArgumentException {
        int n = this.nodeManager.getNumber(t);
        if (n == -1) {
            throw new IllegalArgumentException(t + "  is not in graph");
        }
        IntSet intSet = this.successors.getRelated(n);
        EmptyIterator emptyIterator = EmptyIterator.instance();
        return intSet == null ? emptyIterator : this.nodeManager.iterateNodes(intSet);
    }

    @Override
    public Iterator<T> getSuccNodes(int n) {
        IntSet intSet = this.successors.getRelated(n);
        EmptyIterator emptyIterator = EmptyIterator.instance();
        return intSet == null ? emptyIterator : this.nodeManager.iterateNodes(intSet);
    }

    @Override
    public IntSet getSuccNodeNumbers(T t) throws IllegalArgumentException {
        if (this.nodeManager.getNumber(t) < 0) {
            throw new IllegalArgumentException("Node not in graph " + t);
        }
        return this.successors.getRelated(this.nodeManager.getNumber(t));
    }

    @Override
    public IntSet getPredNodeNumbers(T t) throws IllegalArgumentException {
        if (this.nodeManager.getNumber(t) < 0) {
            throw new IllegalArgumentException("Node not in graph " + t);
        }
        return this.predecessors.getRelated(this.nodeManager.getNumber(t));
    }

    @Override
    public int getSuccNodeCount(T t) throws IllegalArgumentException {
        return this.getSuccNodeCount(this.nodeManager.getNumber(t));
    }

    @Override
    public int getSuccNodeCount(int n) {
        return this.successors.getRelatedCount(n);
    }

    @Override
    public void addEdge(T t, T t2) throws IllegalArgumentException {
        int n = this.nodeManager.getNumber(t);
        int n2 = this.nodeManager.getNumber(t2);
        if (n < 0) {
            throw new IllegalArgumentException("src " + t + " is not in graph");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("dst " + t2 + " is not in graph");
        }
        this.predecessors.add(n2, n);
        this.successors.add(n, n2);
        this.hasSuccessor.set(n);
    }

    @Override
    public boolean hasEdge(T t, T t2) {
        int n = this.nodeManager.getNumber(t);
        int n2 = this.nodeManager.getNumber(t2);
        if (n < 0 || n2 < 0) {
            return false;
        }
        return this.successors.contains(n, n2);
    }

    @Override
    public void removeAllIncidentEdges(T t) throws IllegalArgumentException {
        IntSet intSet;
        final int n = this.nodeManager.getNumber(t);
        if (n < 0) {
            throw new IllegalArgumentException("node not in graph: " + t);
        }
        IntSet intSet2 = this.successors.getRelated(n);
        if (intSet2 != null) {
            intSet2.foreach(new IntSetAction(){

                public void act(int n2) {
                    SparseNumberedEdgeManager.this.predecessors.remove(n2, n);
                }
            });
        }
        if ((intSet = this.predecessors.getRelated(n)) != null) {
            intSet.foreach(new IntSetAction(){

                public void act(int n2) {
                    SparseNumberedEdgeManager.this.successors.remove(n2, n);
                    if (SparseNumberedEdgeManager.this.successors.getRelatedCount(n2) == 0) {
                        SparseNumberedEdgeManager.this.hasSuccessor.clear(n2);
                    }
                }
            });
        }
        this.successors.removeAll(n);
        this.hasSuccessor.clear(n);
        this.predecessors.removeAll(n);
    }

    @Override
    public void removeIncomingEdges(T t) throws IllegalArgumentException {
        final int n = this.nodeManager.getNumber(t);
        if (n < 0) {
            throw new IllegalArgumentException("node not in graph: " + t);
        }
        IntSet intSet = this.predecessors.getRelated(n);
        if (intSet != null) {
            intSet.foreach(new IntSetAction(){

                public void act(int n2) {
                    SparseNumberedEdgeManager.this.successors.remove(n2, n);
                    if (SparseNumberedEdgeManager.this.successors.getRelatedCount(n2) == 0) {
                        SparseNumberedEdgeManager.this.hasSuccessor.clear(n2);
                    }
                }
            });
        }
        this.predecessors.removeAll(n);
    }

    @Override
    public void removeEdge(T t, T t2) throws IllegalArgumentException {
        int n = this.nodeManager.getNumber(t);
        int n2 = this.nodeManager.getNumber(t2);
        if (n < 0) {
            throw new IllegalArgumentException("src not in graph: " + t);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("dst not in graph: " + t2);
        }
        this.successors.remove(n, n2);
        if (this.successors.getRelatedCount(n) == 0) {
            this.hasSuccessor.clear(n);
        }
        this.predecessors.remove(n2, n);
    }

    @Override
    public void removeOutgoingEdges(T t) throws IllegalArgumentException {
        final int n = this.nodeManager.getNumber(t);
        if (n < 0) {
            throw new IllegalArgumentException("node not in graph: " + t);
        }
        IntSet intSet = this.successors.getRelated(n);
        if (intSet != null) {
            intSet.foreach(new IntSetAction(){

                public void act(int n2) {
                    SparseNumberedEdgeManager.this.predecessors.remove(n2, n);
                }
            });
        }
        this.successors.removeAll(n);
        this.hasSuccessor.clear(n);
    }

    public boolean hasAnySuccessor(int n) {
        return this.hasSuccessor.get(n);
    }

    public String toString() {
        return "Successors relation:\n" + this.successors;
    }
}

