/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.labeled;

import com.ibm.wala.demandpa.genericutil.ArraySet;
import com.ibm.wala.demandpa.genericutil.ArraySetMultiMap;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.SparseNumberedEdgeManager;
import com.ibm.wala.util.graph.labeled.NumberedLabeledEdgeManager;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseNumberedLabeledEdgeManager<T, U>
implements NumberedLabeledEdgeManager<T, U> {
    private final U defaultLabel;
    private final NumberedNodeManager<T> nodeManager;
    private final Map<U, SparseNumberedEdgeManager<T>> edgeLabelToManager = HashMapFactory.make();
    private final ArraySetMultiMap<T, U> nodeToPredLabels = new ArraySetMultiMap();
    private final ArraySetMultiMap<T, U> nodeToSuccLabels = new ArraySetMultiMap();

    private SparseNumberedEdgeManager<T> getManagerForLabel(U u) {
        SparseNumberedEdgeManager<T> sparseNumberedEdgeManager = this.edgeLabelToManager.get(u);
        if (sparseNumberedEdgeManager == null) {
            sparseNumberedEdgeManager = new SparseNumberedEdgeManager<T>(this.nodeManager);
            this.edgeLabelToManager.put(u, sparseNumberedEdgeManager);
        }
        return sparseNumberedEdgeManager;
    }

    @Override
    public void addEdge(T t, T t2, U u) {
        this.nodeToSuccLabels.put(t, u);
        this.nodeToPredLabels.put(t2, u);
        this.getManagerForLabel(u).addEdge(t, t2);
    }

    @Override
    public int getPredNodeCount(T t, U u) {
        return this.getManagerForLabel(u).getPredNodeCount(t);
    }

    @Override
    public Iterator<T> getPredNodes(T t, U u) {
        return this.getManagerForLabel(u).getPredNodes(t);
    }

    @Override
    public int getSuccNodeCount(T t, U u) {
        return this.getManagerForLabel(u).getSuccNodeCount(t);
    }

    @Override
    public Iterator<? extends T> getSuccNodes(T t, U u) {
        return this.getManagerForLabel(u).getSuccNodes(t);
    }

    @Override
    public boolean hasEdge(T t, T t2, U u) {
        return this.getManagerForLabel(u).hasEdge(t, t2);
    }

    @Override
    public void removeAllIncidentEdges(T t) {
        this.removeIncomingEdges(t);
        this.removeOutgoingEdges(t);
    }

    @Override
    public void removeEdge(T t, T t2, U u) throws IllegalArgumentException {
        this.getManagerForLabel(u).removeEdge(t, t2);
    }

    @Override
    public void removeIncomingEdges(T t) throws IllegalArgumentException {
        for (Object t2 : this.nodeToPredLabels.get((Object)t)) {
            this.getManagerForLabel(t2).removeIncomingEdges(t);
        }
    }

    @Override
    public void removeOutgoingEdges(T t) throws IllegalArgumentException {
        for (Object t2 : this.nodeToSuccLabels.get((Object)t)) {
            this.getManagerForLabel(t2).removeOutgoingEdges(t);
        }
    }

    public SparseNumberedLabeledEdgeManager(NumberedNodeManager<T> numberedNodeManager, U u) {
        this.defaultLabel = u;
        this.nodeManager = numberedNodeManager;
        if (u == null) {
            throw new IllegalArgumentException("null default label");
        }
        if (numberedNodeManager == null) {
            throw new IllegalArgumentException("null nodeManager");
        }
    }

    @Override
    public Iterator<? extends U> getPredLabels(T t) {
        return ((ArraySet)this.nodeToPredLabels.get((Object)t)).iterator();
    }

    @Override
    public Iterator<? extends U> getSuccLabels(T t) {
        return ((ArraySet)this.nodeToSuccLabels.get((Object)t)).iterator();
    }

    @Override
    public Set<? extends U> getEdgeLabels(T t, T t2) {
        HashSet hashSet = HashSetFactory.make();
        for (U u : this.edgeLabelToManager.keySet()) {
            if (!this.edgeLabelToManager.get(u).hasEdge(t, t2)) continue;
            hashSet.add(u);
        }
        return hashSet;
    }

    @Override
    public void addEdge(T t, T t2) {
        this.addEdge(t, t2, this.defaultLabel);
    }

    @Override
    public int getPredNodeCount(T t) {
        int n = 0;
        for (Object t2 : this.nodeToPredLabels.get((Object)t)) {
            n += this.getPredNodeCount(t, t2);
        }
        return n;
    }

    @Override
    public Iterator<T> getPredNodes(T t) {
        HashSet hashSet = HashSetFactory.make();
        for (Object t2 : this.nodeToPredLabels.get((Object)t)) {
            hashSet.addAll(Iterator2Collection.toSet(this.getPredNodes(t, t2)));
        }
        return hashSet.iterator();
    }

    @Override
    public int getSuccNodeCount(T t) {
        int n = 0;
        for (Object t2 : this.nodeToSuccLabels.get((Object)t)) {
            n += this.getSuccNodeCount(t, t2);
        }
        return n;
    }

    @Override
    public Iterator<T> getSuccNodes(T t) {
        HashSet hashSet = HashSetFactory.make();
        for (Object t2 : this.nodeToSuccLabels.get((Object)t)) {
            hashSet.addAll(Iterator2Collection.toSet(this.getSuccNodes(t, t2)));
        }
        return hashSet.iterator();
    }

    @Override
    public boolean hasEdge(T t, T t2) {
        return this.hasEdge(t, t2, this.defaultLabel);
    }

    @Override
    public void removeEdge(T t, T t2) throws UnsupportedOperationException {
        this.removeEdge(t, t2, this.defaultLabel);
    }

    @Override
    public U getDefaultLabel() {
        return this.defaultLabel;
    }

    @Override
    public IntSet getPredNodeNumbers(T t, U u) throws IllegalArgumentException {
        return this.getManagerForLabel(u).getPredNodeNumbers(t);
    }

    @Override
    public IntSet getSuccNodeNumbers(T t, U u) throws IllegalArgumentException {
        return this.getManagerForLabel(u).getSuccNodeNumbers(t);
    }

    @Override
    public IntSet getPredNodeNumbers(T t) {
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet();
        for (Object t2 : this.nodeToPredLabels.get((Object)t)) {
            bitVectorIntSet.addAll(this.getPredNodeNumbers(t, t2));
        }
        return bitVectorIntSet;
    }

    @Override
    public IntSet getSuccNodeNumbers(T t) {
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet();
        for (Object t2 : this.nodeToSuccLabels.get((Object)t)) {
            bitVectorIntSet.addAll(this.getSuccNodeNumbers(t, t2));
        }
        return bitVectorIntSet;
    }
}

