/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.Graph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BFSIterator<T>
implements Iterator<T> {
    final ArrayList<T> Q = new ArrayList();
    final HashSet<T> visited = HashSetFactory.make();
    private int index = 0;
    protected Graph<T> G;

    public BFSIterator(Graph<T> graph, T t) {
        if (graph == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.init(graph, new NonNullSingletonIterator<T>(t));
    }

    public BFSIterator(Graph<T> graph, Iterator<? extends T> iterator) {
        if (graph == null) {
            throw new IllegalArgumentException("G is null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("nodes is null");
        }
        this.init(graph, iterator);
    }

    public BFSIterator(Graph<T> graph) throws NullPointerException {
        this(graph, graph == null ? null : graph.iterator());
    }

    private void init(Graph<T> graph, Iterator<? extends T> iterator) {
        T t;
        this.G = graph;
        while (iterator.hasNext()) {
            t = iterator.next();
            if (this.visited.contains(t)) continue;
            this.Q.add(t);
            this.visited.add(t);
        }
        this.index = 0;
        if (this.Q.size() > 0) {
            t = this.Q.get(0);
            this.visitChildren(t);
        }
    }

    private void visitChildren(T t) {
        Iterator<T> iterator = this.getConnected(t);
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (this.visited.contains(t2)) continue;
            this.Q.add(t2);
            this.visited.add(t2);
        }
    }

    @Override
    public boolean hasNext() {
        return this.Q.size() > this.index;
    }

    @Override
    public T next() throws NoSuchElementException {
        if (this.index >= this.Q.size()) {
            throw new NoSuchElementException();
        }
        T t = this.Q.get(this.index);
        ++this.index;
        if (this.hasNext()) {
            T t2 = this.Q.get(this.index);
            this.visitChildren(t2);
        }
        return t;
    }

    protected Iterator<? extends T> getConnected(T t) {
        return this.G.getSuccNodes(t);
    }

    @Override
    public void remove() throws UnimplementedError {
        throw new UnimplementedError();
    }
}

