/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.traverse.DFSFinishTimeIterator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberedDFSFinishTimeIterator<T>
extends DFSFinishTimeIterator<T>
implements Iterator<T> {
    public static final long serialVersionUID = 8737376661L;
    private Iterator[] pendingChildren;
    private final NumberedGraph<T> G;

    NumberedDFSFinishTimeIterator(NumberedGraph<T> numberedGraph, T t) {
        this.G = numberedGraph;
        this.pendingChildren = new Iterator[numberedGraph.getMaxNumber() + 1];
        this.init(numberedGraph, new NonNullSingletonIterator<T>(t));
    }

    NumberedDFSFinishTimeIterator(NumberedGraph<T> numberedGraph, Iterator<? extends T> iterator) {
        this.G = numberedGraph;
        this.pendingChildren = new Iterator[numberedGraph.getMaxNumber() + 1];
        this.init(numberedGraph, iterator);
    }

    NumberedDFSFinishTimeIterator(NumberedGraph<T> numberedGraph) {
        this(numberedGraph, numberedGraph.iterator());
    }

    @Override
    Iterator getPendingChildren(T t) {
        int n = this.G.getNumber(t);
        if (n >= this.pendingChildren.length) {
            Iterator[] iteratorArray = this.pendingChildren;
            this.pendingChildren = new Iterator[n * 2];
            System.arraycopy(iteratorArray, 0, this.pendingChildren, 0, iteratorArray.length);
            return null;
        }
        if (n < 0) assert (false) : "negative number for " + t + " " + t.getClass();
        return this.pendingChildren[n];
    }

    @Override
    void setPendingChildren(T t, Iterator<? extends T> iterator) {
        this.pendingChildren[this.G.getNumber(t)] = iterator;
    }
}

