/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.ReverseIterator;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.graph.traverse.DFSFinishTimeIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCCIterator<T>
implements Iterator<Set<T>> {
    private final DFSFinishTimeIterator<T> rev;

    public SCCIterator(Graph<T> graph) throws NullPointerException {
        this(graph, graph == null ? null : graph.iterator());
    }

    public SCCIterator(Graph<T> graph, Iterator<T> iterator) {
        if (graph == null) {
            throw new IllegalArgumentException("G cannot be null");
        }
        Iterator<T> iterator2 = ReverseIterator.reverse(DFS.iterateFinishTime(graph, iterator));
        this.rev = DFS.iterateFinishTime(GraphInverter.invert(graph), iterator2);
    }

    @Override
    public boolean hasNext() {
        return this.rev.hasNext();
    }

    @Override
    public Set<T> next() throws NoSuchElementException {
        HashSet hashSet = HashSetFactory.make();
        T t = this.rev.next();
        hashSet.add(t);
        while (this.rev.hasNext() && !this.rev.isEmpty()) {
            hashSet.add(this.rev.next());
        }
        return hashSet;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

