/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.collections.IVector;
import com.ibm.wala.util.collections.SimpleVector;
import com.ibm.wala.util.collections.TwoLevelVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntPair;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntVector;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SimpleIntVector;
import com.ibm.wala.util.intset.SparseIntSet;
import com.ibm.wala.util.intset.TunedSimpleIntVector;
import com.ibm.wala.util.intset.TwoLevelIntVector;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BasicNaturalRelation
implements IBinaryNaturalRelation {
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    public static final byte SIMPLE = 0;
    public static final byte TWO_LEVEL = 1;
    public static final byte SIMPLE_SPACE_STINGY = 2;
    private static final int EMPTY_CODE = -1;
    private static final int DELEGATE_CODE = -2;
    final IntVector[] smallStore;
    final IVector<IntSet> delegateStore;
    private int maxX = -1;

    public BasicNaturalRelation(byte[] byArray, byte by) throws IllegalArgumentException {
        if (byArray == null) {
            throw new IllegalArgumentException("implementation is null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("implementation.length == 0");
        }
        this.smallStore = new IntVector[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            switch (byArray[n]) {
                case 0: {
                    this.smallStore[n] = new SimpleIntVector(-1);
                    break;
                }
                case 1: {
                    this.smallStore[n] = new TwoLevelIntVector(-1);
                    break;
                }
                case 2: {
                    this.smallStore[n] = new TunedSimpleIntVector(-1, 1, 1.1f);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported implementation " + byArray[n]);
                }
            }
            ++n;
        }
        switch (by) {
            case 0: {
                this.delegateStore = new SimpleVector<IntSet>();
                break;
            }
            case 1: {
                this.delegateStore = new TwoLevelVector<IntSet>();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported implementation " + by);
            }
        }
    }

    public BasicNaturalRelation() {
        this(new byte[1], 1);
    }

    @Override
    public boolean add(int n, int n2) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("illegal x: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("illegal y: " + n2);
        }
        this.maxX = Math.max(this.maxX, n);
        MutableIntSet mutableIntSet = (MutableIntSet)this.delegateStore.get(n);
        if (mutableIntSet != null) {
            return mutableIntSet.add(n2);
        }
        IntVector intVector = this.smallStore[0];
        if (intVector.get(n) != -1) {
            int n3 = 0;
            IntVector intVector2 = null;
            int n4 = this.smallStore.length;
            while (n3 < n4) {
                intVector2 = this.smallStore[n3];
                int n5 = intVector2.get(n);
                if (n5 == n2) {
                    return false;
                }
                if (n5 == -1) break;
                ++n3;
            }
            if (n3 == n4) {
                BimodalMutableIntSet bimodalMutableIntSet = new BimodalMutableIntSet(n4 + 1, 1.1f);
                this.delegateStore.set(n, bimodalMutableIntSet);
                int n6 = 0;
                while (n6 < this.smallStore.length) {
                    IntVector intVector3 = this.smallStore[n6];
                    bimodalMutableIntSet.add(intVector3.get(n));
                    intVector3.set(n, -2);
                    ++n6;
                }
                bimodalMutableIntSet.add(n2);
            } else {
                intVector2.set(n, n2);
            }
            return true;
        }
        intVector.set(n, n2);
        return true;
    }

    private boolean usingDelegate(int n) {
        return this.smallStore[0].get(n) == -2;
    }

    @Override
    public Iterator<IntPair> iterator() {
        return new TotalIterator();
    }

    private IntSet getDelegate(int n) {
        return this.delegateStore.get(n);
    }

    @Override
    public boolean anyRelated(int n) {
        return this.smallStore[0].get(n) != -1;
    }

    @Override
    public IntSet getRelated(int n) {
        int n2 = this.smallStore[0].get(n);
        if (n2 == -1) {
            return null;
        }
        if (n2 == -2) {
            return this.getDelegate(n);
        }
        int n3 = this.smallStore.length;
        if (n3 == 2) {
            int n4 = this.smallStore[1].get(n);
            if (n4 == -1) {
                return SparseIntSet.singleton(n2);
            }
            return SparseIntSet.pair(n2, n4);
        }
        if (n3 == 1) {
            return SparseIntSet.singleton(n2);
        }
        int n5 = this.smallStore[1].get(n);
        if (n5 == -1) {
            return SparseIntSet.singleton(n2);
        }
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.createMutableSparseIntSet(n3);
        int n6 = 0;
        while (n6 < this.smallStore.length) {
            if (this.smallStore[n6].get(n) == -1) break;
            mutableSparseIntSet.add(this.smallStore[n6].get(n));
            ++n6;
        }
        return mutableSparseIntSet;
    }

    @Override
    public int getRelatedCount(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("x must be greater than zero");
        }
        if (!this.anyRelated(n)) {
            return 0;
        }
        if (this.usingDelegate(n)) {
            return this.getDelegate(n).size();
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.smallStore.length) {
            if (this.smallStore[n3].get(n) == -1) break;
            ++n2;
            ++n3;
        }
        return n2;
    }

    @Override
    public void remove(int n, int n2) {
        block9: {
            block8: {
                if (n < 0) {
                    throw new IllegalArgumentException("illegal x: " + n);
                }
                if (n2 < 0) {
                    throw new IllegalArgumentException("illegal y: " + n2);
                }
                if (!this.usingDelegate(n)) break block8;
                MutableIntSet mutableIntSet = (MutableIntSet)this.delegateStore.get(n);
                mutableIntSet.remove(n2);
                if (mutableIntSet.size() != 0) break block9;
                this.delegateStore.set(n, null);
                int n3 = 0;
                while (n3 < this.smallStore.length) {
                    this.smallStore[n3].set(n, -1);
                    ++n3;
                }
                break block9;
            }
            int n4 = 0;
            while (n4 < this.smallStore.length) {
                if (this.smallStore[n4].get(n) == n2) {
                    int n5 = n4;
                    while (n5 < this.smallStore.length) {
                        if (n5 < this.smallStore.length - 1) {
                            this.smallStore[n5].set(n, this.smallStore[n5 + 1].get(n));
                        } else {
                            this.smallStore[n5].set(n, -1);
                        }
                        ++n5;
                    }
                    return;
                }
                ++n4;
            }
        }
    }

    @Override
    public void removeAll(int n) {
        int n2 = 0;
        while (n2 < this.smallStore.length) {
            this.smallStore[n2].set(n, -1);
            ++n2;
        }
        this.delegateStore.set(n, null);
    }

    @Override
    public void performVerboseAction() {
    }

    private int countPairs() {
        int n = 0;
        Iterator<IntPair> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    @Override
    public boolean contains(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid x: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid y: " + n2);
        }
        if (this.usingDelegate(n)) {
            return this.getDelegate(n).contains(n2);
        }
        int n3 = 0;
        while (n3 < this.smallStore.length) {
            if (this.smallStore[n3].get(n) == n2) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public int maxKeyValue() {
        return this.maxX;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n <= this.maxX) {
            stringBuffer.append(n).append(":");
            stringBuffer.append(this.getRelated(n));
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TotalIterator
    implements Iterator<IntPair> {
        private int nextX = -1;
        private int nextIndex = -1;
        private IntIterator delegateIterator = null;

        TotalIterator() {
            this.advanceX();
        }

        private void advanceX() {
            this.delegateIterator = null;
            int n = this.nextX + 1;
            while (n <= BasicNaturalRelation.this.maxX) {
                if (BasicNaturalRelation.this.anyRelated(n)) {
                    this.nextX = n;
                    this.nextIndex = this.getFirstIndex(n);
                    if (this.nextIndex == BasicNaturalRelation.this.smallStore.length) {
                        IntSet intSet = BasicNaturalRelation.this.delegateStore.get(n);
                        assert (intSet.size() > 0);
                        this.delegateIterator = intSet.intIterator();
                    }
                    return;
                }
                ++n;
            }
            this.nextX = -1;
        }

        private int getFirstIndex(int n) {
            if (BasicNaturalRelation.this.smallStore[0].get(n) >= 0) {
                return 0;
            }
            return BasicNaturalRelation.this.smallStore.length;
        }

        @Override
        public boolean hasNext() {
            return this.nextX != -1;
        }

        @Override
        public IntPair next() {
            IntPair intPair = null;
            if (this.nextIndex == BasicNaturalRelation.this.smallStore.length) {
                int n = this.delegateIterator.next();
                intPair = new IntPair(this.nextX, n);
                if (!this.delegateIterator.hasNext()) {
                    this.advanceX();
                }
            } else {
                intPair = new IntPair(this.nextX, BasicNaturalRelation.this.smallStore[this.nextIndex].get(this.nextX));
                if (this.nextIndex == BasicNaturalRelation.this.smallStore.length - 1 || BasicNaturalRelation.this.smallStore[this.nextIndex + 1].get(this.nextX) == -1) {
                    this.advanceX();
                } else {
                    ++this.nextIndex;
                }
            }
            return intPair;
        }

        @Override
        public void remove() {
            Assertions.UNREACHABLE();
        }
    }
}

