/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.BitVectorBase;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;
import com.ibm.wala.util.intset.TunedMutableSparseIntSet;

public class BimodalMutableIntSet
implements MutableIntSet {
    MutableIntSet impl;

    public void copySet(IntSet intSet) {
        if (intSet == null) {
            throw new IllegalArgumentException("null set");
        }
        if (intSet instanceof BimodalMutableIntSet) {
            this.impl = IntSetUtil.makeMutableCopy(((BimodalMutableIntSet)intSet).impl);
        } else if (this.sameRepresentation(this.impl, intSet)) {
            this.impl.copySet(intSet);
        } else if (intSet instanceof BitVectorIntSet || intSet instanceof SparseIntSet) {
            this.impl = IntSetUtil.makeMutableCopy(intSet);
        } else if (intSet instanceof MutableSharedBitVectorIntSet) {
            this.impl = IntSetUtil.makeMutableCopy(((MutableSharedBitVectorIntSet)intSet).makeSparseCopy());
        } else {
            Assertions.UNREACHABLE("Unexpected type " + intSet.getClass());
        }
        assert (this.impl instanceof BitVectorIntSet || this.impl instanceof MutableSparseIntSet);
    }

    private boolean sameRepresentation(IntSet intSet, IntSet intSet2) {
        return intSet.getClass().equals(intSet2.getClass());
    }

    public boolean addAll(IntSet intSet) {
        boolean bl;
        if (intSet instanceof BitVectorIntSet && !(this.impl instanceof BitVectorIntSet)) {
            this.impl = new BitVectorIntSet(this.impl);
        }
        if (bl = this.impl.addAll(intSet)) {
            this.maybeChangeRepresentation();
        }
        return bl;
    }

    public boolean addAllInIntersection(IntSet intSet, IntSet intSet2) {
        boolean bl;
        if (intSet instanceof BitVectorIntSet && !(this.impl instanceof BitVectorIntSet)) {
            this.impl = new BitVectorIntSet(this.impl);
        }
        if (bl = this.impl.addAllInIntersection(intSet, intSet2)) {
            this.maybeChangeRepresentation();
        }
        return bl;
    }

    private void maybeChangeRepresentation() {
        assert (this.impl instanceof BitVectorIntSet || this.impl instanceof MutableSparseIntSet);
        if (this.impl == null) {
            return;
        }
        int n = this.impl.size();
        if (n <= 2) {
            return;
        }
        int n2 = BitVectorBase.subscript(this.impl.max()) + 1;
        if (n > n2) {
            if (!(this.impl instanceof BitVectorIntSet)) {
                this.impl = new BitVectorIntSet(this.impl);
            }
        } else if (!(this.impl instanceof MutableSparseIntSet)) {
            this.impl = MutableSparseIntSet.make(this.impl);
        }
        assert (this.impl instanceof BitVectorIntSet || this.impl instanceof MutableSparseIntSet);
    }

    public boolean add(int n) {
        boolean bl = this.impl.add(n);
        if (bl) {
            this.maybeChangeRepresentation();
        }
        return bl;
    }

    public boolean remove(int n) {
        boolean bl = this.impl.remove(n);
        this.maybeChangeRepresentation();
        return bl;
    }

    public void intersectWith(IntSet intSet) throws UnimplementedError {
        if (intSet == null) {
            throw new IllegalArgumentException("null set");
        }
        if (intSet instanceof BimodalMutableIntSet) {
            BimodalMutableIntSet bimodalMutableIntSet = (BimodalMutableIntSet)intSet;
            this.impl.intersectWith(bimodalMutableIntSet.impl);
        } else {
            Assertions.UNREACHABLE();
        }
    }

    public boolean contains(int n) {
        return this.impl.contains(n);
    }

    public IntSet intersection(IntSet intSet) throws UnimplementedError {
        if (intSet instanceof BimodalMutableIntSet) {
            BimodalMutableIntSet bimodalMutableIntSet = (BimodalMutableIntSet)intSet;
            return this.impl.intersection(bimodalMutableIntSet.impl);
        }
        if (intSet instanceof BitVectorIntSet) {
            return this.impl.intersection(intSet);
        }
        Assertions.UNREACHABLE("Unexpected: " + intSet);
        return null;
    }

    public IntSet union(IntSet intSet) {
        BimodalMutableIntSet bimodalMutableIntSet = new BimodalMutableIntSet();
        bimodalMutableIntSet.addAll(this);
        bimodalMutableIntSet.addAll(intSet);
        return bimodalMutableIntSet;
    }

    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    public int size() {
        return this.impl.size();
    }

    public IntIterator intIterator() {
        return this.impl.intIterator();
    }

    public void foreach(IntSetAction intSetAction) {
        this.impl.foreach(intSetAction);
    }

    public void foreachExcluding(IntSet intSet, IntSetAction intSetAction) {
        this.impl.foreachExcluding(intSet, intSetAction);
    }

    public int max() throws IllegalStateException {
        return this.impl.max();
    }

    public static BimodalMutableIntSet makeCopy(IntSet intSet) throws UnimplementedError, IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("B == null");
        }
        if (intSet instanceof BimodalMutableIntSet) {
            BimodalMutableIntSet bimodalMutableIntSet = (BimodalMutableIntSet)intSet;
            BimodalMutableIntSet bimodalMutableIntSet2 = new BimodalMutableIntSet();
            bimodalMutableIntSet2.impl = IntSetUtil.makeMutableCopy(bimodalMutableIntSet.impl);
            return bimodalMutableIntSet2;
        }
        if (intSet instanceof MutableSharedBitVectorIntSet) {
            BimodalMutableIntSet bimodalMutableIntSet = new BimodalMutableIntSet();
            MutableSharedBitVectorIntSet mutableSharedBitVectorIntSet = (MutableSharedBitVectorIntSet)intSet;
            bimodalMutableIntSet.impl = IntSetUtil.makeMutableCopy(mutableSharedBitVectorIntSet.makeSparseCopy());
            assert (bimodalMutableIntSet.impl instanceof BitVectorIntSet || bimodalMutableIntSet.impl instanceof MutableSparseIntSet);
            return bimodalMutableIntSet;
        }
        BimodalMutableIntSet bimodalMutableIntSet = new BimodalMutableIntSet();
        bimodalMutableIntSet.impl = IntSetUtil.makeMutableCopy(intSet);
        assert (bimodalMutableIntSet.impl instanceof BitVectorIntSet || bimodalMutableIntSet.impl instanceof MutableSparseIntSet);
        return bimodalMutableIntSet;
    }

    public BimodalMutableIntSet() {
        this.impl = MutableSparseIntSet.makeEmpty();
    }

    public BimodalMutableIntSet(int n, float f) {
        this.impl = new TunedMutableSparseIntSet(n, f);
    }

    public void clear() {
        this.impl = MutableSparseIntSet.makeEmpty();
    }

    public BimodalMutableIntSet(BimodalMutableIntSet bimodalMutableIntSet) {
        if (bimodalMutableIntSet == null) {
            throw new IllegalArgumentException("x is null");
        }
        this.impl = IntSetUtil.makeMutableCopy(bimodalMutableIntSet.impl);
        assert (this.impl instanceof BitVectorIntSet || this.impl instanceof MutableSparseIntSet);
    }

    public boolean sameValue(IntSet intSet) {
        return this.impl.sameValue(intSet);
    }

    public boolean isSubset(IntSet intSet) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (intSet instanceof BimodalMutableIntSet) {
            BimodalMutableIntSet bimodalMutableIntSet = (BimodalMutableIntSet)intSet;
            return this.impl.isSubset(bimodalMutableIntSet.impl);
        }
        BitVectorIntSet bitVectorIntSet = new BitVectorIntSet(this);
        BitVectorIntSet bitVectorIntSet2 = new BitVectorIntSet(intSet);
        return bitVectorIntSet.isSubset(bitVectorIntSet2);
    }

    public IntSet getBackingStore() {
        return this.impl;
    }

    public String toString() {
        return this.impl.toString();
    }

    public boolean containsAny(IntSet intSet) throws IllegalArgumentException, UnimplementedError {
        if (intSet == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (intSet instanceof BimodalMutableIntSet) {
            BimodalMutableIntSet bimodalMutableIntSet = (BimodalMutableIntSet)intSet;
            return this.impl.containsAny(bimodalMutableIntSet.impl);
        }
        if (intSet instanceof SparseIntSet) {
            return this.impl.containsAny(intSet);
        }
        if (intSet instanceof BitVectorIntSet) {
            return this.impl.containsAny(intSet);
        }
        Assertions.UNREACHABLE("unsupported " + intSet.getClass());
        return false;
    }

    public boolean removeAll(IntSet intSet) {
        if (intSet == null) {
            throw new IllegalArgumentException("that is null");
        }
        boolean bl = false;
        IntIterator intIterator = intSet.intIterator();
        while (intIterator.hasNext()) {
            bl |= this.remove(intIterator.next());
        }
        return bl;
    }

    public boolean containsAll(BimodalMutableIntSet bimodalMutableIntSet) {
        if (bimodalMutableIntSet == null) {
            throw new IllegalArgumentException("that is null");
        }
        IntIterator intIterator = bimodalMutableIntSet.intIterator();
        while (intIterator.hasNext()) {
            if (this.contains(intIterator.next())) continue;
            return false;
        }
        return true;
    }
}

