/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.HashSet;

class DebuggingMutableIntSet
implements MutableIntSet {
    final MutableIntSet primaryImpl;
    final MutableIntSet secondaryImpl;

    DebuggingMutableIntSet(MutableIntSet mutableIntSet, MutableIntSet mutableIntSet2) {
        this.primaryImpl = mutableIntSet;
        this.secondaryImpl = mutableIntSet2;
    }

    private void assertEquiv() {
        assert (this.primaryImpl.sameValue(this.secondaryImpl));
    }

    public void clear() {
        this.primaryImpl.clear();
        this.secondaryImpl.clear();
    }

    public boolean contains(int n) {
        assert (this.primaryImpl.contains(n) == this.secondaryImpl.contains(n));
        return this.primaryImpl.contains(n);
    }

    public boolean isEmpty() {
        if (this.primaryImpl.isEmpty() != this.secondaryImpl.isEmpty()) {
            System.err.println(this.primaryImpl + ".isEmpty() = " + this.primaryImpl.isEmpty() + " and " + this.secondaryImpl + ".isEmpty() = " + this.secondaryImpl.isEmpty());
            Assertions.UNREACHABLE();
        }
        return this.primaryImpl.isEmpty();
    }

    public int size() {
        if (this.primaryImpl.size() != this.secondaryImpl.size()) assert (this.primaryImpl.size() == this.secondaryImpl.size()) : "size " + this.primaryImpl.size() + " of " + this.primaryImpl + " differs from " + "size " + this.secondaryImpl.size() + " of " + this.secondaryImpl;
        return this.primaryImpl.size();
    }

    public int max() {
        assert (this.primaryImpl.max() == this.secondaryImpl.max());
        return this.primaryImpl.max();
    }

    public boolean add(int n) {
        boolean bl;
        boolean bl2 = this.primaryImpl.add(n);
        if (bl2 != (bl = this.secondaryImpl.add(n))) assert (bl2 == bl) : "adding " + n + " to " + this.primaryImpl + " returns " + bl2 + ", but adding " + n + " to " + this.secondaryImpl + " returns " + bl;
        return bl2;
    }

    public boolean remove(int n) {
        boolean bl = this.primaryImpl.remove(n);
        this.secondaryImpl.remove(n);
        this.assertEquiv();
        return bl;
    }

    public boolean containsAny(IntSet intSet) {
        if (intSet instanceof DebuggingMutableIntSet) {
            boolean bl;
            DebuggingMutableIntSet debuggingMutableIntSet = (DebuggingMutableIntSet)intSet;
            boolean bl2 = this.primaryImpl.containsAny(debuggingMutableIntSet.primaryImpl);
            if (bl2 != (bl = this.secondaryImpl.containsAny(debuggingMutableIntSet.secondaryImpl))) assert (bl2 == bl) : "containsAny " + this + " " + intSet + " " + bl2 + " " + bl;
            return bl2;
        }
        Assertions.UNREACHABLE();
        return false;
    }

    public IntSet intersection(IntSet intSet) {
        if (intSet instanceof DebuggingMutableIntSet) {
            DebuggingMutableIntSet debuggingMutableIntSet = (DebuggingMutableIntSet)intSet;
            IntSet intSet2 = this.primaryImpl.intersection(debuggingMutableIntSet.primaryImpl);
            IntSet intSet3 = this.secondaryImpl.intersection(debuggingMutableIntSet.secondaryImpl);
            assert (intSet2.sameValue(intSet3));
            return intSet2;
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public IntSet union(IntSet intSet) {
        MutableSparseIntSet mutableSparseIntSet = new MutableSparseIntSet();
        mutableSparseIntSet.addAll(this);
        mutableSparseIntSet.addAll(intSet);
        return mutableSparseIntSet;
    }

    public boolean sameValue(IntSet intSet) {
        if (intSet instanceof DebuggingMutableIntSet) {
            DebuggingMutableIntSet debuggingMutableIntSet = (DebuggingMutableIntSet)intSet;
            boolean bl = this.primaryImpl.sameValue(debuggingMutableIntSet.primaryImpl);
            boolean bl2 = this.secondaryImpl.sameValue(debuggingMutableIntSet.secondaryImpl);
            assert (bl == bl2);
            return bl;
        }
        Assertions.UNREACHABLE();
        return false;
    }

    public boolean isSubset(IntSet intSet) {
        if (intSet instanceof DebuggingMutableIntSet) {
            DebuggingMutableIntSet debuggingMutableIntSet = (DebuggingMutableIntSet)intSet;
            boolean bl = this.primaryImpl.isSubset(debuggingMutableIntSet.primaryImpl);
            boolean bl2 = this.secondaryImpl.isSubset(debuggingMutableIntSet.secondaryImpl);
            assert (bl == bl2);
            return bl;
        }
        Assertions.UNREACHABLE();
        return false;
    }

    public void copySet(IntSet intSet) {
        if (intSet instanceof DebuggingMutableIntSet) {
            DebuggingMutableIntSet debuggingMutableIntSet = (DebuggingMutableIntSet)intSet;
            this.primaryImpl.copySet(debuggingMutableIntSet.primaryImpl);
            this.secondaryImpl.copySet(debuggingMutableIntSet.secondaryImpl);
            assert (this.primaryImpl.sameValue(this.secondaryImpl));
        } else {
            Assertions.UNREACHABLE();
        }
    }

    public boolean addAll(IntSet intSet) {
        if (intSet instanceof DebuggingMutableIntSet) {
            boolean bl;
            DebuggingMutableIntSet debuggingMutableIntSet = (DebuggingMutableIntSet)intSet;
            int n = this.primaryImpl.size();
            int n2 = this.secondaryImpl.size();
            boolean bl2 = this.primaryImpl.addAll(debuggingMutableIntSet.primaryImpl);
            if (bl2 != (bl = this.secondaryImpl.addAll(debuggingMutableIntSet.secondaryImpl))) {
                System.err.println("ppr was " + bl2 + " (should be " + (n != this.primaryImpl.size()) + ") but ssr was " + bl + " (should be " + (n2 != this.secondaryImpl.size()) + ")");
                System.err.println("adding " + intSet + " to " + this + " failed");
                Assertions.UNREACHABLE();
            }
            return bl2;
        }
        Assertions.UNREACHABLE();
        return false;
    }

    public void intersectWith(IntSet intSet) {
        if (intSet instanceof DebuggingMutableIntSet) {
            DebuggingMutableIntSet debuggingMutableIntSet = (DebuggingMutableIntSet)intSet;
            this.primaryImpl.intersectWith(debuggingMutableIntSet.primaryImpl);
            this.secondaryImpl.intersectWith(debuggingMutableIntSet.secondaryImpl);
            if (!this.primaryImpl.sameValue(this.secondaryImpl)) assert (false) : this + " (" + this.primaryImpl.size() + ", " + this.secondaryImpl.size() + ") inconsistent after intersecting with " + intSet;
        } else {
            Assertions.UNREACHABLE();
        }
    }

    public boolean addAllInIntersection(IntSet intSet, IntSet intSet2) {
        if (intSet instanceof DebuggingMutableIntSet && intSet2 instanceof DebuggingMutableIntSet) {
            DebuggingMutableIntSet debuggingMutableIntSet = (DebuggingMutableIntSet)intSet;
            DebuggingMutableIntSet debuggingMutableIntSet2 = (DebuggingMutableIntSet)intSet2;
            boolean bl = this.primaryImpl.addAllInIntersection(debuggingMutableIntSet.primaryImpl, debuggingMutableIntSet2.primaryImpl);
            boolean bl2 = this.secondaryImpl.addAllInIntersection(debuggingMutableIntSet.secondaryImpl, debuggingMutableIntSet2.secondaryImpl);
            assert (bl == bl2);
            return bl;
        }
        Assertions.UNREACHABLE();
        return false;
    }

    public IntIterator intIterator() {
        int n;
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        IntIterator intIterator = this.primaryImpl.intIterator();
        while (intIterator.hasNext()) {
            n = intIterator.next();
            assert (!mutableSparseIntSet.contains(n));
            mutableSparseIntSet.add(n);
        }
        intIterator = this.secondaryImpl.intIterator();
        while (intIterator.hasNext()) {
            n = intIterator.next();
            assert (mutableSparseIntSet.contains(n));
            mutableSparseIntSet.remove(n);
        }
        assert (mutableSparseIntSet.isEmpty());
        return this.primaryImpl.intIterator();
    }

    public void foreach(IntSetAction intSetAction) {
        final HashSet hashSet = HashSetFactory.make();
        this.primaryImpl.foreach(new IntSetAction(){

            public void act(int n) {
                if (!$assertionsDisabled && hashSet.contains(new Integer(n))) {
                    throw new AssertionError();
                }
                hashSet.add(new Integer(n));
            }
        });
        this.secondaryImpl.foreach(new IntSetAction(){

            public void act(int n) {
                if (!$assertionsDisabled && !hashSet.contains(new Integer(n))) {
                    throw new AssertionError();
                }
                hashSet.remove(new Integer(n));
            }
        });
        assert (hashSet.isEmpty());
        this.primaryImpl.foreach(intSetAction);
    }

    public void foreachExcluding(IntSet intSet, IntSetAction intSetAction) {
        final HashSet hashSet = HashSetFactory.make();
        this.primaryImpl.foreachExcluding(intSet, new IntSetAction(){

            public void act(int n) {
                if (!$assertionsDisabled && hashSet.contains(new Integer(n))) {
                    throw new AssertionError();
                }
                hashSet.add(new Integer(n));
            }
        });
        this.secondaryImpl.foreachExcluding(intSet, new IntSetAction(){

            public void act(int n) {
                if (!$assertionsDisabled && !hashSet.contains(new Integer(n))) {
                    throw new AssertionError();
                }
                hashSet.remove(new Integer(n));
            }
        });
        assert (hashSet.isEmpty());
        this.primaryImpl.foreachExcluding(intSet, intSetAction);
    }

    public String toString() {
        return "[[P " + this.primaryImpl.toString() + ", S " + this.secondaryImpl.toString() + " ]]";
    }
}

