/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.Bits;
import java.io.Serializable;

public final class FixedSizeBitVector
implements Cloneable,
Serializable {
    public static final long serialVersionUID = 33181877746462822L;
    private static final int LOG_BITS_PER_UNIT = 5;
    private static final int MASK = -1;
    private static final int LOW_MASK = 31;
    private int[] bits;
    private final int nbits;

    private static int subscript(int n) {
        return n >> 5;
    }

    public FixedSizeBitVector(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal nbits: " + n);
        }
        this.bits = new int[FixedSizeBitVector.subscript(n) + 1];
        this.nbits = n;
    }

    public FixedSizeBitVector(FixedSizeBitVector fixedSizeBitVector) {
        if (fixedSizeBitVector == null) {
            throw new IllegalArgumentException("s is null");
        }
        this.bits = new int[fixedSizeBitVector.bits.length];
        this.nbits = fixedSizeBitVector.nbits;
        this.copyBits(fixedSizeBitVector);
    }

    public void setAll() {
        int n = 0;
        while (n < this.bits.length) {
            this.bits[n] = -1;
            ++n;
        }
    }

    public void set(int n) {
        try {
            int n2 = n & 0x1F;
            int n3 = FixedSizeBitVector.subscript(n);
            this.bits[n3] = this.bits[n3] | 1 << n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid bit " + n);
        }
    }

    public void clearAll() {
        int n = 0;
        while (n < this.bits.length) {
            this.bits[n] = 0;
            ++n;
        }
    }

    public void clear(int n) {
        try {
            int n2 = n & 0x1F;
            int n3 = FixedSizeBitVector.subscript(n);
            this.bits[n3] = this.bits[n3] & ~(1 << n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("invalid bit: " + n);
        }
    }

    public boolean get(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal bit: " + n);
        }
        int n2 = n & 0x1F;
        int n3 = FixedSizeBitVector.subscript(n);
        try {
            return (this.bits[n3] & 1 << n2) != 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    public void not() {
        int n = 0;
        while (n < this.bits.length) {
            int n2 = n++;
            this.bits[n2] = ~this.bits[n2];
        }
    }

    public static FixedSizeBitVector not(FixedSizeBitVector fixedSizeBitVector) {
        FixedSizeBitVector fixedSizeBitVector2 = new FixedSizeBitVector(fixedSizeBitVector);
        fixedSizeBitVector2.not();
        return fixedSizeBitVector2;
    }

    public void and(FixedSizeBitVector fixedSizeBitVector) {
        int n;
        if (fixedSizeBitVector == null) {
            throw new IllegalArgumentException("null set");
        }
        if (this == fixedSizeBitVector) {
            return;
        }
        int n2 = n = this.bits.length;
        while (n2-- > 0) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] & fixedSizeBitVector.bits[n2];
        }
    }

    public static FixedSizeBitVector and(FixedSizeBitVector fixedSizeBitVector, FixedSizeBitVector fixedSizeBitVector2) {
        FixedSizeBitVector fixedSizeBitVector3 = new FixedSizeBitVector(fixedSizeBitVector);
        fixedSizeBitVector3.and(fixedSizeBitVector2);
        return fixedSizeBitVector3;
    }

    public void or(FixedSizeBitVector fixedSizeBitVector) throws IllegalArgumentException {
        int n;
        if (fixedSizeBitVector == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (this == fixedSizeBitVector) {
            return;
        }
        int n2 = n = fixedSizeBitVector.bits.length;
        while (n2-- > 0) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] | fixedSizeBitVector.bits[n2];
        }
    }

    public static FixedSizeBitVector or(FixedSizeBitVector fixedSizeBitVector, FixedSizeBitVector fixedSizeBitVector2) throws IllegalArgumentException {
        if (fixedSizeBitVector2 == null) {
            throw new IllegalArgumentException("b2 == null");
        }
        FixedSizeBitVector fixedSizeBitVector3 = new FixedSizeBitVector(fixedSizeBitVector);
        fixedSizeBitVector3.or(fixedSizeBitVector2);
        return fixedSizeBitVector3;
    }

    public void xor(FixedSizeBitVector fixedSizeBitVector) {
        int n;
        if (fixedSizeBitVector == null) {
            throw new IllegalArgumentException("set is null");
        }
        int n2 = n = fixedSizeBitVector.bits.length;
        while (n2-- > 0) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] ^ fixedSizeBitVector.bits[n2];
        }
    }

    public boolean intersectionEmpty(FixedSizeBitVector fixedSizeBitVector) {
        int n;
        if (fixedSizeBitVector == null) {
            throw new IllegalArgumentException("other is null");
        }
        int n2 = n = this.bits.length;
        while (n2-- > 0) {
            if ((this.bits[n2] & fixedSizeBitVector.bits[n2]) == 0) continue;
            return false;
        }
        return true;
    }

    public void copyBits(FixedSizeBitVector fixedSizeBitVector) {
        int n;
        if (fixedSizeBitVector == null) {
            throw new IllegalArgumentException("set is null");
        }
        int n2 = n = fixedSizeBitVector.bits.length;
        while (n2-- > 0) {
            this.bits[n2] = fixedSizeBitVector.bits[n2];
        }
    }

    public int hashCode() {
        int n = 1234;
        int n2 = this.bits.length;
        while (--n2 >= 0) {
            n ^= this.bits[n2] * (n2 + 1);
        }
        return n;
    }

    public int populationCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.bits.length) {
            n += Bits.populationCount(this.bits[n2]);
            ++n2;
        }
        return n;
    }

    public int length() {
        return this.bits.length << 5;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof FixedSizeBitVector) {
            if (this == object) {
                return true;
            }
            FixedSizeBitVector fixedSizeBitVector = (FixedSizeBitVector)object;
            int n = this.bits.length;
            if (n != fixedSizeBitVector.bits.length) {
                return false;
            }
            int n2 = n;
            while (n2-- > 0) {
                if (this.bits[n2] == fixedSizeBitVector.bits[n2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isZero() {
        int n;
        int n2 = n = this.bits.length;
        while (n2-- > 0) {
            if (this.bits[n2] == 0) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        FixedSizeBitVector fixedSizeBitVector = null;
        try {
            fixedSizeBitVector = (FixedSizeBitVector)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        fixedSizeBitVector.bits = new int[this.bits.length];
        System.arraycopy(this.bits, 0, fixedSizeBitVector.bits, 0, fixedSizeBitVector.bits.length);
        return fixedSizeBitVector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        stringBuffer.append('{');
        int n = this.nbits;
        int n2 = 0;
        while (n2 < n) {
            if (this.get(n2)) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                stringBuffer.append(n2);
            }
            ++n2;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

