/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.BitVectorBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OffsetBitVector
extends BitVectorBase<OffsetBitVector> {
    int offset;

    private int wordDiff(int n, int n2) {
        return n > n2 ? n - n2 >> 5 : -(n2 - n >> 5);
    }

    private void expand(int n, int n2) {
        int n3 = this.wordDiff(n, this.offset);
        int[] nArray = this.bits;
        this.bits = new int[OffsetBitVector.subscript(n2) + 1];
        int n4 = 0;
        while (n4 < nArray.length) {
            this.bits[n4 - n3] = nArray[n4];
            ++n4;
        }
        this.offset = n;
    }

    private void ensureCapacity(int n, int n2) {
        if (n < this.offset || n2 > this.bits.length << 5) {
            this.expand(n, n2);
        }
    }

    public OffsetBitVector() {
        this(0, 1);
    }

    public OffsetBitVector(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid nbits: " + n2);
        }
        if (n < 0) {
            throw new IllegalArgumentException("invalid offset: " + n);
        }
        this.offset = n &= 0xFFFFFFE0;
        this.bits = new int[OffsetBitVector.subscript(n2) + 1];
    }

    public OffsetBitVector(OffsetBitVector offsetBitVector) {
        if (offsetBitVector == null) {
            throw new IllegalArgumentException("s is null");
        }
        this.offset = offsetBitVector.offset;
        this.bits = new int[offsetBitVector.bits.length];
        System.arraycopy(offsetBitVector.bits, 0, this.bits, 0, offsetBitVector.bits.length);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "(offset:" + this.offset + ")";
    }

    void growCapacity(float f) {
        this.expand(this.offset, (int)(f * (float)(this.bits.length << 5)));
    }

    public int getOffset() {
        return this.offset;
    }

    int getSize() {
        return this.bits.length;
    }

    @Override
    public final void set(int n) {
        int n2;
        int n3;
        if (n < 0) {
            throw new IllegalArgumentException("illegal bit: " + n);
        }
        if (n < this.offset) {
            int n4 = n & 0xFFFFFFE0;
            this.expand(n4, this.length() - 1 - n4);
            n3 = n & 0x1F;
            n2 = 0;
        } else {
            n3 = (n -= this.offset) & 0x1F;
            n2 = OffsetBitVector.subscript(n);
            if (n2 >= this.bits.length) {
                this.expand(this.offset, n);
            }
        }
        try {
            int n5 = n2;
            this.bits[n5] = this.bits[n5] | 1 << n3;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    @Override
    public final void clear(int n) {
        if (n < this.offset) {
            return;
        }
        int n2 = OffsetBitVector.subscript(n -= this.offset);
        if (n2 >= this.bits.length) {
            return;
        }
        int n3 = n & 0x1F;
        int n4 = n2;
        this.bits[n4] = this.bits[n4] & ~(1 << n3);
    }

    @Override
    public final boolean get(int n) {
        if (n < this.offset) {
            return false;
        }
        int n2 = OffsetBitVector.subscript(n -= this.offset);
        if (n2 >= this.bits.length) {
            return false;
        }
        int n3 = n & 0x1F;
        return (this.bits[n2] & 1 << n3) != 0;
    }

    @Override
    public int nextSetBit(int n) {
        int n2 = super.nextSetBit(Math.max(0, n - this.offset));
        return n2 == -1 ? -1 : this.offset + n2;
    }

    public final void not() {
        if (this.offset != 0) {
            this.expand(0, this.offset + this.length() - 1);
        }
        int n = 0;
        while (n < this.bits.length) {
            int n2 = n++;
            this.bits[n2] = ~this.bits[n2];
        }
    }

    @Override
    public int max() {
        return super.max() + this.offset;
    }

    @Override
    public final int length() {
        return (this.bits.length << 5) + this.offset;
    }

    public final void setAll() {
        this.expand(0, this.length() - 1);
        int n = 0;
        while (n < this.bits.length) {
            this.bits[n] = -1;
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof OffsetBitVector) {
            if (this == object) {
                return true;
            }
            OffsetBitVector offsetBitVector = (OffsetBitVector)object;
            return this.sameBits(offsetBitVector);
        }
        return false;
    }

    @Override
    public final boolean intersectionEmpty(OffsetBitVector offsetBitVector) throws IllegalArgumentException {
        if (offsetBitVector == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (this == offsetBitVector) {
            return this.isZero();
        }
        int n = this.wordDiff(this.offset, offsetBitVector.offset);
        int n2 = Math.min(this.bits.length, offsetBitVector.bits.length - n);
        int n3 = Math.max(0, -n);
        while (n3 < n2) {
            if ((this.bits[n3] & offsetBitVector.bits[n3 + n]) != 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    @Override
    public final boolean sameBits(OffsetBitVector offsetBitVector) throws IllegalArgumentException {
        int n;
        if (offsetBitVector == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (this == offsetBitVector) {
            return true;
        }
        int n2 = this.wordDiff(this.offset, offsetBitVector.offset);
        int n3 = Math.min(this.bits.length, offsetBitVector.bits.length - n2);
        int n4 = 0;
        if (n2 < 0) {
            while (n4 < -n2) {
                if (this.bits[n4] != 0) {
                    return false;
                }
                ++n4;
            }
        } else {
            n = 0;
            while (n < n2) {
                if (offsetBitVector.bits[n] != 0) {
                    return false;
                }
                ++n;
            }
        }
        while (n4 < n3) {
            if (this.bits[n4] != offsetBitVector.bits[n4 + n2]) {
                return false;
            }
            ++n4;
        }
        n = n3 + n2;
        while (n < offsetBitVector.bits.length) {
            if (offsetBitVector.bits[n] != 0) {
                return false;
            }
            ++n;
        }
        while (n4 < this.bits.length) {
            if (this.bits[n4] != 0) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    @Override
    public boolean isSubset(OffsetBitVector offsetBitVector) throws IllegalArgumentException {
        if (offsetBitVector == null) {
            throw new IllegalArgumentException("other == null");
        }
        if (this == offsetBitVector) {
            return true;
        }
        int n = this.wordDiff(this.offset, offsetBitVector.offset);
        int n2 = Math.min(this.bits.length, offsetBitVector.bits.length - n);
        int n3 = 0;
        while (n3 < -n) {
            if (this.bits[n3] != 0) {
                return false;
            }
            ++n3;
        }
        while (n3 < n2) {
            if ((this.bits[n3] & ~offsetBitVector.bits[n3 + n]) != 0) {
                return false;
            }
            ++n3;
        }
        while (n3 < this.bits.length) {
            if (this.bits[n3] != 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public final void copyBits(OffsetBitVector offsetBitVector) {
        if (offsetBitVector == null) {
            throw new IllegalArgumentException("set is null");
        }
        super.copyBits(offsetBitVector);
        this.offset = offsetBitVector.offset;
    }

    @Override
    public final void and(OffsetBitVector offsetBitVector) throws IllegalArgumentException {
        if (offsetBitVector == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (this == offsetBitVector) {
            return;
        }
        int n = this.wordDiff(this.offset, offsetBitVector.offset);
        int n2 = Math.min(this.bits.length, offsetBitVector.bits.length - n);
        int n3 = 0;
        while (n3 < -n) {
            this.bits[n3] = 0;
            ++n3;
        }
        while (n3 < n2) {
            int n4 = n3;
            this.bits[n4] = this.bits[n4] & offsetBitVector.bits[n3 + n];
            ++n3;
        }
        while (n3 < this.bits.length) {
            this.bits[n3] = 0;
            ++n3;
        }
    }

    @Override
    public final void or(OffsetBitVector offsetBitVector) throws IllegalArgumentException {
        if (offsetBitVector == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (this == offsetBitVector) {
            return;
        }
        int n = Math.min(this.offset, offsetBitVector.offset);
        int n2 = Math.max(this.length(), offsetBitVector.length()) - n;
        this.ensureCapacity(n, n2);
        int n3 = this.wordDiff(n, offsetBitVector.offset);
        int n4 = 0;
        while (n4 < offsetBitVector.bits.length) {
            int n5 = n4 - n3;
            this.bits[n5] = this.bits[n5] | offsetBitVector.bits[n4];
            ++n4;
        }
    }

    @Override
    public final void xor(OffsetBitVector offsetBitVector) throws IllegalArgumentException {
        if (offsetBitVector == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (this == offsetBitVector) {
            this.clearAll();
            return;
        }
        int n = Math.min(this.offset, offsetBitVector.offset);
        int n2 = Math.max(this.length(), offsetBitVector.length()) - n;
        this.ensureCapacity(n, n2);
        int n3 = this.wordDiff(n, offsetBitVector.offset);
        int n4 = 0;
        while (n4 < offsetBitVector.bits.length) {
            int n5 = n4 - n3;
            this.bits[n5] = this.bits[n5] ^ offsetBitVector.bits[n4];
            ++n4;
        }
    }

    @Override
    public void andNot(OffsetBitVector offsetBitVector) throws IllegalArgumentException {
        if (offsetBitVector == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (this == offsetBitVector) {
            this.clearAll();
            return;
        }
        int n = this.wordDiff(this.offset, offsetBitVector.offset);
        int n2 = Math.min(this.bits.length, offsetBitVector.bits.length - n);
        int n3 = Math.max(0, -n);
        while (n3 < n2) {
            int n4 = n3;
            this.bits[n4] = this.bits[n4] & ~offsetBitVector.bits[n3 + n];
            ++n3;
        }
    }

    public static OffsetBitVector not(OffsetBitVector offsetBitVector) {
        OffsetBitVector offsetBitVector2 = new OffsetBitVector(offsetBitVector);
        offsetBitVector2.not();
        return offsetBitVector2;
    }

    public static OffsetBitVector and(OffsetBitVector offsetBitVector, OffsetBitVector offsetBitVector2) throws IllegalArgumentException {
        if (offsetBitVector2 == null) {
            throw new IllegalArgumentException("b2 == null");
        }
        OffsetBitVector offsetBitVector3 = new OffsetBitVector(offsetBitVector);
        offsetBitVector3.and(offsetBitVector2);
        return offsetBitVector3;
    }

    public static OffsetBitVector or(OffsetBitVector offsetBitVector, OffsetBitVector offsetBitVector2) throws IllegalArgumentException {
        if (offsetBitVector2 == null) {
            throw new IllegalArgumentException("b2 == null");
        }
        OffsetBitVector offsetBitVector3 = new OffsetBitVector(offsetBitVector);
        offsetBitVector3.or(offsetBitVector2);
        return offsetBitVector3;
    }

    public static OffsetBitVector andNot(OffsetBitVector offsetBitVector, OffsetBitVector offsetBitVector2) {
        OffsetBitVector offsetBitVector3 = new OffsetBitVector(offsetBitVector);
        offsetBitVector3.andNot(offsetBitVector2);
        return offsetBitVector3;
    }
}

