/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.IntVector;
import com.ibm.wala.util.intset.SparseIntVector;
import com.ibm.wala.util.math.Logs;
import java.util.Vector;

public class TwoLevelIntVector
implements IntVector {
    private static final int PAGE_SIZE = 4096;
    private static final int LOG_PAGE_SIZE = Logs.log2(4096);
    int maxIndex = -1;
    private final Vector<SparseIntVector> data = new Vector();
    private final int defaultValue;

    TwoLevelIntVector(int n) {
        this.defaultValue = n;
    }

    public int get(int n) {
        int n2 = this.getPageNumber(n);
        if (n2 >= this.data.size()) {
            return this.defaultValue;
        }
        IntVector intVector = this.data.get(n2);
        if (intVector == null) {
            return this.defaultValue;
        }
        int n3 = this.toLocalIndex(n, n2);
        return intVector.get(n3);
    }

    private int toLocalIndex(int n, int n2) {
        return n - this.getFirstIndexOnPage(n2);
    }

    private int getFirstIndexOnPage(int n) {
        return n << LOG_PAGE_SIZE;
    }

    private int getPageNumber(int n) {
        return n >> LOG_PAGE_SIZE;
    }

    public void set(int n, int n2) {
        this.maxIndex = Math.max(this.maxIndex, n);
        int n3 = this.getPageNumber(n);
        IntVector intVector = this.findOrCreatePage(n3);
        int n4 = this.toLocalIndex(n, n3);
        intVector.set(n4, n2);
    }

    private IntVector findOrCreatePage(int n) {
        if (n >= this.data.size()) {
            SparseIntVector sparseIntVector = new SparseIntVector(this.defaultValue);
            this.data.setSize(n + 1);
            this.data.add(n, sparseIntVector);
            return sparseIntVector;
        }
        SparseIntVector sparseIntVector = this.data.get(n);
        if (sparseIntVector == null) {
            sparseIntVector = new SparseIntVector(this.defaultValue);
            this.data.set(n, sparseIntVector);
        }
        return sparseIntVector;
    }

    public void performVerboseAction() {
        System.err.println("stats of " + this.getClass());
        System.err.println("data: size = " + this.data.size());
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }
}

