/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.shrike;

import com.ibm.wala.shrikeBT.BytecodeConstants;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.strings.ImmutableByteArray;
import java.util.HashMap;

public class ShrikeUtil
implements BytecodeConstants {
    private static final HashMap<String, TypeReference> primitiveMap = HashMapFactory.make(10);

    static {
        primitiveMap.put("I", TypeReference.Int);
        primitiveMap.put("J", TypeReference.Long);
        primitiveMap.put("S", TypeReference.Short);
        primitiveMap.put("B", TypeReference.Byte);
        primitiveMap.put("C", TypeReference.Char);
        primitiveMap.put("D", TypeReference.Double);
        primitiveMap.put("F", TypeReference.Float);
        primitiveMap.put("Z", TypeReference.Boolean);
        primitiveMap.put("V", TypeReference.Void);
        primitiveMap.put("L;", TypeReference.Null);
    }

    public static TypeReference makeTypeReference(ClassLoaderReference classLoaderReference, String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null type");
        }
        TypeReference typeReference = primitiveMap.get(string);
        if (typeReference != null) {
            return typeReference;
        }
        ImmutableByteArray immutableByteArray = ImmutableByteArray.make(string);
        TypeName typeName = null;
        typeName = immutableByteArray.get(immutableByteArray.length() - 1) == 59 ? TypeName.findOrCreate(immutableByteArray, 0, immutableByteArray.length() - 1) : TypeName.findOrCreate(immutableByteArray);
        return TypeReference.findOrCreate(classLoaderReference, typeName);
    }
}

