/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.tables;

import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.tables.StringTable;
import com.ibm.wala.util.tables.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query {
    public static <T> Collection<Map<String, T>> selectStarWhereEquals(Table<T> table, String string, T t) throws IllegalArgumentException {
        if (table == null) {
            throw new IllegalArgumentException("t == null");
        }
        ArrayList<Map<String, T>> arrayList = new ArrayList<Map<String, T>>();
        int n = 0;
        while (n < table.getNumberOfRows()) {
            Map<String, T> map = table.row2Map(n);
            if (map.get(string).equals(t)) {
                arrayList.add(map);
            }
            ++n;
        }
        return arrayList;
    }

    public static <T> Collection<T> selectWhereEquals(Table<T> table, String string, String string2, T t) {
        Collection<Map<String, T>> collection = Query.selectStarWhereEquals(table, string2, t);
        HashSet hashSet = HashSetFactory.make();
        for (Map<String, T> map : collection) {
            hashSet.add(map.get(string));
        }
        return hashSet;
    }

    public static <T> Collection<Map<String, T>> selectStarWhere(Table<T> table, String string, Predicate<T> predicate) {
        if (table == null) {
            throw new IllegalArgumentException("t == null");
        }
        ArrayList<Map<String, T>> arrayList = new ArrayList<Map<String, T>>();
        int n = 0;
        while (n < table.getNumberOfRows()) {
            Map<String, T> map = table.row2Map(n);
            T t = map.get(string);
            if (predicate.test(t)) {
                arrayList.add(map);
            }
            ++n;
        }
        return arrayList;
    }

    public static <T> Table<T> viewWhereEquals(Table<T> table, String string, T t) {
        Collection<Map<String, T>> collection = Query.selectStarWhereEquals(table, string, t);
        Table<T> table2 = new Table<T>(table);
        for (Map<String, T> map : collection) {
            table2.addRow(map);
        }
        return table2;
    }

    public static StringTable viewWhereEquals(StringTable stringTable, String string, String string2) {
        Collection<Map<String, String>> collection = Query.selectStarWhereEquals(stringTable, string, string2);
        StringTable stringTable2 = new StringTable(stringTable);
        for (Map<String, String> map : collection) {
            stringTable2.addRow(map);
        }
        return stringTable2;
    }
}

