/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz;

import com.ibm.wala.cfg.CFGSanitizer;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.strings.StringStuff;
import com.ibm.wala.util.warnings.WalaException;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.NodeDecorator;
import com.ibm.wala.viz.PDFViewLauncher;
import java.util.HashMap;
import java.util.Iterator;

public class PDFViewUtil {
    public static Process ghostviewIR(IClassHierarchy iClassHierarchy, IR iR, String string, String string2, String string3, String string4) throws WalaException {
        return PDFViewUtil.ghostviewIR(iClassHierarchy, iR, string, string2, string3, string4, null);
    }

    public static Process ghostviewIR(IClassHierarchy iClassHierarchy, IR iR, String string, String string2, String string3, String string4, NodeDecorator nodeDecorator) throws WalaException {
        if (iR == null) {
            throw new IllegalArgumentException("ir is null");
        }
        Graph<ISSABasicBlock> graph = iR.getControlFlowGraph();
        NodeDecorator nodeDecorator2 = PDFViewUtil.makeIRDecorator(iR);
        if (nodeDecorator != null) {
            nodeDecorator2 = new ConcatenatingNodeDecorator(nodeDecorator, nodeDecorator2);
        }
        graph = CFGSanitizer.sanitize(iR, iClassHierarchy);
        DotUtil.dotify(graph, nodeDecorator2, string2, string, string3);
        return PDFViewUtil.launchPDFView(string, string4);
    }

    public static NodeDecorator makeIRDecorator(IR iR) {
        if (iR == null) {
            throw new IllegalArgumentException("ir is null");
        }
        final HashMap<SSACFG.BasicBlock, String> hashMap = HashMapFactory.make();
        for (SSACFG.BasicBlock basicBlock : iR.getControlFlowGraph()) {
            hashMap.put(basicBlock, PDFViewUtil.getNodeLabel(iR, basicBlock));
        }
        NodeDecorator nodeDecorator = new NodeDecorator(){

            public String getLabel(Object object) {
                return (String)hashMap.get(object);
            }
        };
        return nodeDecorator;
    }

    private static String getNodeLabel(IR iR, SSACFG.BasicBlock basicBlock) {
        Object object;
        SSAInstruction sSAInstruction;
        StringBuffer stringBuffer = new StringBuffer();
        int n = basicBlock.getFirstInstructionIndex();
        int n2 = basicBlock.getLastInstructionIndex();
        stringBuffer.append("BB").append(basicBlock.getNumber());
        if (basicBlock.isEntryBlock()) {
            stringBuffer.append(" (en)\\n");
        } else if (basicBlock.isExitBlock()) {
            stringBuffer.append(" (ex)\\n");
        }
        if (basicBlock instanceof SSACFG.ExceptionHandlerBasicBlock) {
            stringBuffer.append("<Handler>");
        }
        stringBuffer.append("\\n");
        Object object2 = basicBlock.iteratePhis();
        while (object2.hasNext()) {
            sSAInstruction = object2.next();
            if (sSAInstruction == null) continue;
            stringBuffer.append("           " + ((SSAPhiInstruction)sSAInstruction).toString(iR.getSymbolTable())).append("\\l");
        }
        if (basicBlock instanceof SSACFG.ExceptionHandlerBasicBlock) {
            object2 = (SSACFG.ExceptionHandlerBasicBlock)basicBlock;
            sSAInstruction = object2.getCatchInstruction();
            if (sSAInstruction != null) {
                stringBuffer.append("           " + ((SSAGetCaughtExceptionInstruction)sSAInstruction).toString(iR.getSymbolTable())).append("\\l");
            } else {
                stringBuffer.append("            No catch instruction. Unreachable?\\l");
            }
        }
        object2 = iR.getInstructions();
        int n3 = n;
        while (n3 <= n2) {
            if (object2[n3] != null) {
                object = new StringBuffer(String.valueOf(n3) + "   " + object2[n3].toString(iR.getSymbolTable()));
                StringStuff.padWithSpaces((StringBuffer)object, 35);
                stringBuffer.append((StringBuffer)object);
                stringBuffer.append("\\l");
            }
            ++n3;
        }
        Iterator<SSAPiInstruction> iterator = basicBlock.iteratePis();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object == null) continue;
            stringBuffer.append("           " + ((SSAPiInstruction)object).toString(iR.getSymbolTable())).append("\\l");
        }
        return stringBuffer.toString();
    }

    public static Process launchPDFView(String string, String string2) throws WalaException {
        if (string2 == null) {
            throw new IllegalArgumentException("null gvExe");
        }
        if (string == null) {
            throw new IllegalArgumentException("null psFile");
        }
        PDFViewLauncher pDFViewLauncher = new PDFViewLauncher();
        pDFViewLauncher.setGvExe(string2);
        pDFViewLauncher.setPDFFile(string);
        pDFViewLauncher.run();
        if (pDFViewLauncher.getProcess() == null) {
            throw new WalaException(" problem spawning process ");
        }
        return pDFViewLauncher.getProcess();
    }

    private static final class ConcatenatingNodeDecorator
    implements NodeDecorator {
        private final NodeDecorator A;
        private final NodeDecorator B;

        ConcatenatingNodeDecorator(NodeDecorator nodeDecorator, NodeDecorator nodeDecorator2) {
            this.A = nodeDecorator;
            this.B = nodeDecorator2;
        }

        public String getLabel(Object object) throws WalaException {
            return String.valueOf(this.A.getLabel(object)) + this.B.getLabel(object);
        }
    }
}

