/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz.viewer;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.viz.viewer.IrAndSourceViewer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class CgPanel
extends JSplitPane {
    private final CallGraph cg;

    public CgPanel(CallGraph callGraph) {
        this.cg = callGraph;
        this.setDividerLocation(250);
        JTree jTree = this.buildTree();
        this.setLeftComponent(new JScrollPane(jTree));
        final IrAndSourceViewer irAndSourceViewer = new IrAndSourceViewer(callGraph);
        this.setRightComponent(irAndSourceViewer.getComponent());
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof CGNode) {
                    CGNode cGNode = (CGNode)object;
                    IR iR = cGNode.getIR();
                    irAndSourceViewer.setIR(iR);
                } else if (object instanceof CallSiteReference) {
                    CGNode cGNode = (CGNode)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
                    IR iR = cGNode.getIR();
                    irAndSourceViewer.setIRAndPc(iR, ((CallSiteReference)object).getProgramCounter());
                }
            }
        });
    }

    private JTree buildTree() {
        CGNode cGNode = this.cg.getFakeRootNode();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(cGNode);
        this.expandNode(defaultMutableTreeNode);
        JTree jTree = new JTree(defaultMutableTreeNode);
        jTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreePath treePath = treeExpansionEvent.getPath();
                if (treePath == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                CgPanel.this.expandNode(defaultMutableTreeNode);
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        return jTree;
    }

    private void expandNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.expandNode(defaultMutableTreeNode, 3);
    }

    private void expandNode(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        Object object;
        if (n == 0) {
            return;
        }
        if (defaultMutableTreeNode.getChildCount() == 0) {
            Object object2;
            Iterator iterator;
            ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
            object = defaultMutableTreeNode.getUserObject();
            if (object instanceof CGNode) {
                CGNode object32 = (CGNode)object;
                iterator = object32.iterateCallSites();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    arrayList.add(new DefaultMutableTreeNode(object2));
                }
            } else {
                assert (object instanceof CallSiteReference);
                CallSiteReference callSiteReference = (CallSiteReference)object;
                iterator = (CGNode)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
                object2 = this.cg.getPossibleTargets((CGNode)((Object)iterator), callSiteReference);
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    CGNode cGNode = (CGNode)iterator2.next();
                    arrayList.add(new DefaultMutableTreeNode(cGNode));
                }
            }
            for (DefaultMutableTreeNode defaultMutableTreeNode2 : arrayList) {
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
        int n2 = 0;
        while (n2 < defaultMutableTreeNode.getChildCount()) {
            object = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            this.expandNode((DefaultMutableTreeNode)object, n - 1);
            ++n2;
        }
    }
}

