/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.bench;

import com.ibm.wala.shrike.bench.Slots;
import com.ibm.wala.shrikeBT.ConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.Disassembler;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MethodEditor;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.Verifier;
import com.ibm.wala.shrikeBT.info.LocalAllocator;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Random;

public class Mangler {
    private static OfflineInstrumenter instrumenter;
    private static final boolean verify = true;
    private static final boolean disasm = true;

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        while (n < 1) {
            ClassInstrumenter classInstrumenter;
            int n2;
            instrumenter = new OfflineInstrumenter();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("report", false));
            stringArray = instrumenter.parseStandardArgs(stringArray);
            try {
                n2 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Invalid number: " + stringArray[0]);
                return;
            }
            Random random = new Random(n2);
            instrumenter.setPassUnmodifiedClasses(true);
            instrumenter.beginTraversal();
            instrumenter.setOutputJar(new File("output.jar"));
            while ((classInstrumenter = instrumenter.nextClass()) != null) {
                Mangler.doClass(classInstrumenter, bufferedWriter, random);
            }
            instrumenter.close();
            ++n;
        }
    }

    private static void doClass(ClassInstrumenter classInstrumenter, Writer writer, Random random) throws Exception {
        String string = classInstrumenter.getReader().getName();
        writer.write("Class: " + string + "\n");
        writer.flush();
        int n = 0;
        while (n < classInstrumenter.getReader().getMethodCount()) {
            MethodData methodData = classInstrumenter.visitMethod(n);
            if (methodData != null) {
                writer.write("Instrumenting " + classInstrumenter.getReader().getMethodName(n) + " " + classInstrumenter.getReader().getMethodType(n) + ":\n");
                writer.flush();
                writer.write("Initial ShrikeBT code:\n");
                new Disassembler(methodData).disassembleTo(writer);
                writer.flush();
                Verifier verifier = new Verifier(methodData);
                verifier.verify();
                int n2 = random.nextInt(4) + 1;
                int n3 = 0;
                while (n3 < n2) {
                    final int n4 = LocalAllocator.allocate(methodData, "I");
                    final int n5 = LocalAllocator.allocate(methodData);
                    final MethodEditor methodEditor = new MethodEditor(methodData);
                    methodEditor.beginPass();
                    methodEditor.visitInstructions(new MethodEditor.Visitor(){

                        public void visitGet(IGetInstruction iGetInstruction) {
                            if (!iGetInstruction.isStatic()) {
                                this.insertBefore(new MethodEditor.Patch(){

                                    public void emitTo(MethodEditor.Output output) {
                                        output.emit(DupInstruction.make(0));
                                    }
                                });
                                this.insertAfter(new MethodEditor.Patch(){

                                    public void emitTo(MethodEditor.Output output) {
                                        output.emit(SwapInstruction.make());
                                        output.emit(Util.makePut(Slots.class, "o"));
                                    }
                                });
                            }
                        }

                        public void visitPut(IPutInstruction iPutInstruction) {
                            if (!iPutInstruction.isStatic()) {
                                this.insertBefore(new MethodEditor.Patch(){

                                    public void emitTo(MethodEditor.Output output) {
                                        output.emit(SwapInstruction.make());
                                        output.emit(DupInstruction.make(1));
                                        output.emit(SwapInstruction.make());
                                    }
                                });
                                this.insertAfter(new MethodEditor.Patch(){

                                    public void emitTo(MethodEditor.Output output) {
                                        output.emit(Util.makePut(Slots.class, "o"));
                                    }
                                });
                            }
                        }

                        public void visitArrayStore(final IArrayStoreInstruction iArrayStoreInstruction) {
                            final int n = methodEditor.allocateLabel();
                            this.insertBefore(new MethodEditor.Patch(){

                                public void emitTo(MethodEditor.Output output) {
                                    String string = Util.getStackType(iArrayStoreInstruction.getType());
                                    output.emit(StoreInstruction.make(string, n5));
                                    output.emit(StoreInstruction.make("I", n4));
                                    output.emit(DupInstruction.make(0));
                                    output.emit(LoadInstruction.make("I", n4));
                                    output.emit(LoadInstruction.make(string, n5));
                                    if (string.equals("I")) {
                                        output.emit(DupInstruction.make(0));
                                        output.emit(ConstantInstruction.make(0));
                                        output.emit(ConditionalBranchInstruction.make(string, IConditionalBranchInstruction.Operator.EQ, n));
                                        output.emit(DupInstruction.make(0));
                                        output.emit(Util.makePut(Slots.class, "i"));
                                        output.emitLabel(n);
                                    }
                                }
                            });
                            this.insertAfter(new MethodEditor.Patch(){

                                public void emitTo(MethodEditor.Output output) {
                                    output.emit(Util.makePut(Slots.class, "o"));
                                    output.emit(LoadInstruction.make("I", n4));
                                    output.emit(Util.makePut(Slots.class, "i"));
                                }
                            });
                        }
                    });
                    methodEditor.applyPatches();
                    ++n3;
                }
                writer.write("Final ShrikeBT code:\n");
                new Disassembler(methodData).disassembleTo(writer);
                writer.flush();
            }
            ++n;
        }
        if (classInstrumenter.isChanged()) {
            ClassWriter classWriter = classInstrumenter.emitClass();
            instrumenter.outputModifiedClass(classInstrumenter, classWriter);
        }
    }
}

