/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.copywriter;

import com.ibm.wala.shrikeBT.Compiler;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.shrikeCT.CTCompiler;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeBT.tools.OfflineInstrumenterBase;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ClassWriter;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.CodeWriter;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrikeCT.ConstantValueReader;
import com.ibm.wala.shrikeCT.ConstantValueWriter;
import com.ibm.wala.shrikeCT.ExceptionsReader;
import com.ibm.wala.shrikeCT.ExceptionsWriter;
import com.ibm.wala.shrikeCT.InnerClassesReader;
import com.ibm.wala.shrikeCT.InnerClassesWriter;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.LocalVariableTableReader;
import com.ibm.wala.shrikeCT.LocalVariableTableWriter;
import com.ibm.wala.shrikeCT.SourceFileReader;
import com.ibm.wala.shrikeCT.SourceFileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.zip.ZipEntry;

public class CopyWriter {
    private static final String USAGE = "IBM CopyWriter Tool\nThis tool takes the following command line options:\n    <jarname> <jarname> ...   Process the classes from these jars\n    -o <jarname>              Put the resulting classes into <jarname>\n    -c <copyright>            Make the copyright string be\n                              '\u00a9 Copyright <copyright>'";
    private static OfflineInstrumenter instrumenter;
    public static String copyright;
    public static final String copyrightAttrName = "com.ibm.Copyright";
    private int replaceWith;
    private int replace;

    public static void main(String[] stringArray) throws Exception {
        Object object;
        if (stringArray == null || stringArray.length == 0) {
            System.err.println(USAGE);
            System.exit(1);
        }
        int n = 0;
        while (n < stringArray.length - 1) {
            if (stringArray[n] == null) {
                throw new IllegalArgumentException("args[" + n + "] is null");
            }
            if (stringArray[n].equals("-c")) {
                copyright = "\u00a9 Copyright " + stringArray[n + 1];
                object = new String[stringArray.length - 2];
                System.arraycopy(stringArray, 0, object, 0, n);
                System.arraycopy(stringArray, n + 2, object, n, ((String[])object).length - n);
                stringArray = object;
                break;
            }
            ++n;
        }
        if (copyright == null) {
            System.err.println(USAGE);
            System.exit(1);
        }
        final ArrayList arrayList = new ArrayList();
        instrumenter = new OfflineInstrumenter();
        instrumenter.setManifestBuilder(new OfflineInstrumenterBase.ManifestBuilder(){

            public void addEntry(ZipEntry zipEntry) {
                arrayList.add(zipEntry);
            }
        });
        instrumenter.parseStandardArgs(stringArray);
        instrumenter.setJARComment(copyright);
        instrumenter.beginTraversal();
        CopyWriter copyWriter = new CopyWriter();
        while ((object = instrumenter.nextClass()) != null) {
            try {
                copyWriter.doClass((ClassInstrumenter)object);
            }
            catch (UnknownAttributeException unknownAttributeException) {
                System.err.println(String.valueOf(unknownAttributeException.getMessage()) + " in " + instrumenter.getLastClassResourceName());
            }
        }
        instrumenter.writeUnmodifiedClasses();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(instrumenter.addOutputJarEntry(new ZipEntry("IBM-Copyright")));
        outputStreamWriter.write(String.valueOf(copyright) + "\n");
        for (ZipEntry zipEntry : arrayList) {
            outputStreamWriter.write("  " + zipEntry.getName() + "\n");
        }
        outputStreamWriter.write(String.valueOf(copyright) + "\n");
        ((Writer)outputStreamWriter).flush();
        instrumenter.endOutputJarEntry();
        instrumenter.close();
    }

    private int transformCPIndex(int n) {
        if (n == this.replace) {
            return this.replaceWith;
        }
        return n;
    }

    private ClassWriter.Element transformAttribute(ClassReader classReader, int n, ClassWriter classWriter, ClassReader.AttrIterator attrIterator) throws InvalidClassFileException, UnknownAttributeException, Decoder.InvalidBytecodeException {
        String string = attrIterator.getName();
        boolean bl = true;
        if (string.equals("Synthetic") || string.equals("Deprecated") || string.equals("LineNumberTable")) {
            bl = false;
        }
        int n2 = attrIterator.getRawOffset();
        int n3 = n2 + attrIterator.getRawSize();
        if (bl) {
            bl = false;
            int n4 = n2;
            while (n4 + 1 < n3) {
                if (classReader.getUShort(n4) == this.replace) break;
                ++n4;
            }
        }
        if (!bl) {
            return new ClassWriter.RawElement(classReader.getBytes(), n2, n3 - n2);
        }
        if (string.equals("Code")) {
            CodeReader codeReader = new CodeReader(attrIterator);
            CTDecoder cTDecoder = new CTDecoder(codeReader);
            cTDecoder.decode();
            MethodData methodData = new MethodData(cTDecoder, classReader.getMethodAccessFlags(n), CTDecoder.convertClassToType(classReader.getName()), classReader.getMethodName(n), classReader.getMethodType(n));
            CTCompiler cTCompiler = CTCompiler.make(classWriter, methodData);
            cTCompiler.compile();
            if (cTCompiler.getAuxiliaryMethods().length > 0) {
                throw new Error("Where did this auxiliary method come from?");
            }
            Compiler.Output output = cTCompiler.getOutput();
            CodeWriter codeWriter = new CodeWriter(classWriter);
            codeWriter.setMaxLocals(output.getMaxLocals());
            codeWriter.setMaxStack(output.getMaxStack());
            codeWriter.setCode(output.getCode());
            codeWriter.setRawHandlers(output.getRawHandlers());
            ClassReader.AttrIterator attrIterator2 = new ClassReader.AttrIterator();
            codeReader.initAttributeIterator(attrIterator2);
            codeWriter.setAttributes(this.collectAttributes(classReader, n, classWriter, attrIterator2));
            return codeWriter;
        }
        if (string.equals("ConstantValue")) {
            ConstantValueReader constantValueReader = new ConstantValueReader(attrIterator);
            ConstantValueWriter constantValueWriter = new ConstantValueWriter(classWriter);
            constantValueWriter.setValueCPIndex(this.transformCPIndex(constantValueReader.getValueCPIndex()));
            return constantValueWriter;
        }
        if (string.equals("SourceFile")) {
            SourceFileReader sourceFileReader = new SourceFileReader(attrIterator);
            SourceFileWriter sourceFileWriter = new SourceFileWriter(classWriter);
            sourceFileWriter.setSourceFileCPIndex(this.transformCPIndex(sourceFileReader.getSourceFileCPIndex()));
            return sourceFileWriter;
        }
        if (string.equals("LocalVariableTableReader")) {
            LocalVariableTableReader localVariableTableReader = new LocalVariableTableReader(attrIterator);
            LocalVariableTableWriter localVariableTableWriter = new LocalVariableTableWriter(classWriter);
            int[] nArray = localVariableTableReader.getRawTable();
            int n5 = 0;
            while (n5 < nArray.length) {
                nArray[n5 + 2] = this.transformCPIndex(nArray[n5 + 2]);
                nArray[n5 + 3] = this.transformCPIndex(nArray[n5 + 3]);
                n5 += 5;
            }
            localVariableTableWriter.setRawTable(nArray);
            return localVariableTableWriter;
        }
        if (string.equals("Exceptions")) {
            ExceptionsReader exceptionsReader = new ExceptionsReader(attrIterator);
            ExceptionsWriter exceptionsWriter = new ExceptionsWriter(classWriter);
            int[] nArray = exceptionsReader.getRawTable();
            int n6 = 0;
            while (n6 < nArray.length) {
                nArray[n6] = this.transformCPIndex(nArray[n6]);
                ++n6;
            }
            exceptionsWriter.setRawTable(nArray);
            return exceptionsWriter;
        }
        if (string.equals("InnerClasses")) {
            InnerClassesReader innerClassesReader = new InnerClassesReader(attrIterator);
            InnerClassesWriter innerClassesWriter = new InnerClassesWriter(classWriter);
            int[] nArray = innerClassesReader.getRawTable();
            int n7 = 0;
            while (n7 < nArray.length) {
                nArray[n7] = this.transformCPIndex(nArray[n7]);
                nArray[n7 + 1] = this.transformCPIndex(nArray[n7 + 1]);
                nArray[n7 + 2] = this.transformCPIndex(nArray[n7 + 2]);
                n7 += 4;
            }
            innerClassesWriter.setRawTable(nArray);
            return innerClassesWriter;
        }
        throw new UnknownAttributeException(string);
    }

    private ClassWriter.Element[] collectAttributes(ClassReader classReader, int n, ClassWriter classWriter, ClassReader.AttrIterator attrIterator) throws InvalidClassFileException, UnknownAttributeException, Decoder.InvalidBytecodeException {
        ClassWriter.Element[] elementArray = new ClassWriter.Element[attrIterator.getRemainingAttributesCount()];
        int n2 = 0;
        while (n2 < elementArray.length) {
            elementArray[n2] = this.transformAttribute(classReader, n, classWriter, attrIterator);
            attrIterator.advance();
            ++n2;
        }
        return elementArray;
    }

    private int copyEntry(ConstantPoolParser constantPoolParser, ClassWriter classWriter, int n) throws InvalidClassFileException {
        byte by = constantPoolParser.getItemType(n);
        switch (by) {
            case 8: {
                return classWriter.addCPString(constantPoolParser.getCPString(n));
            }
            case 7: {
                return classWriter.addCPClass(constantPoolParser.getCPClass(n));
            }
            case 9: {
                return classWriter.addCPFieldRef(constantPoolParser.getCPRefClass(n), constantPoolParser.getCPRefName(n), constantPoolParser.getCPRefType(n));
            }
            case 11: {
                return classWriter.addCPInterfaceMethodRef(constantPoolParser.getCPRefClass(n), constantPoolParser.getCPRefName(n), constantPoolParser.getCPRefType(n));
            }
            case 10: {
                return classWriter.addCPMethodRef(constantPoolParser.getCPRefClass(n), constantPoolParser.getCPRefName(n), constantPoolParser.getCPRefType(n));
            }
            case 12: {
                return classWriter.addCPNAT(constantPoolParser.getCPNATName(n), constantPoolParser.getCPNATType(n));
            }
            case 3: {
                return classWriter.addCPInt(constantPoolParser.getCPInt(n));
            }
            case 4: {
                return classWriter.addCPFloat(constantPoolParser.getCPFloat(n));
            }
            case 5: {
                return classWriter.addCPLong(constantPoolParser.getCPLong(n));
            }
            case 6: {
                return classWriter.addCPDouble(constantPoolParser.getCPDouble(n));
            }
            case 1: {
                return classWriter.addCPUtf8(constantPoolParser.getCPUtf8(n));
            }
        }
        return -1;
    }

    private void doClass(ClassInstrumenter classInstrumenter) throws Exception {
        ClassReader classReader = classInstrumenter.getReader();
        ClassWriter classWriter = new ClassWriter();
        classWriter.setForceAddCPEntries(true);
        int n = classWriter.addCPUtf8(copyright);
        if (n != 1) {
            throw new Error("Invalid constant pool index: " + n);
        }
        ConstantPoolParser constantPoolParser = classReader.getCP();
        int n2 = constantPoolParser.getItemCount();
        if (1 < n2) {
            switch (constantPoolParser.getItemType(1)) {
                case 5: 
                case 6: {
                    n = classWriter.addCPUtf8("");
                    if (n == 2) break;
                    throw new Error("Invalid constant pool index for dummy: " + n);
                }
            }
        }
        int n3 = 2;
        while (n3 < n2) {
            n = this.copyEntry(constantPoolParser, classWriter, n3);
            if (n != -1 && n != n3) {
                throw new Error("Invalid constant pool index allocated: " + n + ", expected " + n3);
            }
            ++n3;
        }
        classWriter.setForceAddCPEntries(false);
        this.replaceWith = this.copyEntry(constantPoolParser, classWriter, 1);
        this.replace = 1;
        classWriter.setMajorVersion(classReader.getMajorVersion());
        classWriter.setMinorVersion(classReader.getMinorVersion());
        classWriter.setAccessFlags(classReader.getAccessFlags());
        classWriter.setName(classReader.getName());
        classWriter.setSuperName(classReader.getSuperName());
        classWriter.setInterfaceNames(classReader.getInterfaceNames());
        ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
        int n4 = classReader.getFieldCount();
        int n5 = 0;
        while (n5 < n4) {
            classReader.initFieldAttributeIterator(n5, attrIterator);
            classWriter.addField(classReader.getFieldAccessFlags(n5), classReader.getFieldName(n5), classReader.getFieldType(n5), this.collectAttributes(classReader, n5, classWriter, attrIterator));
            ++n5;
        }
        n5 = classReader.getMethodCount();
        int n6 = 0;
        while (n6 < n5) {
            classReader.initMethodAttributeIterator(n6, attrIterator);
            classWriter.addMethod(classReader.getMethodAccessFlags(n6), classReader.getMethodName(n6), classReader.getMethodType(n6), this.collectAttributes(classReader, n6, classWriter, attrIterator));
            ++n6;
        }
        classReader.initClassAttributeIterator(attrIterator);
        while (attrIterator.isValid()) {
            classWriter.addClassAttribute(this.transformAttribute(classReader, 0, classWriter, attrIterator));
            attrIterator.advance();
        }
        instrumenter.outputModifiedClass(classInstrumenter, classWriter);
    }

    static class UnknownAttributeException
    extends Exception {
        private static final long serialVersionUID = 8845177787110364793L;

        UnknownAttributeException(String string) {
            super("Attribute '" + string + "' not understood");
        }
    }
}

