/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class BinaryOpInstruction
extends Instruction
implements IBinaryOpInstruction {
    private static final BinaryOpInstruction[] arithmeticOps = BinaryOpInstruction.preallocateArithmeticOps();
    private static final BinaryOpInstruction[] logicalOps = BinaryOpInstruction.preallocateLogicalOps();

    protected BinaryOpInstruction(short s) {
        super(s);
    }

    private static BinaryOpInstruction[] preallocateArithmeticOps() {
        BinaryOpInstruction[] binaryOpInstructionArray = new BinaryOpInstruction[20];
        short s = 96;
        while (s <= 115) {
            binaryOpInstructionArray[s - 96] = new BinaryOpInstruction(s);
            s = (short)(s + 1);
        }
        return binaryOpInstructionArray;
    }

    private static BinaryOpInstruction[] preallocateLogicalOps() {
        BinaryOpInstruction[] binaryOpInstructionArray = new BinaryOpInstruction[6];
        short s = 126;
        while (s <= 131) {
            binaryOpInstructionArray[s - 126] = new BinaryOpInstruction(s);
            s = (short)(s + 1);
        }
        return binaryOpInstructionArray;
    }

    public static BinaryOpInstruction make(String string, IBinaryOpInstruction.Operator operator) throws IllegalArgumentException {
        if (operator == null) {
            throw new IllegalArgumentException("operator is null");
        }
        int n = Util.getTypeIndex(string);
        if (n < 0) {
            throw new IllegalArgumentException("Invalid type for BinaryOp: " + string);
        }
        if (operator.compareTo(IBinaryOpInstruction.Operator.REM) <= 0) {
            if (n > 3) {
                throw new IllegalArgumentException("Invalid type for BinaryOp: " + string);
            }
            return arithmeticOps[(operator.ordinal() - IBinaryOpInstruction.Operator.ADD.ordinal()) * 4 + n];
        }
        if (n > 1) {
            throw new IllegalArgumentException("Cannot use logical binaryOps on floating point type: " + string);
        }
        return logicalOps[(operator.ordinal() - IBinaryOpInstruction.Operator.AND.ordinal()) * 2 + n];
    }

    public boolean equals(Object object) {
        if (object instanceof BinaryOpInstruction) {
            BinaryOpInstruction binaryOpInstruction = (BinaryOpInstruction)object;
            return binaryOpInstruction.opcode == this.opcode;
        }
        return false;
    }

    public IBinaryOpInstruction.Operator getOperator() {
        if (this.opcode < 126) {
            return IBinaryOpInstruction.Operator.values()[(this.opcode - 96) / 4];
        }
        return IBinaryOpInstruction.Operator.values()[5 + (this.opcode - 126) / 2];
    }

    public int hashCode() {
        return this.opcode + 13901901;
    }

    public int getPoppedCount() {
        return 2;
    }

    public String getPushedType(String[] stringArray) {
        return this.getType();
    }

    public byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    public String getType() {
        int n = this.opcode < 126 ? this.opcode - 96 & 3 : this.opcode - 126 & 1;
        return indexedTypes[n];
    }

    public void visit(IInstruction.Visitor visitor) throws NullPointerException {
        visitor.visitBinaryOp(this);
    }

    public String toString() {
        return "BinaryOp(" + this.getType() + "," + this.getOperator() + ")";
    }

    public boolean isPEI() {
        return this.opcode == 108 || this.opcode == 109 || this.opcode == 112 || this.opcode == 113;
    }

    public boolean throwsExceptionOnOverflow() {
        return false;
    }

    public boolean isUnsigned() {
        return false;
    }
}

