/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class ComparisonInstruction
extends Instruction
implements IComparisonInstruction {
    private static final ComparisonInstruction preallocatedLCMP = new ComparisonInstruction(148);
    private static final ComparisonInstruction[] preallocatedFloatingCompares = ComparisonInstruction.preallocateFloatingCompares();

    protected ComparisonInstruction(short s) {
        super(s);
    }

    private static ComparisonInstruction[] preallocateFloatingCompares() {
        ComparisonInstruction[] comparisonInstructionArray = new ComparisonInstruction[4];
        short s = 149;
        while (s <= 152) {
            comparisonInstructionArray[s - 149] = new ComparisonInstruction(s);
            s = (short)(s + 1);
        }
        return comparisonInstructionArray;
    }

    public static ComparisonInstruction make(String string, IComparisonInstruction.Operator operator) throws IllegalArgumentException {
        int n = Util.getTypeIndex(string);
        switch (n) {
            case 1: {
                if (operator != IComparisonInstruction.Operator.CMP) {
                    throw new IllegalArgumentException("Operator " + (Object)((Object)operator) + " is not a valid comparison operator for longs");
                }
                return preallocatedLCMP;
            }
            case 2: 
            case 3: {
                if (operator == IComparisonInstruction.Operator.CMP) {
                    throw new IllegalArgumentException("Operator " + (Object)((Object)operator) + " is not a valid comparison operator for floating point values");
                }
                return preallocatedFloatingCompares[operator.ordinal() - IComparisonInstruction.Operator.CMPL.ordinal() + (n - 2) * 2];
            }
        }
        throw new IllegalArgumentException("Type " + string + " cannot be compared");
    }

    public boolean equals(Object object) {
        if (object instanceof ComparisonInstruction) {
            ComparisonInstruction comparisonInstruction = (ComparisonInstruction)object;
            return comparisonInstruction.opcode == this.opcode;
        }
        return false;
    }

    public IComparisonInstruction.Operator getOperator() {
        switch (this.opcode) {
            case 148: {
                return IComparisonInstruction.Operator.CMP;
            }
            case 149: 
            case 151: {
                return IComparisonInstruction.Operator.CMPL;
            }
            case 150: 
            case 152: {
                return IComparisonInstruction.Operator.CMPG;
            }
        }
        throw new Error("Unknown opcode");
    }

    public String getType() {
        switch (this.opcode) {
            case 148: {
                return "J";
            }
            case 149: 
            case 150: {
                return "F";
            }
            case 151: 
            case 152: {
                return "D";
            }
        }
        throw new Error("Unknown opcode");
    }

    public int hashCode() {
        return this.opcode + 1391901;
    }

    public int getPoppedCount() {
        return 2;
    }

    public String getPushedType(String[] stringArray) {
        return "Z";
    }

    public byte getPushedWordSize() {
        return 1;
    }

    public void visit(IInstruction.Visitor visitor) throws NullPointerException {
        visitor.visitComparison(this);
    }

    public String toString() {
        return "Comparison(" + this.getType() + "," + (Object)((Object)this.getOperator()) + ")";
    }

    public boolean isPEI() {
        return false;
    }
}

