/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.BinaryOpInstruction;
import com.ibm.wala.shrikeBT.CheckCastInstruction;
import com.ibm.wala.shrikeBT.ConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.GetInstruction;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.InstanceofInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.PutInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.Analyzer;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchyProvider;
import com.ibm.wala.shrikeBT.analysis.Verifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Compiler
implements Constants {
    private final boolean isStatic;
    private final String classType;
    private final String signature;
    private final IInstruction[] instructions;
    private final ExceptionHandler[][] handlers;
    private final int[] instructionsToBytecodes;
    private static final int[] noRawHandlers = new int[0];
    private ClassHierarchyProvider hierarchy;
    private ConstantPoolReader presetConstants;
    private int[] instructionsToOffsets;
    private BitSet branchTargets;
    private byte[][] stackWords;
    private byte[] code;
    private int allocatedLocals;
    private BitSet[] liveLocals;
    private int[][] backEdges;
    private String[][] localTypes;
    private String[][] stackTypes;
    private int maxLocals;
    private int maxStack;
    private Output mainMethod;
    private ArrayList<Output> auxMethods;
    private static byte[] cachedBuf;

    public Compiler(boolean bl, String string, String string2, IInstruction[] iInstructionArray, ExceptionHandler[][] exceptionHandlerArray, int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("instructionsToBytecodes is null");
        }
        if (iInstructionArray == null) {
            throw new IllegalArgumentException("instructions is null");
        }
        if (exceptionHandlerArray == null) {
            throw new IllegalArgumentException("handlers is null");
        }
        if (iInstructionArray.length != exceptionHandlerArray.length) {
            throw new IllegalArgumentException("Instructions/handlers length mismatch");
        }
        if (iInstructionArray.length != nArray.length) {
            throw new IllegalArgumentException("Instructions/handlers length mismatch");
        }
        this.isStatic = bl;
        this.classType = string;
        this.signature = string2;
        this.instructions = iInstructionArray;
        this.handlers = exceptionHandlerArray;
        this.instructionsToBytecodes = nArray;
    }

    protected Compiler(MethodData methodData) {
        this(methodData.getIsStatic(), methodData.getClassType(), methodData.getSignature(), methodData.getInstructions(), methodData.getHandlers(), methodData.getInstructionsToBytecodes());
    }

    public final String getClassType() {
        return this.classType;
    }

    public final void setPresetConstants(ConstantPoolReader constantPoolReader) {
        this.presetConstants = constantPoolReader;
    }

    public final void setClassHierarchy(ClassHierarchyProvider classHierarchyProvider) {
        this.hierarchy = classHierarchyProvider;
    }

    protected abstract int allocateConstantPoolInteger(int var1);

    protected abstract int allocateConstantPoolFloat(float var1);

    protected abstract int allocateConstantPoolLong(long var1);

    protected abstract int allocateConstantPoolDouble(double var1);

    protected abstract int allocateConstantPoolString(String var1);

    protected abstract int allocateConstantPoolClassType(String var1);

    protected abstract int allocateConstantPoolField(String var1, String var2, String var3);

    protected abstract int allocateConstantPoolMethod(String var1, String var2, String var3);

    protected abstract int allocateConstantPoolInterfaceMethod(String var1, String var2, String var3);

    protected abstract String createHelperMethod(boolean var1, String var2);

    private void collectInstructionInfo() {
        final BitSet bitSet = new BitSet(this.instructions.length);
        final BitSet bitSet2 = new BitSet(32);
        final BitSet bitSet3 = new BitSet(32);
        IInstruction.Visitor visitor = new IInstruction.Visitor(){

            private void visitTargets(IInstruction iInstruction) {
                int[] nArray = iInstruction.getBranchTargets();
                int n = 0;
                while (n < nArray.length) {
                    bitSet.set(nArray[n]);
                    ++n;
                }
            }

            public void visitGoto(GotoInstruction gotoInstruction) {
                this.visitTargets(gotoInstruction);
            }

            public void visitLocalStore(IStoreInstruction iStoreInstruction) {
                bitSet2.set(iStoreInstruction.getVarIndex());
                String string = iStoreInstruction.getType();
                if (string.equals("J") || string.equals("D")) {
                    bitSet3.set(iStoreInstruction.getVarIndex());
                }
            }

            public void visitConditionalBranch(IConditionalBranchInstruction iConditionalBranchInstruction) {
                this.visitTargets(iConditionalBranchInstruction);
            }

            public void visitSwitch(SwitchInstruction switchInstruction) {
                this.visitTargets(switchInstruction);
            }
        };
        int n = 0;
        while (n < this.instructions.length) {
            this.instructions[n].visit(visitor);
            ++n;
        }
        String[] stringArray = Util.getParamsTypes(this.isStatic ? null : "Ljava/lang/Object;", this.signature);
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            String string = stringArray[n3];
            bitSet2.set(n2);
            if (string.equals("J") || string.equals("D")) {
                bitSet3.set(n2);
                n2 += 2;
            } else {
                ++n2;
            }
            ++n3;
        }
        ExceptionHandler[] exceptionHandlerArray = null;
        int n4 = 0;
        while (n4 < this.handlers.length) {
            ExceptionHandler[] exceptionHandlerArray2 = this.handlers[n4];
            if (exceptionHandlerArray2 != exceptionHandlerArray) {
                int n5 = 0;
                while (n5 < exceptionHandlerArray2.length) {
                    bitSet.set(exceptionHandlerArray2[n5].handler);
                    ++n5;
                }
                exceptionHandlerArray = exceptionHandlerArray2;
            }
            ++n4;
        }
        this.branchTargets = bitSet;
        n4 = bitSet2.length();
        if (n4 > 0 && bitSet3.get(n4 - 1)) {
            ++n4;
        }
        this.maxLocals = n4;
    }

    private void writeInt(int n, int n2) {
        this.code[n] = (byte)(n2 >> 24);
        this.code[n + 1] = (byte)(n2 >> 16);
        this.code[n + 2] = (byte)(n2 >> 8);
        this.code[n + 3] = (byte)n2;
    }

    private void writeShort(int n, int n2) {
        this.code[n] = (byte)(n2 >> 8);
        this.code[n + 1] = (byte)n2;
    }

    private void writeByte(int n, int n2) {
        this.code[n] = (byte)n2;
    }

    private boolean inBasicBlock(int n, int n2) {
        if (n + n2 - 1 >= this.instructions.length) {
            return false;
        }
        int n3 = n + 1;
        while (n3 < n + n2) {
            if (this.branchTargets.get(n3)) {
                return false;
            }
            if (!Arrays.equals(this.handlers[n3], this.handlers[n])) {
                return false;
            }
            if (this.instructionsToBytecodes[n3] != this.instructionsToBytecodes[n]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private void checkStackWordSize(byte[] byArray, int n) {
        if (n * 2 > this.maxStack) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 += byArray[n3];
                ++n3;
            }
            if (n2 > this.maxStack) {
                this.maxStack = n2;
            }
        }
    }

    private void computeStackWordsAt(int n, int n2, byte[] byArray, boolean[] blArray) {
        while (!blArray[n]) {
            int n3;
            int n4;
            Object object;
            IInstruction iInstruction = this.instructions[n];
            if (n > 0 && !this.instructions[n - 1].isFallThrough()) {
                object = new byte[n2];
                System.arraycopy(byArray, 0, object, 0, n2);
                this.stackWords[n] = object;
            }
            blArray[n] = true;
            if (n2 < iInstruction.getPoppedCount()) {
                throw new IllegalArgumentException("Stack underflow in intermediate code, at offset " + n);
            }
            if (iInstruction instanceof DupInstruction) {
                object = (DupInstruction)iInstruction;
                n4 = object.getSize();
                n3 = object.getDelta();
                System.arraycopy(byArray, n2 - n4 - n3, byArray, n2 - n3, n3 + n4);
                System.arraycopy(byArray, n2, byArray, n2 - n4 - n3, n4);
                this.checkStackWordSize(byArray, n2 += n4);
            } else if (iInstruction instanceof SwapInstruction) {
                int n5 = byArray[n2 - 1];
                int n6 = 0;
                while (n6 < n2) {
                    n5 += byArray[n6];
                    ++n6;
                }
                if (n5 > this.maxStack) {
                    this.maxStack = n5;
                }
                n6 = byArray[n2 - 2];
                byArray[n2 - 2] = byArray[n2 - 1];
                byArray[n2 - 1] = n6;
            } else {
                n2 -= iInstruction.getPoppedCount();
                byte by = iInstruction.getPushedWordSize();
                if (by > 0) {
                    byArray[n2] = by;
                    this.checkStackWordSize(byArray, ++n2);
                }
            }
            object = iInstruction.getBranchTargets();
            n4 = 0;
            while (n4 < ((byte[])object).length) {
                n3 = object[n4];
                if (n3 < 0 || n3 >= blArray.length) {
                    throw new IllegalArgumentException("Branch target at offset " + n + " is out of bounds: " + n3 + " (max " + blArray.length + ")");
                }
                if (!blArray[n3]) {
                    this.computeStackWordsAt(object[n4], n2, (byte[])byArray.clone(), blArray);
                }
                ++n4;
            }
            ExceptionHandler[] exceptionHandlerArray = this.handlers[n];
            n3 = 0;
            while (n3 < exceptionHandlerArray.length) {
                int n7 = exceptionHandlerArray[n3].handler;
                if (!blArray[n7]) {
                    byte[] byArray2 = (byte[])byArray.clone();
                    byArray2[0] = 1;
                    this.computeStackWordsAt(n7, 1, byArray2, blArray);
                }
                ++n3;
            }
            if (!iInstruction.isFallThrough()) {
                return;
            }
            ++n;
        }
    }

    private void computeStackWords() {
        this.stackWords = new byte[this.instructions.length][];
        this.maxStack = 0;
        this.computeStackWordsAt(0, 0, new byte[this.instructions.length * 2], new boolean[this.instructions.length]);
    }

    private void insertBranchOffsetInt(ArrayList<Patch> arrayList, int n, int n2, int n3) {
        if (this.instructionsToOffsets[n3] > 0 || n3 == 0) {
            this.writeInt(n2, this.instructionsToOffsets[n3] - n);
        } else {
            arrayList.add(new IntPatch(n, n2, n3));
        }
    }

    private boolean applyPatches(ArrayList<Patch> arrayList) {
        for (Patch patch : arrayList) {
            if (patch.apply()) continue;
            return false;
        }
        return true;
    }

    private static synchronized byte[] makeCodeBuf() {
        if (cachedBuf != null) {
            byte[] byArray = cachedBuf;
            cachedBuf = null;
            return byArray;
        }
        return new byte[65535];
    }

    private static synchronized void releaseCodeBuf(byte[] byArray) {
        cachedBuf = byArray;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean outputInstructions(int var1_1, int var2_2, int var3_3, boolean var4_4, byte[] var5_5) {
        this.instructionsToOffsets = new int[this.instructions.length];
        this.code = Compiler.makeCodeBuf();
        var6_6 = new ArrayList<Patch>();
        var7_7 = var3_3;
        var8_8 = new int[1];
        var9_9 = var5_5 == null ? 0 : var5_5.length;
        var10_10 = new int[1];
        var11_11 = new byte[this.maxStack];
        if (var9_9 > 0) {
            System.arraycopy(var5_5, 0, var11_11, 0, var9_9);
        }
        var12_12 = new int[1];
        var13_13 = new IInstruction.Visitor(){

            public void visitPop(PopInstruction popInstruction) {
                int n = popInstruction.getPoppedCount();
                int n2 = var8_8[0];
                int n3 = var10_10[0];
                while (n > 0) {
                    ((Compiler)Compiler.this).code[n2] = (byte)(var11_11[n3 - 1] == 1 ? 87 : 88);
                    --n;
                    --n3;
                    ++n2;
                }
                var8_8[0] = n2;
            }

            public void visitDup(DupInstruction dupInstruction) {
                int n;
                int n2 = dupInstruction.getSize();
                int n3 = dupInstruction.getDelta();
                int n4 = var8_8[0];
                int n5 = var10_10[0];
                int n6 = var11_11[n5 - 1];
                if (n2 == 2) {
                    n6 += var11_11[n5 - 2];
                }
                int n7 = n = n3 == 0 ? 0 : var11_11[n5 - 1 - n2];
                if (n3 == 2) {
                    n += var11_11[n5 - 1 - n2 - 1];
                }
                if (n6 > 2 || n > 2) {
                    throw new IllegalArgumentException("Invalid dup size");
                }
                ((Compiler)Compiler.this).code[n4] = (byte)(89 + 3 * (n6 - 1) + n);
                var8_8[0] = ++n4;
            }

            public void visitSwap(SwapInstruction swapInstruction) {
                int n = var8_8[0];
                int n2 = var10_10[0];
                byte by = var11_11[n2 - 1];
                byte by2 = var11_11[n2 - 2];
                if (by == 1 && by2 == 1) {
                    ((Compiler)Compiler.this).code[n] = 95;
                } else {
                    ((Compiler)Compiler.this).code[n] = (byte)(89 + 3 * (by - 1) + by2);
                    ((Compiler)Compiler.this).code[n + 1] = (byte)(by == 1 ? 87 : 88);
                    n += 2;
                }
                var8_8[0] = ++n;
            }
        };
        var14_14 = var1_1;
        while (var14_14 < var2_2) {
            block88: {
                block87: {
                    var15_16 = (Instruction)this.instructions[var14_14];
                    var16_17 = var15_16.getOpcode();
                    var17_18 = var14_14;
                    this.instructionsToOffsets[var14_14] = var7_7;
                    if (var16_17 == -1) break block87;
                    var18_19 = false;
                    this.code[var7_7] = (byte)var16_17;
                    ++var7_7;
                    switch (var16_17) {
                        case 3: {
                            if (this.inBasicBlock(var14_14, 2) && this.instructions[var14_14 + 1] instanceof ConditionalBranchInstruction && (var19_20 = (ConditionalBranchInstruction)this.instructions[var14_14 + 1]).getType().equals("I")) {
                                this.code[var7_7 - 1] = (byte)(var19_20.getOperator().ordinal() + 153);
                                var18_19 = true;
                                var15_16 = (Instruction)this.instructions[++var14_14];
                            }
                            if (!var18_19) break block88;
                        }
                        case 1: {
                            if (!var18_19 && this.inBasicBlock(var14_14, 2) && this.instructions[var14_14 + 1] instanceof ConditionalBranchInstruction && (var19_20 = (ConditionalBranchInstruction)this.instructions[var14_14 + 1]).getType().equals("Ljava/lang/Object;")) {
                                this.code[var7_7 - 1] = (byte)(var19_20.getOperator().ordinal() + 198);
                                var18_19 = true;
                                var15_16 = (Instruction)this.instructions[++var14_14];
                            }
                            if (!var18_19) break block88;
                        }
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: {
                            var19_21 = var15_16.getBranchTargets()[0];
                            var20_41 = false;
                            var21_55 = var7_7 - 1;
                            if (this.inBasicBlock(var14_14, 2) && var15_16.getBranchTargets()[0] == var14_14 + 2 && this.instructions[var14_14 + 1] instanceof GotoInstruction) {
                                var20_41 = true;
                                var19_21 = this.instructions[var14_14 + 1].getBranchTargets()[0];
                                ++var14_14;
                            }
                            if (var19_21 <= var14_14) {
                                var22_64 = this.instructionsToOffsets[var19_21] - var21_55;
                                if ((short)var22_64 != var22_64) {
                                    var20_41 = var20_41 == false;
                                    this.writeShort(var7_7, 8);
                                    this.code[var7_7 + 2] = -56;
                                    this.writeInt(var7_7 + 3, var22_64 - 3);
                                    var7_7 += 7;
                                } else {
                                    this.writeShort(var7_7, (short)var22_64);
                                    var7_7 += 2;
                                }
                            } else {
                                if (var4_4) {
                                    var20_41 = var20_41 == false;
                                    this.writeShort(var7_7, 8);
                                    this.code[var7_7 + 2] = -56;
                                    var22_65 /* !! */  = new IntPatch(var7_7 + 2, var7_7 + 3, var19_21);
                                    var7_7 += 7;
                                } else {
                                    var22_65 /* !! */  = new ShortPatch(var21_55, var7_7, var19_21);
                                    var7_7 += 2;
                                }
                                var6_6.add(var22_65 /* !! */ );
                            }
                            if (var20_41) {
                                this.code[var21_55] = (byte)((this.code[var21_55] - 153 ^ 1) + 153);
                                break;
                            } else {
                                ** GOTO lbl71
                            }
                        }
                        {
lbl71:
                            // 2 sources

                            break block88;
                        }
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: 
                        case 166: {
                            var19_22 = var15_16.getBranchTargets()[0];
                            var20_42 = false;
                            var21_56 = var7_7 - 1;
                            if (this.inBasicBlock(var14_14, 2) && var15_16.getBranchTargets()[0] == var14_14 + 2 && this.instructions[var14_14 + 1] instanceof GotoInstruction) {
                                var20_42 = true;
                                var19_22 = this.instructions[var14_14 + 1].getBranchTargets()[0];
                                ++var14_14;
                            }
                            if (var19_22 <= var14_14) {
                                var22_64 = this.instructionsToOffsets[var19_22] - var21_56;
                                if ((short)var22_64 != var22_64) {
                                    var20_42 = var20_42 == false;
                                    this.writeShort(var7_7, 8);
                                    this.code[var7_7 + 2] = -56;
                                    this.writeInt(var7_7 + 3, var22_64 - 3);
                                    var7_7 += 7;
                                } else {
                                    this.writeShort(var7_7, (short)var22_64);
                                    var7_7 += 2;
                                }
                            } else {
                                if (var4_4) {
                                    var20_42 = var20_42 == false;
                                    this.writeShort(var7_7, 8);
                                    this.code[var7_7 + 2] = -56;
                                    var22_66 /* !! */  = new IntPatch(var7_7 + 2, var7_7 + 3, var19_22);
                                    var7_7 += 7;
                                } else {
                                    var22_66 /* !! */  = new ShortPatch(var21_56, var7_7, var19_22);
                                    var7_7 += 2;
                                }
                                var6_6.add(var22_66 /* !! */ );
                            }
                            if (var20_42) {
                                this.code[var21_56] = (byte)((this.code[var21_56] - 159 ^ 1) + 159);
                                break;
                            }
                            break block88;
                        }
                        case 16: {
                            this.writeByte(var7_7, ((ConstantInstruction.ConstInt)var15_16).getIntValue());
                            ++var7_7;
                            break;
                        }
                        case 17: {
                            this.writeShort(var7_7, ((ConstantInstruction.ConstInt)var15_16).getIntValue());
                            var7_7 += 2;
                            break;
                        }
                        case 19: {
                            var20_43 = (ConstantInstruction)var15_16;
                            var19_23 = this.presetConstants != null && var20_43.getLazyConstantPool() == this.presetConstants ? var20_43.getCPIndex() : ((var21_57 = var15_16.getPushedType(null)).equals("I") != false ? this.allocateConstantPoolInteger(((ConstantInstruction.ConstInt)var15_16).getIntValue()) : (var21_57.equals("Ljava/lang/String;") != false ? this.allocateConstantPoolString((String)((ConstantInstruction.ConstString)var15_16).getValue()) : this.allocateConstantPoolFloat(((ConstantInstruction.ConstFloat)var15_16).getFloatValue())));
                            if (var19_23 < 256) {
                                this.code[var7_7 - 1] = 18;
                                this.code[var7_7] = (byte)var19_23;
                                ++var7_7;
                                break;
                            }
                            this.writeShort(var7_7, var19_23);
                            var7_7 += 2;
                            break;
                        }
                        case 20: {
                            var20_44 = (ConstantInstruction)var15_16;
                            var19_24 = this.presetConstants != null && var20_44.getLazyConstantPool() == this.presetConstants ? var20_44.getCPIndex() : ((var21_58 = var15_16.getPushedType(null)).equals("J") != false ? this.allocateConstantPoolLong(((ConstantInstruction.ConstLong)var15_16).getLongValue()) : this.allocateConstantPoolDouble(((ConstantInstruction.ConstDouble)var15_16).getDoubleValue()));
                            this.writeShort(var7_7, var19_24);
                            var7_7 += 2;
                            break;
                        }
                        case 21: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: {
                            if (this.inBasicBlock(var14_14, 4) && this.instructions[var14_14 + 1] instanceof ConstantInstruction.ConstInt && this.instructions[var14_14 + 2] instanceof BinaryOpInstruction && this.instructions[var14_14 + 3] instanceof StoreInstruction) {
                                var19_25 = (LoadInstruction)var15_16;
                                var20_45 = (ConstantInstruction.ConstInt)this.instructions[var14_14 + 1];
                                var21_59 = (BinaryOpInstruction)this.instructions[var14_14 + 2];
                                var22_67 = (StoreInstruction)this.instructions[var14_14 + 3];
                                var23_68 = var20_45.getIntValue();
                                var24_69 = var19_25.getVarIndex();
                                var25_70 = var21_59.getOperator();
                                if ((short)var23_68 == var23_68 && var22_67.getVarIndex() == var24_69 && (var25_70 == IBinaryOpInstruction.Operator.ADD || var25_70 == IBinaryOpInstruction.Operator.SUB) && var21_59.getType().equals("I") && var22_67.getType().equals("I")) {
                                    if (var24_69 < 256 && (byte)var23_68 == var23_68) {
                                        this.code[var7_7 - 1] = -124;
                                        this.writeByte(var7_7, var24_69);
                                        this.writeByte(var7_7 + 1, var23_68);
                                        var7_7 += 2;
                                    } else {
                                        this.code[var7_7 - 1] = -60;
                                        this.code[var7_7] = -124;
                                        this.writeShort(var7_7 + 1, var24_69);
                                        this.writeShort(var7_7 + 3, var23_68);
                                        var7_7 += 5;
                                    }
                                    this.instructionsToOffsets[var14_14 + 1] = -1;
                                    this.instructionsToOffsets[var14_14 + 2] = -1;
                                    this.instructionsToOffsets[var14_14 + 3] = -1;
                                    var14_14 += 3;
                                    break;
                                }
                            }
                            if (var16_17 != 21) break block88;
                        }
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: {
                            var19_26 = ((LoadInstruction)var15_16).getVarIndex();
                            if (var19_26 < 256) {
                                this.writeByte(var7_7, var19_26);
                                ++var7_7;
                                break;
                            }
                            this.code[var7_7 - 1] = -60;
                            this.code[var7_7] = (byte)var16_17;
                            this.writeShort(var7_7 + 1, var19_26);
                            var7_7 += 3;
                            break;
                        }
                        {
                        }
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: {
                            var19_27 = ((StoreInstruction)var15_16).getVarIndex();
                            if (var19_27 < 256) {
                                this.writeByte(var7_7, var19_27);
                                ++var7_7;
                                break;
                            }
                            this.code[var7_7 - 1] = -60;
                            this.code[var7_7] = (byte)var16_17;
                            this.writeShort(var7_7 + 1, var19_27);
                            var7_7 += 3;
                            break;
                        }
                        case 167: {
                            var19_28 = var15_16.getBranchTargets()[0];
                            if (var19_28 <= var14_14) {
                                var20_46 = this.instructionsToOffsets[var19_28] - (var7_7 - 1);
                                if ((short)var20_46 != var20_46) {
                                    this.code[var7_7 - 1] = -56;
                                    this.writeInt(var7_7, var20_46);
                                    var7_7 += 4;
                                    break;
                                }
                                this.writeShort(var7_7, (short)var20_46);
                                var7_7 += 2;
                                break;
                            }
                            if (var19_28 == var14_14 + 1) {
                                --var7_7;
                                break;
                            }
                            if (var4_4) {
                                this.code[var7_7 - 1] = -56;
                                var20_47 /* !! */  = new IntPatch(var7_7 - 1, var7_7, var15_16.getBranchTargets()[0]);
                                var7_7 += 4;
                            } else {
                                var20_47 /* !! */  = new ShortPatch(var7_7 - 1, var7_7, var15_16.getBranchTargets()[0]);
                                var7_7 += 2;
                            }
                            var6_6.add(var20_47 /* !! */ );
                            break;
                        }
                        case 171: {
                            var19_29 = var7_7 - 1;
                            var20_48 = (SwitchInstruction)var15_16;
                            var21_60 = var20_48.getCasesAndLabels();
                            while ((var7_7 & 3) != 0) {
                                this.writeByte(var7_7, 0);
                                ++var7_7;
                            }
                            if (var7_7 + 4 * var21_60.length + 8 > this.code.length) {
                                return false;
                            }
                            this.insertBranchOffsetInt(var6_6, var19_29, var7_7, var20_48.getDefaultLabel());
                            this.writeInt(var7_7 + 4, var21_60.length / 2);
                            var7_7 += 8;
                            var22_64 = 0;
                            while (var22_64 < var21_60.length) {
                                this.writeInt(var7_7, var21_60[var22_64]);
                                this.insertBranchOffsetInt(var6_6, var19_29, var7_7 + 4, var21_60[var22_64 + 1]);
                                var7_7 += 8;
                                var22_64 += 2;
                            }
                            break block88;
                        }
                        case 170: {
                            var19_30 = var7_7 - 1;
                            var20_49 = (SwitchInstruction)var15_16;
                            var21_61 = var20_49.getCasesAndLabels();
                            while ((var7_7 & 3) != 0) {
                                this.writeByte(var7_7, 0);
                                ++var7_7;
                            }
                            if (var7_7 + 2 * var21_61.length + 12 > this.code.length) {
                                return false;
                            }
                            this.insertBranchOffsetInt(var6_6, var19_30, var7_7, var20_49.getDefaultLabel());
                            this.writeInt(var7_7 + 4, var21_61[0]);
                            this.writeInt(var7_7 + 8, var21_61[var21_61.length - 2]);
                            var7_7 += 12;
                            var22_64 = 0;
                            while (var22_64 < var21_61.length) {
                                this.insertBranchOffsetInt(var6_6, var19_30, var7_7, var21_61[var22_64 + 1]);
                                var7_7 += 4;
                                var22_64 += 2;
                            }
                            break block88;
                        }
                        case 178: 
                        case 180: {
                            var19_31 = (GetInstruction)var15_16;
                            var20_50 = this.presetConstants != null && this.presetConstants == var19_31.getLazyConstantPool() ? ((GetInstruction.Lazy)var19_31).getCPIndex() : this.allocateConstantPoolField(var19_31.getClassType(), var19_31.getFieldName(), var19_31.getFieldType());
                            this.writeShort(var7_7, var20_50);
                            var7_7 += 2;
                            break;
                        }
                        case 179: 
                        case 181: {
                            var19_32 = (PutInstruction)var15_16;
                            var20_51 = this.presetConstants != null && this.presetConstants == var19_32.getLazyConstantPool() ? ((PutInstruction.Lazy)var19_32).getCPIndex() : this.allocateConstantPoolField(var19_32.getClassType(), var19_32.getFieldName(), var19_32.getFieldType());
                            this.writeShort(var7_7, var20_51);
                            var7_7 += 2;
                            break;
                        }
                        case 182: 
                        case 183: 
                        case 184: {
                            var19_33 = (InvokeInstruction)var15_16;
                            var20_52 = this.presetConstants != null && this.presetConstants == var19_33.getLazyConstantPool() ? ((InvokeInstruction.Lazy)var19_33).getCPIndex() : this.allocateConstantPoolMethod(var19_33.getClassType(), var19_33.getMethodName(), var19_33.getMethodSignature());
                            this.writeShort(var7_7, var20_52);
                            var7_7 += 2;
                            break;
                        }
                        case 185: {
                            var19_34 = (InvokeInstruction)var15_16;
                            var20_53 = var19_34.getMethodSignature();
                            var21_62 = this.presetConstants != null && this.presetConstants == var19_34.getLazyConstantPool() ? ((InvokeInstruction.Lazy)var19_34).getCPIndex() : this.allocateConstantPoolInterfaceMethod(var19_34.getClassType(), var19_34.getMethodName(), var20_53);
                            this.writeShort(var7_7, var21_62);
                            this.code[var7_7 + 2] = (byte)(Util.getParamsWordSize(var20_53) + 1);
                            this.code[var7_7 + 3] = 0;
                            var7_7 += 4;
                            break;
                        }
                        case 187: {
                            this.writeShort(var7_7, this.allocateConstantPoolClassType(((NewInstruction)var15_16).getType()));
                            var7_7 += 2;
                            break;
                        }
                        case 188: {
                            this.code[var7_7] = Compiler.indexedTypes_T[Util.getTypeIndex(((NewInstruction)var15_16).getType().substring(1))];
                            ++var7_7;
                            break;
                        }
                        case 189: {
                            this.writeShort(var7_7, this.allocateConstantPoolClassType(((NewInstruction)var15_16).getType().substring(1)));
                            var7_7 += 2;
                            break;
                        }
                        case 197: {
                            var19_35 = (NewInstruction)var15_16;
                            this.writeShort(var7_7, this.allocateConstantPoolClassType(var19_35.getType()));
                            this.code[var7_7 + 2] = (byte)var19_35.getArrayBoundsCount();
                            var7_7 += 3;
                            break;
                        }
                        case 192: {
                            this.writeShort(var7_7, this.allocateConstantPoolClassType(((CheckCastInstruction)var15_16).getTypes()[0]));
                            var7_7 += 2;
                            break;
                        }
                        case 193: {
                            this.writeShort(var7_7, this.allocateConstantPoolClassType(((InstanceofInstruction)var15_16).getType()));
                            var7_7 += 2;
                        }
                    }
                    break block88;
                }
                var10_10[0] = var9_9;
                var8_8[0] = var7_7;
                var12_12[0] = var14_14;
                var15_16.visit(var13_13);
                var7_7 = var8_8[0];
                var14_14 = var12_12[0];
            }
            var18_19 = true;
            while (var17_18 <= var14_14) {
                var15_16 = (Instruction)this.instructions[var17_18];
                if (var15_16.isFallThrough() && var18_19) {
                    if (var9_9 < var15_16.getPoppedCount()) {
                        throw new IllegalArgumentException("Stack underflow in intermediate code, at offset " + var17_18);
                    }
                    if (var15_16 instanceof DupInstruction) {
                        var19_36 = (DupInstruction)var15_16;
                        var20_54 = var19_36.getSize();
                        var21_63 = var19_36.getDelta();
                        System.arraycopy(var11_11, var9_9 - var20_54 - var21_63, var11_11, var9_9 - var21_63, var21_63 + var20_54);
                        System.arraycopy(var11_11, var9_9, var11_11, var9_9 - var20_54 - var21_63, var20_54);
                        var9_9 += var20_54;
                    } else if (var15_16 instanceof SwapInstruction) {
                        var19_37 = var11_11[var9_9 - 1];
                        var11_11[var9_9 - 1] = var11_11[var9_9 - 2];
                        var11_11[var9_9 - 2] = var19_37;
                    } else {
                        var9_9 -= var15_16.getPoppedCount();
                        var19_38 = var15_16.getPushedWordSize();
                        if (var19_38 > 0) {
                            var11_11[var9_9] = var19_38;
                            ++var9_9;
                        }
                    }
                } else if (var17_18 + 1 < var2_2) {
                    var19_39 = this.stackWords[var17_18 + 1];
                    if (var19_39 == null) {
                        var18_19 = false;
                    } else {
                        var9_9 = var19_39.length;
                        System.arraycopy(var19_39, 0, var11_11, 0, var9_9);
                    }
                }
                ++var17_18;
            }
            if (var7_7 > this.code.length - 8) {
                return false;
            }
            if (!var18_19) {
                while (var14_14 + 1 < var2_2) {
                    var19_40 = this.stackWords[var14_14 + 1];
                    if (var19_40 != null) {
                        var9_9 = var19_40.length;
                        System.arraycopy(var19_40, 0, var11_11, 0, var9_9);
                        break;
                    }
                    ++var14_14;
                }
            }
            ++var14_14;
        }
        if (!this.applyPatches(var6_6)) {
            if (var4_4) {
                throw new Error("Failed to apply patches even with farBranches on");
            }
            return this.outputInstructions(var1_1, var2_2, var3_3, true, var5_5);
        }
        var14_15 = new byte[var7_7];
        System.arraycopy(this.code, 0, var14_15, 0, var7_7);
        Compiler.releaseCodeBuf(this.code);
        this.code = var14_15;
        return true;
    }

    private int[] buildRawHandlers(int n, int n2) {
        int n3;
        int n4;
        int[] nArray = new int[n2 - n];
        int n5 = 0;
        int n6 = n;
        while (n6 < n2) {
            nArray[n6 - n] = n4 = this.handlers[n6].length;
            if (n4 > n5) {
                n5 = n4;
            }
            ++n6;
        }
        if (n5 == 0) {
            return noRawHandlers;
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        n4 = n5;
        while (n4 > 0) {
            n3 = n;
            while (n3 < n2) {
                if (nArray[n3 - n] == n4) {
                    int n7 = n3;
                    Object object = this.handlers[n3][this.handlers[n3].length - n4];
                    do {
                        int n8 = n3 - n;
                        nArray[n8] = nArray[n8] - 1;
                    } while (++n3 < n2 && nArray[n3 - n] == n4 && this.handlers[n3][this.handlers[n3].length - n4].equals((ExceptionHandler)object));
                    if (object.handler >= n && object.handler < n2) {
                        arrayList.add(new int[]{this.instructionsToOffsets[n7], n3 < n2 ? this.instructionsToOffsets[n3] : this.code.length, this.instructionsToOffsets[object.handler], object.catchClass == null ? 0 : this.allocateConstantPoolClassType(object.catchClass)});
                    }
                    --n3;
                }
                ++n3;
            }
            --n4;
        }
        int[] nArray2 = new int[4 * arrayList.size()];
        n3 = 0;
        for (Object object : arrayList) {
            System.arraycopy(object, 0, nArray2, n3, 4);
            n3 += 4;
        }
        return nArray2;
    }

    private int[] buildBytecodeMap(int n, int n2) {
        int[] nArray = new int[this.code.length];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = -1;
            ++n3;
        }
        n3 = n;
        while (n3 < n2) {
            int n4 = this.instructionsToOffsets[n3];
            if (n4 >= 0) {
                nArray[n4] = this.instructionsToBytecodes[n3];
            }
            ++n3;
        }
        return nArray;
    }

    private void addBackEdge(int n, int n2) {
        int[] nArray = this.backEdges[n];
        if (nArray == null) {
            this.backEdges[n] = new int[]{n2};
        } else if (nArray[nArray.length - 1] < 0) {
            int n3 = 1;
            int n4 = nArray.length - 1;
            while (true) {
                if (n4 - n3 < 2) {
                    if (nArray[n3] < 0) break;
                    if (nArray[n4] >= 0) {
                        throw new Error("Failed binary search");
                    }
                    n3 = n4;
                    break;
                }
                int n5 = (n3 + n4) / 2;
                if (nArray[n5] < 0) {
                    n4 = n5;
                    continue;
                }
                n3 = n5 + 1;
            }
            nArray[n3] = n2;
        } else {
            int[] nArray2 = new int[nArray.length * 2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray2[nArray.length] = n2;
            int n6 = nArray.length + 1;
            while (n6 < nArray2.length) {
                nArray2[n6] = -1;
                ++n6;
            }
            this.backEdges[n] = nArray2;
        }
    }

    private void addLiveVar(int n, int n2) {
        IInstruction iInstruction;
        while (!(this.liveLocals[n].get(n2) || (iInstruction = this.instructions[n]) instanceof StoreInstruction && ((StoreInstruction)iInstruction).getVarIndex() == n2)) {
            this.liveLocals[n].set(n2);
            int[] nArray = this.backEdges[n];
            if (nArray != null) {
                int n3 = 0;
                while (n3 < nArray.length) {
                    this.addLiveVar(nArray[n3], n2);
                    ++n3;
                }
            }
            if (n <= 0 || !this.instructions[n - 1].isFallThrough()) break;
            --n;
        }
    }

    private void makeLiveLocals() {
        Object[] objectArray;
        Object object;
        this.liveLocals = new BitSet[this.instructions.length];
        this.backEdges = new int[this.instructions.length][];
        int n = 0;
        while (n < this.instructions.length) {
            object = this.instructions[n];
            int[] nArray = object.getBranchTargets();
            int n2 = 0;
            while (n2 < nArray.length) {
                this.addBackEdge(nArray[n2], n);
                ++n2;
            }
            objectArray = this.handlers[n];
            int n3 = 0;
            while (n3 < objectArray.length) {
                this.addBackEdge(objectArray[n3].handler, n);
                ++n3;
            }
            this.liveLocals[n] = new BitSet();
            ++n;
        }
        n = 0;
        while (n < this.backEdges.length) {
            object = this.backEdges[n];
            if (object != null && object[((Object)object).length - 1] < 0) {
                int n4 = ((Object)object).length;
                while (object[n4 - 1] < 0) {
                    --n4;
                }
                objectArray = new int[n4];
                System.arraycopy(object, 0, objectArray, 0, objectArray.length);
                this.backEdges[n] = (int[])objectArray;
            }
            ++n;
        }
        n = 0;
        while (n < this.instructions.length) {
            object = this.instructions[n];
            if (object instanceof LoadInstruction) {
                this.addLiveVar(n, ((LoadInstruction)object).getVarIndex());
            }
            ++n;
        }
    }

    private String getAndCheckLocalType(int n, int n2) {
        String[] stringArray = this.localTypes[n];
        String string = "L?;";
        if (n2 < stringArray.length) {
            string = stringArray[n2];
        }
        if (string.equals("L;") || string.equals("L?;")) {
            throw new IllegalArgumentException("Cannot split oversized method because local " + n2 + " is undefined at " + n);
        }
        return string;
    }

    private void allocateLocals(int n) {
        if (this.maxLocals < this.allocatedLocals + n * 2) {
            this.maxLocals = this.allocatedLocals + n * 2;
        }
    }

    private HelperPatch makeHelperPatch(int n, int n2, int n3, int n4, int n5) {
        String string;
        String string2 = n3 >= 0 ? this.getAndCheckLocalType(n + n2, n3) : "V";
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        int n6 = this.stackTypes[n].length;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        this.allocateLocals(n6 - n4);
        int n7 = n6 - 1;
        while (n7 >= n4) {
            if (n7 < n5) {
                arrayList.add(DupInstruction.make(0));
            }
            arrayList.add(StoreInstruction.make(this.stackTypes[n][n7], this.allocatedLocals + 2 * (n7 - n4)));
            --n7;
        }
        BitSet bitSet = this.liveLocals[n];
        int n8 = 0;
        while (n8 < bitSet.length()) {
            if (bitSet.get(n8)) {
                string = this.getAndCheckLocalType(n, n8);
                stringBuffer.append(string);
                arrayList.add(LoadInstruction.make(string, n8));
                if (Util.getWordSize(string) > 1) {
                    ++n8;
                }
            } else {
                stringBuffer.append("I");
                arrayList.add(ConstantInstruction.make(0));
            }
            ++n8;
        }
        n8 = n4;
        while (n8 < n6) {
            arrayList.add(LoadInstruction.make(this.stackTypes[n][n8], this.allocatedLocals + 2 * (n8 - n4)));
            stringBuffer.append(this.stackTypes[n][n8]);
            if (Util.getWordSize(this.stackTypes[n][n8]) == 2) {
                stringBuffer.append("I");
                arrayList.add(ConstantInstruction.make(0));
            }
            ++n8;
        }
        stringBuffer.append(")");
        stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        string = this.createHelperMethod(true, string3);
        arrayList.add(InvokeInstruction.make(string3, this.classType, string, IInvokeInstruction.Dispatch.STATIC));
        int n9 = this.maxStack;
        this.maxStack += n6 - n4;
        int n10 = 4 * (n6 - n4);
        byte[] byArray = new byte[n6 - n4];
        int n11 = 0;
        while (n11 < byArray.length) {
            byArray[n11] = Util.getWordSize(this.stackTypes[n][n4 + n11]);
            ++n11;
        }
        if (!this.outputInstructions(n, n + n2, n10, false, byArray)) {
            throw new Error("Helper function is overlarge");
        }
        byte[] byArray2 = new byte[this.code.length + (n3 >= 0 ? 5 : 1)];
        int n12 = 0;
        while (n12 < n6 - n4) {
            int n13 = this.allocatedLocals + n12 * 2;
            byArray2[n12 * 4] = -60;
            byArray2[n12 * 4 + 1] = (byte)LoadInstruction.make(this.stackTypes[n][n12 + n4], 500).getOpcode();
            byArray2[n12 * 4 + 2] = (byte)(n13 >> 8);
            byArray2[n12 * 4 + 3] = (byte)n13;
            ++n12;
        }
        System.arraycopy(this.code, n10, byArray2, n10, this.code.length - n10);
        n12 = this.code.length;
        if (n3 >= 0) {
            byArray2[n12] = -60;
            byArray2[n12 + 1] = (byte)LoadInstruction.make(string2, 500).getOpcode();
            byArray2[n12 + 2] = (byte)(n3 >> 8);
            byArray2[n12 + 3] = (byte)n3;
            byArray2[n12 + 4] = (byte)ReturnInstruction.make(string2).getOpcode();
            arrayList.add(StoreInstruction.make(string2, n3));
        } else {
            byArray2[n12] = (byte)ReturnInstruction.make("V").getOpcode();
        }
        if (arrayList.size() > n2) {
            return null;
        }
        int[] nArray = this.buildRawHandlers(n, n + n2);
        int[] nArray2 = this.buildBytecodeMap(n, n + n2);
        this.auxMethods.add(new Output(string, string3, byArray2, nArray, nArray2, this.maxLocals, this.maxStack, true));
        this.maxStack = n9;
        Instruction[] instructionArray = new Instruction[arrayList.size()];
        arrayList.toArray(instructionArray);
        ExceptionHandler[] exceptionHandlerArray = this.handlers[n];
        ArrayList<ExceptionHandler> arrayList2 = new ArrayList<ExceptionHandler>();
        int n14 = 0;
        while (n14 < exceptionHandlerArray.length) {
            int n15 = exceptionHandlerArray[n14].handler;
            if (n15 < n || n15 >= n + n2) {
                arrayList2.add(exceptionHandlerArray[n14]);
            }
            ++n14;
        }
        ExceptionHandler[] exceptionHandlerArray2 = new ExceptionHandler[arrayList2.size()];
        arrayList2.toArray(exceptionHandlerArray2);
        return new HelperPatch(n, n2, instructionArray, exceptionHandlerArray2);
    }

    private HelperPatch findBlock(int n, int n2) {
        while (n2 > 100) {
            HelperPatch helperPatch;
            block54: {
                int n3;
                Object object;
                int n4;
                int n5;
                boolean bl;
                int[] nArray;
                int n6 = n - 1;
                int n7 = n + 1;
                while (n7 < n + n2) {
                    nArray = this.backEdges[n7];
                    bl = false;
                    int n8 = 0;
                    while (nArray != null && n8 < nArray.length) {
                        if (nArray[n8] < n || nArray[n8] >= n + n2) {
                            bl = true;
                        }
                        ++n8;
                    }
                    if (bl) {
                        HelperPatch helperPatch2 = this.findBlock(n6 + 1, n7 - n6 - 1);
                        if (helperPatch2 != null) {
                            return helperPatch2;
                        }
                        n6 = n7;
                    }
                    ++n7;
                }
                if (n6 >= n) {
                    return null;
                }
                if (!this.instructions[n + n2 - 1].isFallThrough()) {
                    --n2;
                    continue;
                }
                n6 = n - 1;
                n7 = n;
                while (n7 < n + n2) {
                    nArray = this.instructions[n7].getBranchTargets();
                    bl = false;
                    if (this.instructions[n7] instanceof ReturnInstruction) {
                        bl = true;
                    }
                    int n9 = 0;
                    while (n9 < nArray.length) {
                        if (nArray[n9] < n || nArray[n9] >= n + n2) {
                            bl = true;
                        }
                        ++n9;
                    }
                    if (bl) {
                        HelperPatch helperPatch3 = this.findBlock(n6 + 1, n7 - n6 - 1);
                        if (helperPatch3 != null) {
                            return helperPatch3;
                        }
                        n6 = n7;
                    }
                    ++n7;
                }
                if (n6 >= n) {
                    return null;
                }
                n6 = n - 1;
                n7 = n;
                while (n7 < n + n2) {
                    int n10;
                    boolean bl2 = false;
                    ExceptionHandler[] exceptionHandlerArray = this.handlers[n7];
                    int n11 = 0;
                    while (n11 < exceptionHandlerArray.length) {
                        n10 = exceptionHandlerArray[n11].handler;
                        if (n10 < n || n10 >= n + n2) {
                            bl2 = true;
                        }
                        ++n11;
                    }
                    int[] nArray2 = this.instructions[n7].getBranchTargets();
                    n10 = 0;
                    while (n10 < nArray2.length) {
                        n5 = nArray2[n10];
                        if (n5 < n || n5 >= n + n2) {
                            bl2 = true;
                        }
                        ++n10;
                    }
                    if (bl2) {
                        HelperPatch helperPatch4 = this.findBlock(n6 + 1, n7 - n6 - 1);
                        if (helperPatch4 != null) {
                            return helperPatch4;
                        }
                        n6 = n7;
                    }
                    ++n7;
                }
                if (n6 >= n) {
                    return null;
                }
                if (this.stackTypes[n] == null) {
                    while (this.stackTypes[n] == null && n2 > 0) {
                        ++n;
                        --n2;
                    }
                    continue;
                }
                n7 = Integer.MAX_VALUE;
                int n12 = Integer.MAX_VALUE;
                int n13 = n;
                while (n13 < n + n2) {
                    if (this.stackTypes[n13] == null) {
                        n7 = 0;
                        n12 = 0;
                        break;
                    }
                    int n14 = this.stackTypes[n13].length - this.instructions[n13].getPoppedCount();
                    n12 = Math.min(n12, n14);
                    if (this.instructions[n13] instanceof DupInstruction) {
                        n14 += this.instructions[n13].getPoppedCount();
                    }
                    n7 = Math.min(n7, n14);
                    ++n13;
                }
                if (n7 > n12 + 1 || n7 == n12 + 1 && n7 < this.stackTypes[n].length) {
                    ++n;
                    --n2;
                    continue;
                }
                n13 = 0;
                int n15 = n12;
                while (n15 < n7) {
                    String string = this.stackTypes[n][n15];
                    if (string == null || string.equals("L?;") || string.equals("L;")) {
                        n13 = 1;
                        break;
                    }
                    ++n15;
                }
                if (n13 != 0) {
                    ++n;
                    --n2;
                    continue;
                }
                if (this.stackTypes[n + n2] == null || this.stackTypes[n + n2].length > n7) {
                    while (n2 > 0 && this.stackTypes[n + n2] == null || this.stackTypes[n + n2].length > n7) {
                        --n2;
                    }
                    continue;
                }
                BitSet bitSet = this.liveLocals[n + n2];
                boolean bl3 = false;
                n5 = -1;
                int n16 = -1;
                int n17 = -1;
                int n18 = n;
                while (n18 < n + n2) {
                    IInstruction iInstruction = this.instructions[n18];
                    if (iInstruction instanceof StoreInstruction && bitSet.get(n4 = ((StoreInstruction)iInstruction).getVarIndex()) && n4 != n5) {
                        if (n5 < 0) {
                            n5 = n4;
                            n16 = n18;
                        } else {
                            bl3 = true;
                            n17 = n18;
                            break;
                        }
                    }
                    ++n18;
                }
                if (bl3) {
                    object = this.findBlock(n, n17 - n);
                    if (object != null) {
                        return object;
                    }
                    n2 = n + n2 - (n16 + 1);
                    n = n16 + 1;
                    continue;
                }
                object = this.handlers[n];
                int n19 = 0;
                n4 = 0;
                while (n4 < ((ExceptionHandler[])object).length) {
                    n3 = object[n4].handler;
                    if (n3 < n || n3 >= n + n2) {
                        ++n19;
                    }
                    ++n4;
                }
                n4 = 0;
                n3 = -1;
                int n20 = n + 1;
                while (n20 < n + n2) {
                    ExceptionHandler[] exceptionHandlerArray = this.handlers[n20];
                    int n21 = 0;
                    int n22 = 0;
                    while (n22 < exceptionHandlerArray.length) {
                        int n23 = exceptionHandlerArray[n22].handler;
                        if (n23 < n || n23 >= n + n2) {
                            boolean bl4 = false;
                            int n24 = 0;
                            while (n24 < ((ExceptionHandler[])object).length) {
                                if (object[n24].equals(exceptionHandlerArray[n22])) {
                                    bl4 = true;
                                    break;
                                }
                                ++n24;
                            }
                            if (bl4) {
                                ++n21;
                            }
                        }
                        ++n22;
                    }
                    if (n21 != n19) {
                        n3 = n20;
                        n4 = 1;
                        break;
                    }
                    ++n20;
                }
                if (n4 != 0) {
                    HelperPatch helperPatch5 = this.findBlock(n, n3 - n);
                    if (helperPatch5 != null) {
                        return helperPatch5;
                    }
                    n = n3;
                    continue;
                }
                try {
                    helperPatch = this.makeHelperPatch(n, n2, n5, n12, n7);
                    if (helperPatch != null) break block54;
                    return null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
            return helperPatch;
        }
        return null;
    }

    private void makeHelpers() {
        int n = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (n + 5000 < this.instructions.length) {
            HelperPatch helperPatch = this.findBlock(n, 5000);
            if (helperPatch != null) {
                arrayList.add(helperPatch);
                n = helperPatch.start + helperPatch.length;
                continue;
            }
            n += 500;
        }
        for (HelperPatch helperPatch : arrayList) {
            System.arraycopy(helperPatch.code, 0, this.instructions, helperPatch.start, helperPatch.code.length);
            int n2 = 0;
            while (n2 < helperPatch.length) {
                int n3 = n2 + helperPatch.start;
                this.instructions[n3] = n2 < helperPatch.code.length ? helperPatch.code[n2] : PopInstruction.make(0);
                this.handlers[n3] = helperPatch.handlers;
                this.instructionsToBytecodes[n3] = -1;
                ++n2;
            }
        }
    }

    private void makeTypes() {
        Verifier verifier = new Verifier(this.isStatic, this.classType, this.signature, this.instructions, this.handlers);
        if (this.hierarchy != null) {
            verifier.setClassHierarchy(this.hierarchy);
        }
        try {
            verifier.computeTypes();
        }
        catch (Analyzer.FailureException failureException) {
            throw new IllegalArgumentException("Cannot split oversized method because verification failed: " + failureException.getMessage());
        }
        this.localTypes = verifier.getLocalTypes();
        this.stackTypes = verifier.getStackTypes();
    }

    public final void compile() {
        this.collectInstructionInfo();
        this.computeStackWords();
        if (!this.outputInstructions(0, this.instructions.length, 0, false, null)) {
            this.allocatedLocals = this.maxLocals;
            this.makeLiveLocals();
            this.makeTypes();
            this.auxMethods = new ArrayList();
            this.makeHelpers();
            this.computeStackWords();
            if (!this.outputInstructions(0, this.instructions.length, 0, false, null)) {
                throw new Error("Input code too large; consider breaking up your code");
            }
        }
        this.mainMethod = new Output(null, null, this.code, this.buildRawHandlers(0, this.instructions.length), this.buildBytecodeMap(0, this.instructions.length), this.maxLocals, this.maxStack, this.isStatic);
        this.instructionsToOffsets = null;
        this.branchTargets = null;
        this.stackWords = null;
        this.code = null;
    }

    public final Output getOutput() {
        return this.mainMethod;
    }

    public final Output[] getAuxiliaryMethods() {
        if (this.auxMethods == null) {
            return null;
        }
        Output[] outputArray = new Output[this.auxMethods.size()];
        this.auxMethods.toArray(outputArray);
        return outputArray;
    }

    static class HelperPatch {
        final int start;
        final int length;
        final Instruction[] code;
        final ExceptionHandler[] handlers;

        HelperPatch(int n, int n2, Instruction[] instructionArray, ExceptionHandler[] exceptionHandlerArray) {
            this.start = n;
            this.length = n2;
            this.code = instructionArray;
            this.handlers = exceptionHandlerArray;
        }
    }

    class IntPatch
    extends Patch {
        IntPatch(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        boolean apply() {
            Compiler.this.writeInt(this.instrOffset, Compiler.this.instructionsToOffsets[this.targetLabel] - this.instrStart);
            return true;
        }
    }

    public static final class Output {
        private final byte[] code;
        private final int[] rawHandlers;
        private final int[] newBytecodesToOldBytecodes;
        private final String name;
        private final String signature;
        private final boolean isStatic;
        private final int maxLocals;
        private final int maxStack;

        Output(String string, String string2, byte[] byArray, int[] nArray, int[] nArray2, int n, int n2, boolean bl) {
            this.code = byArray;
            this.name = string;
            this.signature = string2;
            this.rawHandlers = nArray;
            this.newBytecodesToOldBytecodes = nArray2;
            this.isStatic = bl;
            this.maxLocals = n;
            this.maxStack = n2;
        }

        public byte[] getCode() {
            return this.code;
        }

        public String getMethodName() {
            return this.name;
        }

        public String getMethodSignature() {
            return this.signature;
        }

        public int getAccessFlags() {
            return this.name != null ? 2 | (this.isStatic ? 8 : 0) : 0;
        }

        public int[] getRawHandlers() {
            return this.rawHandlers;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public int[] getNewBytecodesToOldBytecodes() {
            return this.newBytecodesToOldBytecodes;
        }

        public int getMaxStack() {
            return this.maxStack;
        }

        public int getMaxLocals() {
            return this.maxLocals;
        }
    }

    abstract class Patch {
        final int instrStart;
        final int instrOffset;
        final int targetLabel;

        Patch(int n, int n2, int n3) {
            this.instrStart = n;
            this.instrOffset = n2;
            this.targetLabel = n3;
        }

        abstract boolean apply();
    }

    class ShortPatch
    extends Patch {
        ShortPatch(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        boolean apply() {
            int n = Compiler.this.instructionsToOffsets[this.targetLabel] - this.instrStart;
            if ((short)n == n) {
                Compiler.this.writeShort(this.instrOffset, n);
                return true;
            }
            return false;
        }
    }
}

