/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IConversionInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class ConversionInstruction
extends Instruction
implements IConversionInstruction {
    private final String fromType;
    private final String toType;
    private static final ConversionInstruction[] preallocated = ConversionInstruction.preallocate();

    protected ConversionInstruction(short s) {
        super(s);
        if (s < 145) {
            int n = s - 133;
            this.toType = indexedTypes[ConversionInstruction.skip(n % 3, n / 3)];
        } else {
            this.toType = indexedTypes[s - 145 + 5];
        }
        this.fromType = s < 145 ? indexedTypes[(s - 133) / 3] : "I";
    }

    private static ConversionInstruction[] preallocate() {
        ConversionInstruction[] conversionInstructionArray = new ConversionInstruction[15];
        short s = 133;
        while (s <= 147) {
            conversionInstructionArray[s - 133] = new ConversionInstruction(s);
            s = (short)(s + 1);
        }
        return conversionInstructionArray;
    }

    public static ConversionInstruction make(String string, String string2) throws IllegalArgumentException {
        int n = Util.getTypeIndex(string);
        int n2 = Util.getTypeIndex(string2);
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Cannot convert from type " + string);
        }
        if (n == 0 && n2 >= 5 && n2 <= 7) {
            return preallocated[12 + (n2 - 5)];
        }
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("Cannot convert from type " + string + " to type " + string2);
        }
        if (n2 == n) {
            throw new IllegalArgumentException("Cannot convert from type " + string + " to same type");
        }
        return preallocated[n * 3 + (n2 > n ? n2 - 1 : n2)];
    }

    public int getPoppedCount() {
        return 1;
    }

    public String getFromType() {
        return this.fromType;
    }

    private static int skip(int n, int n2) {
        return n < n2 ? n : n + 1;
    }

    public String getToType() {
        return this.toType;
    }

    public String getPushedType(String[] stringArray) {
        return this.getToType();
    }

    public byte getPushedWordSize() {
        return Util.getWordSize(this.getToType());
    }

    public boolean equals(Object object) {
        if (object instanceof ConversionInstruction) {
            ConversionInstruction conversionInstruction = (ConversionInstruction)object;
            return conversionInstruction.opcode == this.opcode;
        }
        return false;
    }

    public int hashCode() {
        return this.opcode * 143111;
    }

    public String toString() {
        return "Conversion(" + this.getFromType() + "," + this.getToType() + ")";
    }

    public void visit(IInstruction.Visitor visitor) throws NullPointerException {
        visitor.visitConversion(this);
    }

    public boolean isPEI() {
        return false;
    }

    public boolean throwsExceptionOnOverflow() {
        return false;
    }
}

