/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ArrayLoadInstruction;
import com.ibm.wala.shrikeBT.ArrayStoreInstruction;
import com.ibm.wala.shrikeBT.BinaryOpInstruction;
import com.ibm.wala.shrikeBT.CheckCastInstruction;
import com.ibm.wala.shrikeBT.ComparisonInstruction;
import com.ibm.wala.shrikeBT.ConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.ConversionInstruction;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.GetInstruction;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.InstanceofInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.PutInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.ShiftInstruction;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeBT.UnaryOpInstruction;
import com.ibm.wala.shrikeBT.Util;
import java.util.ArrayList;

public abstract class Decoder
implements Constants {
    private static final int UNSEEN = -1;
    private static final int INSIDE_INSTRUCTION = -2;
    private static final ExceptionHandler[] noHandlers = new ExceptionHandler[0];
    private static final Instruction[] simpleInstructions = Decoder.makeSimpleInstructions();
    private static final Instruction makeZero = ConstantInstruction.make(0);
    private IInstruction[] instructions;
    private ExceptionHandler[][] handlers;
    private int[] instructionsToBytecodes;
    private final ConstantPoolReader constantPool;
    private final byte[] code;
    private final int[] rawHandlers;
    private int[] decodedOffset;
    private byte[] decodedSize;
    private ArrayList<Instruction> decoded;
    private int[] belongsToSub;
    private int[] JSRs;
    private RetInfo[] retInfo;

    private static int skip(int n, int n2) {
        return n < n2 ? n : n + 1;
    }

    private static Instruction[] makeSimpleInstructions() {
        Instruction[] instructionArray = new Instruction[256];
        instructionArray[1] = ConstantInstruction.make("L;", null);
        int n = 2;
        while (n <= 8) {
            instructionArray[n] = ConstantInstruction.make("I", new Integer(n - 2 - 1));
            ++n;
        }
        n = 9;
        while (n <= 10) {
            instructionArray[n] = ConstantInstruction.make("J", new Long(n - 9));
            ++n;
        }
        n = 11;
        while (n <= 13) {
            instructionArray[n] = ConstantInstruction.make("F", new Float(n - 11));
            ++n;
        }
        n = 14;
        while (n <= 15) {
            instructionArray[n] = ConstantInstruction.make("D", new Double(n - 14));
            ++n;
        }
        n = 26;
        while (n <= 45) {
            instructionArray[n] = LoadInstruction.make(indexedTypes[(n - 26) / 4], (n - 26) % 4);
            ++n;
        }
        n = 46;
        while (n <= 53) {
            instructionArray[n] = ArrayLoadInstruction.make(indexedTypes[n - 46]);
            ++n;
        }
        n = 59;
        while (n <= 78) {
            instructionArray[n] = StoreInstruction.make(indexedTypes[(n - 59) / 4], (n - 59) % 4);
            ++n;
        }
        n = 79;
        while (n <= 86) {
            instructionArray[n] = ArrayStoreInstruction.make(indexedTypes[n - 79]);
            ++n;
        }
        instructionArray[87] = PopInstruction.make(1);
        instructionArray[89] = DupInstruction.make(1, 0);
        instructionArray[90] = DupInstruction.make(1, 1);
        instructionArray[95] = SwapInstruction.make();
        n = 96;
        while (n <= 115) {
            instructionArray[n] = BinaryOpInstruction.make(indexedTypes[(n - 96) % 4], IBinaryOpInstruction.Operator.values()[(n - 96) / 4]);
            ++n;
        }
        n = 116;
        while (n <= 119) {
            instructionArray[n] = UnaryOpInstruction.make(indexedTypes[n - 116], IUnaryOpInstruction.Operator.NEG);
            ++n;
        }
        n = 120;
        while (n <= 125) {
            instructionArray[n] = ShiftInstruction.make(indexedTypes[(n - 120) % 2], IShiftInstruction.Operator.values()[(n - 120) / 2]);
            ++n;
        }
        n = 126;
        while (n <= 131) {
            instructionArray[n] = BinaryOpInstruction.make(indexedTypes[(n - 126) % 2], IBinaryOpInstruction.Operator.values()[IBinaryOpInstruction.Operator.AND.ordinal() + (n - 126) / 2]);
            ++n;
        }
        n = 133;
        while (n <= 144) {
            instructionArray[n] = ConversionInstruction.make(indexedTypes[(n - 133) / 3], indexedTypes[Decoder.skip((n - 133) % 3, (n - 133) / 3)]);
            ++n;
        }
        n = 145;
        while (n <= 147) {
            instructionArray[n] = ConversionInstruction.make("I", indexedTypes[5 + (n - 145)]);
            ++n;
        }
        instructionArray[148] = ComparisonInstruction.make("J", IComparisonInstruction.Operator.CMP);
        n = 149;
        while (n <= 152) {
            instructionArray[n] = ComparisonInstruction.make(indexedTypes[2 + (n - 149) / 2], IComparisonInstruction.Operator.values()[IComparisonInstruction.Operator.CMPL.ordinal() + (n - 149) % 2]);
            ++n;
        }
        n = 172;
        while (n <= 176) {
            instructionArray[n] = ReturnInstruction.make(indexedTypes[n - 172]);
            ++n;
        }
        instructionArray[177] = ReturnInstruction.make("V");
        instructionArray[191] = ThrowInstruction.make(false);
        instructionArray[194] = MonitorInstruction.make(true);
        instructionArray[195] = MonitorInstruction.make(false);
        instructionArray[190] = ArrayLengthInstruction.make();
        return instructionArray;
    }

    protected Decoder(byte[] byArray, int[] nArray, ConstantPoolReader constantPoolReader) {
        this.code = byArray;
        this.rawHandlers = nArray;
        this.constantPool = constantPoolReader;
    }

    public ConstantPoolReader getConstantPool() {
        return this.constantPool;
    }

    private int decodeShort(int n) {
        return this.code[n] << 8 | this.code[n + 1] & 0xFF;
    }

    private int decodeUShort(int n) {
        return (this.code[n] & 0xFF) << 8 | this.code[n + 1] & 0xFF;
    }

    private int decodeInt(int n) {
        return this.code[n] << 24 | (this.code[n + 1] & 0xFF) << 16 | (this.code[n + 2] & 0xFF) << 8 | this.code[n + 3] & 0xFF;
    }

    private Instruction makeConstantPoolLoad(int n) throws InvalidBytecodeException {
        ConstantInstruction constantInstruction = ConstantInstruction.make(this.constantPool, n);
        if (constantInstruction == null) {
            throw new InvalidBytecodeException("Constant pool item at index " + n + " (type " + this.constantPool.getConstantPoolItemType(n) + ") cannot be loaded");
        }
        return constantInstruction;
    }

    private static int elemCount(byte[] byArray, int n) throws InvalidBytecodeException {
        if (n < 0) {
            throw new InvalidBytecodeException("Stack underflow");
        }
        if (byArray[n] == 2) {
            return 1;
        }
        if (n < 1) {
            throw new InvalidBytecodeException("Stack underflow");
        }
        if (byArray[n - 1] != 1) {
            throw new InvalidBytecodeException("Trying to manipulate a pair of one-word items but one of them is two words");
        }
        return 2;
    }

    private String getPrimitiveType(int n) throws InvalidBytecodeException {
        switch (n) {
            case 4: {
                return "Z";
            }
            case 5: {
                return "C";
            }
            case 6: {
                return "F";
            }
            case 7: {
                return "D";
            }
            case 8: {
                return "B";
            }
            case 9: {
                return "S";
            }
            case 10: {
                return "I";
            }
            case 11: {
                return "J";
            }
        }
        throw new InvalidBytecodeException("Unknown primitive type " + n);
    }

    private boolean doesSubroutineReturn(int n) {
        int n2 = 0;
        while (n2 < this.retInfo.length) {
            if (this.retInfo[n2] != null && this.retInfo[n2].sub == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int findReturnToVar(int n, int n2, boolean[] blArray) throws InvalidBytecodeException {
        while (!blArray[n2]) {
            int n3;
            if (this.retInfo[n2] != null && this.retInfo[n2].retVar == n) {
                return n2;
            }
            int n4 = this.decodedOffset[n2];
            if (n4 == -1) {
                return 0;
            }
            byte by = this.decodedSize[n2];
            Instruction instruction = null;
            blArray[n2] = true;
            int n5 = 0;
            while (n5 < this.rawHandlers.length) {
                if (this.rawHandlers[n5] <= n2 && n2 < this.rawHandlers[n5 + 1]) {
                    int n6 = this.rawHandlers[n5 + 2];
                    if (this.decodedOffset[n6] < 0) {
                        byte[] byArray = new byte[this.code.length * 2];
                        byArray[0] = 1;
                        this.decodeAt(n6, 1, byArray);
                    }
                    if ((n3 = this.findReturnToVar(n, n6, blArray)) != 0) {
                        return n3;
                    }
                }
                n5 += 4;
            }
            if (this.JSRs[n2] != 0) {
                if (!this.doesSubroutineReturn(this.JSRs[n2])) {
                    return 0;
                }
            } else {
                n5 = 0;
                while (n5 < by) {
                    instruction = this.decoded.get(n4 + n5);
                    if (instruction instanceof StoreInstruction && ((StoreInstruction)instruction).getVarIndex() == n) {
                        return 0;
                    }
                    int[] nArray = instruction.getBranchTargets();
                    n3 = 0;
                    while (n3 < nArray.length) {
                        int n7;
                        if (nArray[n3] >= 0 && (n7 = this.findReturnToVar(n, nArray[n3], blArray)) != 0) {
                            return n7;
                        }
                        ++n3;
                    }
                    ++n5;
                }
                if (instruction != null && !instruction.isFallThrough()) {
                    return 0;
                }
            }
            while (this.decodedOffset[++n2] == -2) {
            }
        }
        return 0;
    }

    private int findReturn(int n) throws InvalidBytecodeException {
        if (this.decodedSize[n] < 1) {
            throw new InvalidBytecodeException("Subroutine at " + n + " does not start with an astore or pop instruction");
        }
        Instruction instruction = this.decoded.get(this.decodedOffset[n]);
        if (instruction instanceof PopInstruction) {
            return 0;
        }
        if (!(instruction instanceof StoreInstruction)) {
            throw new InvalidBytecodeException("Subroutine at " + n + " does not start with an astore or pop instruction");
        }
        int n2 = ((StoreInstruction)instruction).getVarIndex();
        while (this.decodedOffset[++n] == -2) {
        }
        return this.findReturnToVar(n2, n, new boolean[this.code.length]);
    }

    private void decodeSubroutine(int n, int n2, int n3, int n4, byte[] byArray) throws InvalidBytecodeException {
        int n5;
        if (this.JSRs == null) {
            this.JSRs = new int[this.code.length];
            this.retInfo = new RetInfo[this.code.length];
        }
        this.JSRs[n] = n3;
        if (this.decodedOffset[n3] < 0) {
            byArray[n4] = 1;
            this.decodeAt(n3, ++n4, byArray);
        }
        if ((n5 = this.findReturn(n3)) > 0) {
            RetInfo retInfo = this.retInfo[n5];
            retInfo.sub = n3;
            byte[] byArray2 = new byte[retInfo.stackWords.length];
            System.arraycopy(retInfo.stackWords, 0, byArray2, 0, byArray2.length);
            this.decodeAt(n2, retInfo.stackLen, byArray2);
        }
    }

    private void assignReachablesToSubroutine(int n, int n2) {
        while (this.belongsToSub[n] < 0) {
            byte by = this.decodedSize[n];
            this.belongsToSub[n] = n2;
            int n3 = 0;
            while (n3 < this.rawHandlers.length) {
                if (this.rawHandlers[n3] <= n && n < this.rawHandlers[n3 + 1]) {
                    this.assignReachablesToSubroutine(this.rawHandlers[n3 + 2], n2);
                }
                n3 += 4;
            }
            Instruction instruction = null;
            if (by > 0 && this.JSRs[n] == 0) {
                int n4 = this.decodedOffset[n];
                instruction = this.decoded.get(n4 + by - 1);
                int[] nArray = instruction.getBranchTargets();
                int n5 = 0;
                while (n5 < nArray.length) {
                    if (nArray[n5] >= 0) {
                        this.assignReachablesToSubroutine(nArray[n5], n2);
                    }
                    ++n5;
                }
            }
            if (instruction != null && !instruction.isFallThrough()) {
                return;
            }
            if (this.JSRs[n] != 0 && !this.doesSubroutineReturn(this.JSRs[n])) {
                return;
            }
            while (this.decodedOffset[++n] < 0) {
            }
        }
    }

    private void assignSubroutine(int n) {
        this.assignReachablesToSubroutine(n, n);
        int n2 = 0;
        while (n2 < this.belongsToSub.length) {
            if (this.JSRs[n2] > 0 && this.belongsToSub[n2] == n && this.belongsToSub[this.JSRs[n2]] < 0) {
                this.assignSubroutine(this.JSRs[n2]);
            }
            ++n2;
        }
    }

    private void computeSubroutineMap() {
        this.belongsToSub = new int[this.code.length];
        int n = 0;
        while (n < this.belongsToSub.length) {
            this.belongsToSub[n] = -1;
            ++n;
        }
        this.assignSubroutine(0);
    }

    private int decodeBytecodeInstruction(int n, int n2, byte[] byArray) throws InvalidBytecodeException {
        int n3 = this.code[n] & 0xFF;
        Instruction instruction = simpleInstructions[n3];
        if (instruction != null) {
            this.decoded.add(instruction);
            return n + 1;
        }
        boolean bl = false;
        block38: while (true) {
            ++n;
            switch (n3) {
                case 0: {
                    break block38;
                }
                case 16: {
                    instruction = ConstantInstruction.make(this.code[n]);
                    ++n;
                    break block38;
                }
                case 17: {
                    instruction = ConstantInstruction.make(this.decodeShort(n));
                    n += 2;
                    break block38;
                }
                case 18: {
                    instruction = this.makeConstantPoolLoad(this.code[n] & 0xFF);
                    ++n;
                    break block38;
                }
                case 19: {
                    instruction = this.makeConstantPoolLoad(this.decodeShort(n));
                    n += 2;
                    break block38;
                }
                case 20: {
                    instruction = this.makeConstantPoolLoad(this.decodeShort(n));
                    n += 2;
                    break block38;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    instruction = LoadInstruction.make(indexedTypes[n3 - 21], bl ? this.decodeUShort(n) : this.code[n] & 0xFF);
                    n += bl ? 2 : 1;
                    break block38;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    instruction = StoreInstruction.make(indexedTypes[n3 - 54], bl ? this.decodeUShort(n) : this.code[n] & 0xFF);
                    n += bl ? 2 : 1;
                    break block38;
                }
                case 88: {
                    instruction = PopInstruction.make(Decoder.elemCount(byArray, n2 - 1));
                    break block38;
                }
                case 91: {
                    instruction = DupInstruction.make(1, Decoder.elemCount(byArray, n2 - 2));
                    break block38;
                }
                case 92: {
                    instruction = DupInstruction.make(Decoder.elemCount(byArray, n2 - 1), 0);
                    break block38;
                }
                case 93: {
                    instruction = DupInstruction.make(Decoder.elemCount(byArray, n2 - 1), 1);
                    break block38;
                }
                case 94: {
                    instruction = DupInstruction.make(Decoder.elemCount(byArray, n2 - 1), Decoder.elemCount(byArray, n2 - 2));
                    break block38;
                }
                case 132: {
                    int n4 = bl ? this.decodeUShort(n) : this.code[n] & 0xFF;
                    int n5 = bl ? this.decodeShort(n + 2) : this.code[n + 1];
                    this.decoded.add(LoadInstruction.make("I", n4));
                    this.decoded.add(ConstantInstruction.make(n5));
                    this.decoded.add(BinaryOpInstruction.make("I", IBinaryOpInstruction.Operator.ADD));
                    instruction = StoreInstruction.make("I", n4);
                    n += bl ? 4 : 2;
                    break block38;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    this.decoded.add(makeZero);
                    instruction = ConditionalBranchInstruction.make("I", IConditionalBranchInstruction.Operator.values()[n3 - 153], n - 1 + this.decodeShort(n));
                    n += 2;
                    break block38;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    instruction = ConditionalBranchInstruction.make((short)n3, n - 1 + this.decodeShort(n));
                    n += 2;
                    break block38;
                }
                case 165: 
                case 166: {
                    instruction = ConditionalBranchInstruction.make("Ljava/lang/Object;", IConditionalBranchInstruction.Operator.values()[n3 - 165], n - 1 + this.decodeShort(n));
                    n += 2;
                    break block38;
                }
                case 167: {
                    instruction = GotoInstruction.make(n - 1 + this.decodeShort(n));
                    n += 2;
                    break block38;
                }
                case 168: {
                    n += 2;
                    break block38;
                }
                case 201: {
                    n += 4;
                    break block38;
                }
                case 169: {
                    int n6 = bl ? this.decodeUShort(n) : this.code[n] & 0xFF;
                    instruction = GotoInstruction.make(-1 - n6);
                    if (this.retInfo == null) {
                        throw new InvalidBytecodeException("'ret' outside of subroutine");
                    }
                    this.retInfo[n - (bl ? 2 : 1)] = new RetInfo(-1, n6, n2, byArray);
                    n += bl ? 2 : 1;
                    break block38;
                }
                case 170: {
                    int n7 = n - 1;
                    while ((n & 3) != 0) {
                        ++n;
                    }
                    int n8 = n7 + this.decodeInt(n);
                    int n9 = this.decodeInt(n + 4);
                    int n10 = this.decodeInt(n + 8);
                    int[] nArray = new int[(n10 - n9 + 1) * 2];
                    int n11 = 0;
                    while (n11 < nArray.length) {
                        nArray[n11] = n11 / 2 + n9;
                        nArray[n11 + 1] = n7 + this.decodeInt(n + 12 + n11 * 2);
                        n11 += 2;
                    }
                    instruction = SwitchInstruction.make(nArray, n8);
                    n += 12 + (n10 - n9 + 1) * 4;
                    break block38;
                }
                case 171: {
                    int n12 = n - 1;
                    while ((n & 3) != 0) {
                        ++n;
                    }
                    int n13 = n12 + this.decodeInt(n);
                    int n14 = this.decodeInt(n + 4);
                    int[] nArray = new int[n14 * 2];
                    int n15 = 0;
                    while (n15 < nArray.length) {
                        nArray[n15] = this.decodeInt(n + 8 + n15 * 4);
                        nArray[n15 + 1] = n12 + this.decodeInt(n + 12 + n15 * 4);
                        n15 += 2;
                    }
                    instruction = SwitchInstruction.make(nArray, n13);
                    n += 8 + n14 * 8;
                    break block38;
                }
                case 178: 
                case 180: {
                    int n16 = this.decodeUShort(n);
                    instruction = GetInstruction.make(this.constantPool, n16, n3 == 178);
                    n += 2;
                    break block38;
                }
                case 179: 
                case 181: {
                    int n17 = this.decodeUShort(n);
                    instruction = PutInstruction.make(this.constantPool, n17, n3 == 179);
                    n += 2;
                    break block38;
                }
                case 182: 
                case 183: 
                case 184: {
                    int n18 = this.decodeUShort(n);
                    instruction = InvokeInstruction.make(this.constantPool, n18, n3);
                    n += 2;
                    break block38;
                }
                case 185: {
                    int n19 = this.decodeUShort(n);
                    instruction = InvokeInstruction.make(this.constantPool, n19, n3);
                    n += 4;
                    break block38;
                }
                case 187: {
                    instruction = NewInstruction.make(this.constantPool.getConstantPoolClassType(this.decodeUShort(n)), 0);
                    n += 2;
                    break block38;
                }
                case 188: {
                    instruction = NewInstruction.make(Util.makeArray(this.getPrimitiveType(this.code[n])), 1);
                    ++n;
                    break block38;
                }
                case 189: {
                    instruction = NewInstruction.make(Util.makeArray(this.constantPool.getConstantPoolClassType(this.decodeUShort(n))), 1);
                    n += 2;
                    break block38;
                }
                case 192: {
                    instruction = CheckCastInstruction.make(this.constantPool.getConstantPoolClassType(this.decodeUShort(n)));
                    n += 2;
                    break block38;
                }
                case 193: {
                    instruction = InstanceofInstruction.make(this.constantPool.getConstantPoolClassType(this.decodeUShort(n)));
                    n += 2;
                    break block38;
                }
                case 196: {
                    bl = true;
                    n3 = this.code[n] & 0xFF;
                    continue block38;
                }
                case 197: {
                    instruction = NewInstruction.make(this.constantPool.getConstantPoolClassType(this.decodeUShort(n)), this.code[n + 2] & 0xFF);
                    n += 3;
                    break block38;
                }
                case 198: 
                case 199: {
                    this.decoded.add(ConstantInstruction.make("Ljava/lang/Object;", null));
                    instruction = ConditionalBranchInstruction.make("Ljava/lang/Object;", IConditionalBranchInstruction.Operator.values()[n3 - 198], n - 1 + this.decodeShort(n));
                    n += 2;
                    break block38;
                }
                case 200: {
                    instruction = GotoInstruction.make(n - 1 + this.decodeInt(n));
                    n += 4;
                    break block38;
                }
                default: {
                    throw new InvalidBytecodeException("Unknown opcode " + n3);
                }
            }
            break;
        }
        if (instruction != null) {
            this.decoded.add(instruction);
        }
        return n;
    }

    private int applyInstructionToStack(Instruction instruction, int n, byte[] byArray) throws InvalidBytecodeException {
        if ((n -= instruction.getPoppedCount()) < 0) {
            throw new InvalidBytecodeException("Stack underflow");
        }
        if (instruction instanceof DupInstruction) {
            DupInstruction dupInstruction = (DupInstruction)instruction;
            int n2 = dupInstruction.getDelta();
            int n3 = dupInstruction.getSize();
            System.arraycopy(byArray, n + n2, byArray, n + n3 + n2, n3);
            System.arraycopy(byArray, n, byArray, n + n3, n2);
            System.arraycopy(byArray, n + n3 + n2, byArray, n, n3);
            n += n3 * 2 + n2;
        } else if (instruction instanceof SwapInstruction) {
            if (byArray[n] != byArray[n + 1]) {
                throw new Error("OP_swap must always be swapping the same size, 1");
            }
            n += 2;
        } else {
            byte by = instruction.getPushedWordSize();
            if (by > 0) {
                byArray[n] = by;
                ++n;
            }
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private void decodeAt(int var1_1, int var2_2, byte[] var3_3) throws InvalidBytecodeException {
        if (var1_1 >= 0 && var1_1 < this.decodedOffset.length) ** GOTO lbl55
        throw new InvalidBytecodeException(var1_1, "Branch index " + var1_1 + " out of range");
lbl-1000:
        // 1 sources

        {
            this.decodedOffset[var1_1] = var4_4 = this.decoded.size();
            try {
                var5_5 = this.decodeBytecodeInstruction(var1_1, var2_2, var3_3);
                var6_6 = this.decoded.size() - var4_4;
                this.decodedSize[var1_1] = (byte)var6_6;
                var7_10 = var1_1 + 1;
                while (var7_10 < var5_5) {
                    this.decodedOffset[var7_10] = -2;
                    ++var7_10;
                }
                if (var6_6 > 0) {
                    var7_10 = var4_4;
                    while (var7_10 < var4_4 + var6_6) {
                        var2_2 = this.applyInstructionToStack(this.decoded.get(var7_10), var2_2, var3_3);
                        ++var7_10;
                    }
                    var7_11 = this.decoded.get(var4_4 + var6_6 - 1);
                    var8_12 = var7_11.getBranchTargets();
                    var9_14 = 0;
                    while (var9_14 < var8_12.length) {
                        var10_15 = var8_12[var9_14];
                        if (var10_15 >= 0) {
                            this.decodeAt(var10_15, var2_2, (byte[])var3_3.clone());
                        }
                        ++var9_14;
                    }
                    if (!var7_11.isFallThrough()) {
                        return;
                    }
                } else {
                    var7_10 = var1_1;
                    var8_13 = this.code[var7_10] & 255;
                    if (var8_13 == 196) {
                        var8_13 = this.code[++var7_10] & 255;
                    }
                    if (var8_13 == 168 || var8_13 == 201) {
                        var9_14 = var8_13 == 201 ? this.decodeInt(var7_10) : this.decodeShort(++var7_10);
                        this.decoded.add(GotoInstruction.make(0));
                        this.decodedSize[var1_1] = 1;
                        this.decodeSubroutine(var1_1, var5_5, var1_1 + var9_14, var2_2, var3_3);
                        return;
                    }
                }
            }
            catch (InvalidBytecodeException var6_7) {
                var6_7.setIndex(var1_1);
                throw var6_7;
            }
            catch (Error var6_8) {
                System.err.println("Fatal error at index " + var1_1);
                throw var6_8;
            }
            catch (RuntimeException var6_9) {
                System.err.println("Fatal error at index " + var1_1);
                throw var6_9;
            }
            var1_1 = var5_5;
            if (var1_1 < this.decodedOffset.length) continue;
            throw new InvalidBytecodeException(var1_1, "Fell off end of bytecode array");
lbl55:
            // 2 sources

            ** while (this.decodedOffset[var1_1] < 0)
        }
lbl56:
        // 1 sources

    }

    private ExceptionHandler[] makeHandlers(int n, int[] nArray) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rawHandlers.length) {
            if (this.rawHandlers[n3] <= n && n < this.rawHandlers[n3 + 1]) {
                ++n2;
            }
            n3 += 4;
        }
        return this.makeHandlers(n, n2, nArray);
    }

    private ExceptionHandler[] makeHandlers(int n, int n2, int[] nArray) {
        if (n2 == 0) {
            return noHandlers;
        }
        ExceptionHandler[] exceptionHandlerArray = new ExceptionHandler[n2];
        n2 = 0;
        int n3 = 0;
        while (n3 < this.rawHandlers.length) {
            if (this.rawHandlers[n3] <= n && n < this.rawHandlers[n3 + 1]) {
                int n4 = this.rawHandlers[n3 + 3];
                String string = n4 == 0 ? null : this.constantPool.getConstantPoolClassType(n4);
                exceptionHandlerArray[n2] = new ExceptionHandler(nArray[this.rawHandlers[n3 + 2]], string);
                ++n2;
            }
            n3 += 4;
        }
        return exceptionHandlerArray;
    }

    private int computeSubroutineLength(int n) {
        int n2 = 1;
        int n3 = n;
        while (n3 < this.belongsToSub.length) {
            if (this.belongsToSub[n3] == n) {
                n2 += this.decodedSize[n3];
                if (this.JSRs[n3] > 0) {
                    n2 += this.computeSubroutineLength(this.JSRs[n3]);
                }
            }
            ++n3;
        }
        return n2;
    }

    private int appendSubroutineCode(int n, int n2, int[] nArray) {
        int n3;
        this.instructions[nArray[n]] = GotoInstruction.make(n2);
        this.instructions[n2] = ConstantInstruction.make("Ljava/lang/Object;", null);
        int n4 = ++n2;
        int[] nArray2 = (int[])nArray.clone();
        int n5 = n3 = this.JSRs[n];
        while (n5 < this.belongsToSub.length) {
            if (this.belongsToSub[n5] == n3) {
                int n6 = this.decodedSize[n5];
                int n7 = this.decodedOffset[n5];
                nArray2[n5] = n2;
                int n8 = 0;
                while (n8 < n6) {
                    Instruction instruction = this.decoded.get(n7 + n8);
                    this.instructions[n2] = instruction;
                    this.instructionsToBytecodes[n2] = n5;
                    ++n2;
                    ++n8;
                }
            }
            ++n5;
        }
        n5 = n4;
        while (n5 < n2) {
            IInstruction iInstruction = this.instructions[n5];
            this.instructions[n5] = iInstruction instanceof GotoInstruction && ((GotoInstruction)iInstruction).getLabel() < 0 ? GotoInstruction.make(nArray[n] + 1) : iInstruction.redirectTargets(nArray2);
            this.handlers[n5] = this.makeHandlers(this.instructionsToBytecodes[n5], nArray2);
            ++n5;
        }
        this.handlers[n4 - 1] = this.handlers[n4];
        n5 = n3;
        while (n5 < this.belongsToSub.length) {
            if (this.belongsToSub[n5] == n3 && this.JSRs[n5] > 0) {
                n2 = this.appendSubroutineCode(n5, n2, nArray2);
            }
            ++n5;
        }
        return n2;
    }

    public final void decode() throws InvalidBytecodeException {
        int n;
        int n2;
        int n3;
        int n4;
        byte[] byArray = new byte[this.code.length * 2];
        this.decoded = new ArrayList();
        this.decodedOffset = new int[this.code.length];
        int n5 = 0;
        while (n5 < this.decodedOffset.length) {
            this.decodedOffset[n5] = -1;
            ++n5;
        }
        this.decodedSize = new byte[this.code.length];
        this.decodeAt(0, 0, byArray);
        n5 = 0;
        while (n5 < this.rawHandlers.length) {
            byArray[0] = 1;
            this.decodeAt(this.rawHandlers[n5 + 2], 1, byArray);
            n5 += 4;
        }
        if (this.retInfo != null) {
            this.computeSubroutineMap();
            this.retInfo = null;
        }
        n5 = this.decoded.size();
        if (this.belongsToSub != null) {
            n4 = 0;
            while (n4 < this.belongsToSub.length) {
                if (this.belongsToSub[n4] == 0) {
                    if (this.JSRs[n4] > 0) {
                        n5 += this.computeSubroutineLength(this.JSRs[n4]);
                    }
                } else if (this.belongsToSub[n4] > 0) {
                    n5 -= this.decodedSize[n4];
                }
                ++n4;
            }
        }
        this.instructions = new Instruction[n5];
        this.instructionsToBytecodes = new int[n5];
        this.handlers = new ExceptionHandler[n5][];
        n4 = 0;
        int n6 = 0;
        while (n6 < this.decodedOffset.length) {
            n3 = this.decodedOffset[n6];
            if (n3 >= 0 && (this.belongsToSub == null || this.belongsToSub[n6] == 0)) {
                this.decodedOffset[n6] = n4;
                n2 = this.decodedSize[n6];
                n = 0;
                while (n < n2) {
                    this.instructions[n4] = this.decoded.get(n3 + n);
                    this.instructionsToBytecodes[n4] = n6;
                    ++n4;
                    ++n;
                }
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < n4) {
            this.instructions[n6] = this.instructions[n6].redirectTargets(this.decodedOffset);
            ++n6;
        }
        if (this.JSRs != null) {
            n6 = 0;
            while (n6 < this.JSRs.length) {
                if (this.JSRs[n6] > 0 && this.belongsToSub[n6] == 0) {
                    n4 = this.appendSubroutineCode(n6, n4, this.decodedOffset);
                }
                ++n6;
            }
        }
        if (this.rawHandlers.length > 0) {
            ExceptionHandler[] exceptionHandlerArray = null;
            n3 = -1;
            n4 = 0;
            n2 = 0;
            while (n2 < this.decodedOffset.length) {
                if (this.decodedOffset[n2] >= 0 && (this.belongsToSub == null || this.belongsToSub[n2] == 0)) {
                    int n7;
                    if (n2 >= n3) {
                        n = 0;
                        n3 = Integer.MAX_VALUE;
                        n7 = 0;
                        while (n7 < this.rawHandlers.length) {
                            if (this.rawHandlers[n7] <= n2) {
                                if (n2 < this.rawHandlers[n7 + 1]) {
                                    ++n;
                                    n3 = Math.min(n3, this.rawHandlers[n7 + 1]);
                                }
                            } else {
                                n3 = Math.min(n3, this.rawHandlers[n7]);
                            }
                            n7 += 4;
                        }
                        exceptionHandlerArray = this.makeHandlers(n2, n, this.decodedOffset);
                    }
                    n = this.decodedSize[n2];
                    n7 = 0;
                    while (n7 < n) {
                        this.handlers[n4] = exceptionHandlerArray;
                        ++n4;
                        ++n7;
                    }
                }
                ++n2;
            }
        } else {
            n6 = 0;
            while (n6 < this.handlers.length) {
                this.handlers[n6] = noHandlers;
                ++n6;
            }
        }
        this.decoded = null;
        this.decodedOffset = null;
        this.decodedSize = null;
        this.belongsToSub = null;
        this.JSRs = null;
    }

    public final IInstruction[] getInstructions() {
        if (this.instructions == null) {
            throw new Error("Call decode() before calling getInstructions()");
        }
        return this.instructions;
    }

    public final ExceptionHandler[][] getHandlers() {
        if (this.handlers == null) {
            throw new Error("Call decode() before calling getHandlers()");
        }
        return this.handlers;
    }

    public final int[] getInstructionsToBytecodes() {
        if (this.instructionsToBytecodes == null) {
            throw new Error("Call decode() before calling getInstructionsToBytecodes()");
        }
        return this.instructionsToBytecodes;
    }

    public static class InvalidBytecodeException
    extends Exception {
        private static final long serialVersionUID = -8807125136613458111L;
        private int index;

        InvalidBytecodeException(String string) {
            super(string);
            this.index = -1;
        }

        InvalidBytecodeException(int n, String string) {
            super(string);
            this.index = n;
        }

        void setIndex(int n) {
            if (this.index < 0) {
                this.index = n;
            }
        }

        public int getIndex() {
            return this.index;
        }
    }

    private static class RetInfo {
        int sub;
        final int retVar;
        final int stackLen;
        final byte[] stackWords;

        RetInfo(int n, int n2, int n3, byte[] byArray) {
            this.sub = n;
            this.retVar = n2;
            this.stackLen = n3;
            this.stackWords = byArray;
        }
    }
}

