/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import java.io.IOException;
import java.io.Writer;

public class Disassembler {
    private final IInstruction[] instructions;
    private final ExceptionHandler[][] handlers;
    private final int[] instructionsToBytecodes;

    public Disassembler(IInstruction[] iInstructionArray, ExceptionHandler[][] exceptionHandlerArray, int[] nArray) {
        this.instructions = iInstructionArray;
        this.handlers = exceptionHandlerArray;
        this.instructionsToBytecodes = nArray;
    }

    public Disassembler(MethodData methodData) throws NullPointerException {
        this(methodData.getInstructions(), methodData.getHandlers(), methodData.getInstructionsToBytecodes());
    }

    public void disassembleTo(String string, Writer writer) throws IOException {
        int n = 0;
        while (n < this.instructions.length) {
            writer.write(String.valueOf(string) + n + ": " + this.instructions[n] + " (" + this.instructionsToBytecodes[n] + ")\n");
            int n2 = 0;
            while (n2 < this.handlers[n].length) {
                writer.write(String.valueOf(string) + "    Handles " + this.handlers[n][n2].catchClass + " at " + this.handlers[n][n2].handler + "\n");
                ++n2;
            }
            ++n;
        }
    }

    public void disassembleTo(Writer writer) throws IOException {
        this.disassembleTo("", writer);
    }
}

