/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;

public final class NewInstruction
extends Instruction {
    private final String type;
    private final short arrayBoundsCount;

    protected NewInstruction(short s, String string, short s2) {
        super(s);
        this.type = string;
        this.arrayBoundsCount = s2;
    }

    public static NewInstruction make(String string, int n) throws IllegalArgumentException {
        char c;
        if (string == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Too many array bounds: " + n);
        }
        if (string.length() < n + 1) {
            throw new IllegalArgumentException("Not enough array nesting in " + string + " for bounds count " + n);
        }
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) != '[') {
                throw new IllegalArgumentException("Not enough array nesting in " + string + " for bounds count " + n);
            }
            ++n2;
        }
        n2 = n == 0 ? 187 : (n == 1 ? ((c = string.charAt(1)) != 'L' && c != '[' ? 188 : 189) : 197);
        return new NewInstruction((short)n2, string, (short)n);
    }

    public boolean equals(Object object) {
        if (object instanceof NewInstruction) {
            NewInstruction newInstruction = (NewInstruction)object;
            return newInstruction.type.equals(this.type) && newInstruction.arrayBoundsCount == this.arrayBoundsCount;
        }
        return false;
    }

    public int getArrayBoundsCount() {
        return this.arrayBoundsCount;
    }

    public int hashCode() {
        return 13111143 * this.type.hashCode() + this.arrayBoundsCount;
    }

    public int getPoppedCount() {
        return this.arrayBoundsCount;
    }

    public String getPushedType(String[] stringArray) {
        return this.type;
    }

    public byte getPushedWordSize() {
        return 1;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "New(" + this.type + "," + this.arrayBoundsCount + ")";
    }

    public void visit(IInstruction.Visitor visitor) throws IllegalArgumentException {
        if (visitor == null) {
            throw new IllegalArgumentException();
        }
        visitor.visitNew(this);
    }

    public boolean isPEI() {
        return true;
    }
}

