/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;

public final class PopInstruction
extends Instruction {
    private final byte size;

    protected PopInstruction(byte by) {
        super((short)-1);
        this.size = by;
    }

    public static PopInstruction make(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Invalid pop size: " + n);
        }
        return new PopInstruction((byte)n);
    }

    public boolean equals(Object object) {
        if (object instanceof PopInstruction) {
            PopInstruction popInstruction = (PopInstruction)object;
            return popInstruction.size == this.size;
        }
        return false;
    }

    public int hashCode() {
        return this.size + 8431890;
    }

    public int getPoppedCount() {
        return this.size;
    }

    public void visit(IInstruction.Visitor visitor) throws IllegalArgumentException {
        if (visitor == null) {
            throw new IllegalArgumentException();
        }
        visitor.visitPop(this);
    }

    public String toString() {
        return "Pop(" + this.size + ")";
    }

    public boolean isPEI() {
        return false;
    }
}

