/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.Instruction;

public class PutInstruction
extends Instruction
implements IPutInstruction {
    protected String type;
    protected String classType;
    protected String fieldName;

    PutInstruction(short s, String string, String string2, String string3) {
        super(s);
        this.type = string;
        this.classType = string2;
        this.fieldName = string3;
    }

    ConstantPoolReader getLazyConstantPool() {
        return null;
    }

    static PutInstruction make(ConstantPoolReader constantPoolReader, int n, boolean bl) {
        return new Lazy(bl ? (short)179 : 181, constantPoolReader, n);
    }

    public static PutInstruction make(String string, String string2, String string3, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("className must not be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        return new PutInstruction(bl ? (short)179 : 181, string, string2, string3);
    }

    public final boolean equals(Object object) {
        if (object instanceof PutInstruction) {
            PutInstruction putInstruction = (PutInstruction)object;
            return putInstruction.getFieldType().equals(this.getFieldType()) && putInstruction.getClassType().equals(this.getClassType()) && putInstruction.getFieldName().equals(this.getFieldName()) && putInstruction.opcode == this.opcode;
        }
        return false;
    }

    public String getClassType() {
        return this.classType;
    }

    public String getFieldType() {
        return this.type;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public final boolean isStatic() {
        return this.opcode == 179;
    }

    public final int hashCode() {
        return this.getClassType().hashCode() + 9011 * this.getClassType().hashCode() + 317 * this.getFieldName().hashCode() + this.opcode;
    }

    public final int getPoppedCount() {
        return this.isStatic() ? 1 : 2;
    }

    public final String toString() {
        return "Put(" + this.getFieldType() + "," + (this.isStatic() ? "STATIC" : "NONSTATIC") + "," + this.getClassType() + "," + this.getFieldName() + ")";
    }

    public final void visit(IInstruction.Visitor visitor) throws NullPointerException {
        visitor.visitPut(this);
    }

    public boolean isPEI() {
        return !this.isStatic();
    }

    static final class Lazy
    extends PutInstruction {
        private final ConstantPoolReader cp;
        private final int index;

        Lazy(short s, ConstantPoolReader constantPoolReader, int n) {
            super(s, null, null, null);
            this.index = n;
            this.cp = constantPoolReader;
        }

        ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        int getCPIndex() {
            return this.index;
        }

        public String getClassType() {
            if (this.classType == null) {
                this.classType = this.cp.getConstantPoolMemberClassType(this.index);
            }
            return this.classType;
        }

        public String getFieldName() {
            if (this.fieldName == null) {
                this.fieldName = this.cp.getConstantPoolMemberName(this.index);
            }
            return this.fieldName;
        }

        public String getFieldType() {
            if (this.type == null) {
                this.type = this.cp.getConstantPoolMemberType(this.index);
            }
            return this.type;
        }
    }
}

