/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.analysis;

import com.ibm.wala.shrikeBT.analysis.ClassHierarchyProvider;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassHierarchy {
    public static final int NO = 1;
    public static final int YES = 2;
    public static final int MAYBE = 3;

    private ClassHierarchy() {
    }

    private static int checkSuperinterfacesContain(ClassHierarchyProvider classHierarchyProvider, String string, String string2, HashSet<String> hashSet) {
        String[] stringArray = classHierarchyProvider.getSuperInterfaces(string);
        if (stringArray == null) {
            return 3;
        }
        int n = 1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string3 = stringArray[n2];
            if (!hashSet.contains(string3)) {
                hashSet.add(string3);
                if (string3.equals(string2)) {
                    return 2;
                }
                int n3 = ClassHierarchy.checkSuperinterfacesContain(classHierarchyProvider, string3, string2, hashSet);
                if (n3 == 2) {
                    return 2;
                }
                if (n3 == 3) {
                    n = 3;
                }
            }
            ++n2;
        }
        return n;
    }

    private static int checkSupertypesContain(ClassHierarchyProvider classHierarchyProvider, String string, String string2) {
        Object object;
        int n = 1;
        String string3 = string;
        while (true) {
            if ((object = classHierarchyProvider.getSuperClass(string3)) == null) {
                if (string3.equals("Ljava/lang/Object;")) break;
                n = 3;
                break;
            }
            if (((String)object).equals(string2)) {
                return 2;
            }
            string3 = object;
        }
        if (classHierarchyProvider.isInterface(string2) != 1) {
            object = new HashSet();
            string3 = string;
            while (string3 != null) {
                int n2 = ClassHierarchy.checkSuperinterfacesContain(classHierarchyProvider, string3, string2, (HashSet<String>)object);
                if (n2 == 2) {
                    return 2;
                }
                if (n2 == 3) {
                    n = 3;
                }
                string3 = classHierarchyProvider.getSuperClass(string3);
            }
        }
        return n;
    }

    private static int checkSubtypesContain(ClassHierarchyProvider classHierarchyProvider, String string, String string2, HashSet<String> hashSet) {
        if (classHierarchyProvider.isInterface(string) == 1 && classHierarchyProvider.isInterface(string2) == 2) {
            return 1;
        }
        String[] stringArray = classHierarchyProvider.getSubClasses(string);
        if (stringArray == null) {
            return 3;
        }
        int n = 1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string3 = stringArray[n2];
            if (!hashSet.contains(string3)) {
                hashSet.add(string3);
                if (string3.equals(string2)) {
                    return 2;
                }
                int n3 = ClassHierarchy.checkSubtypesContain(classHierarchyProvider, string3, string2, hashSet);
                if (n3 == 2) {
                    return 2;
                }
                if (n3 == 3) {
                    n = 3;
                }
            }
            ++n2;
        }
        return n;
    }

    private static int checkSubtypeOfHierarchy(ClassHierarchyProvider classHierarchyProvider, String string, String string2) {
        if (string2.equals("Ljava/lang/Object;")) {
            return 2;
        }
        int n = ClassHierarchy.checkSupertypesContain(classHierarchyProvider, string, string2);
        if (n == 3) {
            n = ClassHierarchy.checkSubtypesContain(classHierarchyProvider, string2, string, new HashSet<String>());
        }
        return n;
    }

    public static int isSubtypeOf(ClassHierarchyProvider classHierarchyProvider, String string, String string2) {
        if (string == null || string2 == null) {
            return 1;
        }
        if (string.equals(string2)) {
            return 2;
        }
        if (string.equals("L?;") || string2.equals("L?;")) {
            return 3;
        }
        switch (string.charAt(0)) {
            case 'L': {
                if (string.equals("L;")) {
                    return 2;
                }
                if (string2.startsWith("[")) {
                    return 1;
                }
                if (classHierarchyProvider == null) {
                    return 3;
                }
                return ClassHierarchy.checkSubtypeOfHierarchy(classHierarchyProvider, string, string2);
            }
            case '[': {
                if (string2.equals("Ljava/lang/Object;") || string2.equals("Ljava/io/Serializable;") || string2.equals("Ljava/lang/Cloneable;")) {
                    return 2;
                }
                if (string2.startsWith("[")) {
                    return ClassHierarchy.isSubtypeOf(classHierarchyProvider, string.substring(1), string2.substring(1));
                }
                return 1;
            }
        }
        return 1;
    }

    private static boolean insertSuperInterfaces(ClassHierarchyProvider classHierarchyProvider, String string, HashSet<String> hashSet) {
        String[] stringArray = classHierarchyProvider.getSuperInterfaces(string);
        if (stringArray == null) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (!hashSet.contains(string2)) {
                hashSet.add(string2);
                if (!ClassHierarchy.insertSuperInterfaces(classHierarchyProvider, stringArray[n], hashSet)) {
                    bl = false;
                }
            }
            ++n;
        }
        return bl;
    }

    private static boolean insertSuperClasses(ClassHierarchyProvider classHierarchyProvider, String string, HashSet<String> hashSet) {
        String string2 = string;
        String string3 = string;
        while (string3 != null) {
            hashSet.add(string3);
            string2 = string3;
            string3 = classHierarchyProvider.getSuperClass(string3);
        }
        return string2.equals("Ljava/lang/Object;");
    }

    private static boolean insertSuperClassInterfaces(ClassHierarchyProvider classHierarchyProvider, String string, HashSet<String> hashSet) {
        boolean bl = true;
        String string2 = string;
        while (string2 != null) {
            if (!ClassHierarchy.insertSuperInterfaces(classHierarchyProvider, string2, hashSet)) {
                bl = false;
            }
            string2 = classHierarchyProvider.getSuperClass(string2);
        }
        return bl;
    }

    private static boolean collectDominatingSuperClasses(ClassHierarchyProvider classHierarchyProvider, String string, HashSet<String> hashSet, HashSet<String> hashSet2) {
        String string2 = string;
        String string3 = string;
        while (string3 != null) {
            if (hashSet.contains(string3)) {
                hashSet2.add(string3);
                return true;
            }
            string2 = string3;
            string3 = classHierarchyProvider.getSuperClass(string3);
        }
        return string2.equals("Ljava/lang/Object;");
    }

    private static boolean collectDominatingSuperInterfacesFromClass(ClassHierarchyProvider classHierarchyProvider, String string, HashSet<String> hashSet, HashSet<String> hashSet2) {
        String[] stringArray = classHierarchyProvider.getSuperInterfaces(string);
        if (stringArray == null) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (!hashSet2.contains(string2)) {
                hashSet2.add(string2);
                if (!ClassHierarchy.insertSuperInterfaces(classHierarchyProvider, stringArray[n], hashSet2)) {
                    bl = false;
                }
            }
            ++n;
        }
        return bl;
    }

    private static boolean collectDominatingSuperInterfaces(ClassHierarchyProvider classHierarchyProvider, String string, HashSet<String> hashSet, HashSet<String> hashSet2) {
        boolean bl = true;
        String string2 = string;
        while (string2 != null && !hashSet2.contains(string2)) {
            if (!ClassHierarchy.collectDominatingSuperInterfacesFromClass(classHierarchyProvider, string2, hashSet, hashSet2)) {
                bl = false;
            }
            string2 = classHierarchyProvider.getSuperClass(string2);
        }
        return bl;
    }

    private static String findCommonSupertypeHierarchy(ClassHierarchyProvider classHierarchyProvider, String string, String string2) {
        boolean bl;
        if (ClassHierarchy.isSubtypeOf(classHierarchyProvider, string, string2) == 2) {
            return string2;
        }
        if (ClassHierarchy.isSubtypeOf(classHierarchyProvider, string2, string) == 2) {
            return string;
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("Ljava/lang/Object;");
        boolean bl2 = ClassHierarchy.insertSuperClasses(classHierarchyProvider, string, hashSet);
        int n = hashSet.size();
        boolean bl3 = ClassHierarchy.insertSuperClassInterfaces(classHierarchyProvider, string, hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        boolean bl4 = ClassHierarchy.collectDominatingSuperClasses(classHierarchyProvider, string2, hashSet, hashSet2);
        if (hashSet2.size() == 0) {
            return "L?;";
        }
        if (bl3 && bl2 && hashSet.size() - n == 0) {
            bl = true;
        } else {
            bl = ClassHierarchy.collectDominatingSuperInterfaces(classHierarchyProvider, string2, hashSet, hashSet2);
            if (!bl3 && hashSet2.size() != 1) {
                return "L?;";
            }
        }
        if (!bl4 || !bl) {
            return "";
        }
        Iterator<String> iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            String string3 = iterator.next();
            boolean bl5 = false;
            for (String string4 : hashSet2) {
                if (string3 == string4 || ClassHierarchy.isSubtypeOf(classHierarchyProvider, string4, string3) != 2) continue;
                bl5 = true;
                break;
            }
            if (!bl5) continue;
            iterator.remove();
        }
        if (hashSet2.size() == 1) {
            return hashSet2.iterator().next();
        }
        if (hashSet2.size() == 0) {
            return "Ljava/lang/Object;";
        }
        return "L?;";
    }

    public static String findCommonSupertype(ClassHierarchyProvider classHierarchyProvider, String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        if (string.equals(string2)) {
            return string;
        }
        if (string.equals("L?;") || string2.equals("L?;")) {
            return "L?;";
        }
        if (string2.charAt(0) == '[') {
            String string3 = string;
            string = string2;
            string2 = string3;
        }
        switch (string.charAt(0)) {
            case 'L': {
                if (string.equals("L;")) {
                    return string2;
                }
                if (string2.equals("L;")) {
                    return string;
                }
                if (classHierarchyProvider == null) {
                    return "L?;";
                }
                return ClassHierarchy.findCommonSupertypeHierarchy(classHierarchyProvider, string, string2);
            }
            case '[': {
                char c = string2.charAt(0);
                if (c == '[') {
                    char c2 = string.charAt(1);
                    if (c2 == '[' || c2 == 'L') {
                        return "[" + ClassHierarchy.findCommonSupertype(classHierarchyProvider, string.substring(1), string2.substring(1));
                    }
                    return "Ljava/lang/Object;";
                }
                if (c == 'L') {
                    if (string2.equals("L;")) {
                        return string;
                    }
                    if (string2.equals("Ljava/io/Serializable;") || string2.equals("Ljava/lang/Cloneable;")) {
                        return string2;
                    }
                    return "Ljava/lang/Object;";
                }
                return null;
            }
        }
        return null;
    }
}

