/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.analysis;

import com.ibm.wala.shrikeBT.analysis.ClassHierarchyProvider;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassHierarchyStore
implements ClassHierarchyProvider {
    private static final String[] noClasses = new String[0];
    private final HashMap<String, ClassInfo> contents = new HashMap();

    public void setClassInfo(String string, boolean bl, boolean bl2, String string2, String[] stringArray) throws IllegalArgumentException {
        if (string2 != null && string2.equals(string)) {
            throw new IllegalArgumentException("Class " + string + " cannot be its own superclass");
        }
        this.contents.put(string, new ClassInfo(bl, bl2, string2, stringArray));
    }

    public void removeClassInfo(String string) {
        this.contents.remove(string);
    }

    public Iterator<String> iterateOverClasses() {
        return this.contents.keySet().iterator();
    }

    @Override
    public String getSuperClass(String string) {
        ClassInfo classInfo = this.contents.get(string);
        return classInfo == null ? null : classInfo.superClass;
    }

    @Override
    public String[] getSuperInterfaces(String string) {
        ClassInfo classInfo = this.contents.get(string);
        return classInfo == null ? null : classInfo.superInterfaces;
    }

    @Override
    public String[] getSubClasses(String string) {
        ClassInfo classInfo = this.contents.get(string);
        return classInfo == null || !classInfo.isFinal ? null : noClasses;
    }

    @Override
    public int isInterface(String string) {
        ClassInfo classInfo = this.contents.get(string);
        return classInfo == null ? 3 : (classInfo.isInterface ? 2 : 1);
    }

    static final class ClassInfo {
        final boolean isInterface;
        final boolean isFinal;
        final String superClass;
        final String[] superInterfaces;

        ClassInfo(boolean bl, boolean bl2, String string, String[] stringArray) {
            this.isInterface = bl;
            this.isFinal = bl2;
            this.superClass = string;
            this.superInterfaces = stringArray;
        }
    }
}

