/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.info;

import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.StoreInstruction;

public class ThisAssignmentChecker
implements MethodData.Results {
    private static final String key = ThisAssignmentChecker.class.getName();
    private boolean assignmentToThis;

    ThisAssignmentChecker(MethodData methodData) {
        this.recalculateFrom(methodData);
    }

    private void recalculateFrom(MethodData methodData) {
        this.assignmentToThis = false;
        if (!methodData.getIsStatic()) {
            IInstruction[] iInstructionArray = methodData.getInstructions();
            int n = 0;
            while (n < iInstructionArray.length) {
                StoreInstruction storeInstruction;
                IInstruction iInstruction = iInstructionArray[n];
                if (iInstruction instanceof StoreInstruction && (storeInstruction = (StoreInstruction)iInstruction).getVarIndex() == 0) {
                    this.assignmentToThis = true;
                }
                ++n;
            }
        }
    }

    public boolean notifyUpdate(MethodData methodData, IInstruction[] iInstructionArray, ExceptionHandler[][] exceptionHandlerArray, int[] nArray) {
        return true;
    }

    public static boolean isThisAssigned(MethodData methodData) throws IllegalArgumentException {
        if (methodData == null) {
            throw new IllegalArgumentException();
        }
        ThisAssignmentChecker thisAssignmentChecker = (ThisAssignmentChecker)methodData.getInfo(key);
        if (thisAssignmentChecker == null) {
            thisAssignmentChecker = new ThisAssignmentChecker(methodData);
            methodData.putInfo(key, thisAssignmentChecker);
        }
        return thisAssignmentChecker.assignmentToThis;
    }
}

