/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT;

import com.ibm.wala.shrikeBT.Compiler;
import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.shrikeCT.CTCompiler;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ClassWriter;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.CodeWriter;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.LineNumberTableReader;
import com.ibm.wala.shrikeCT.LineNumberTableWriter;
import com.ibm.wala.shrikeCT.LocalVariableTableReader;
import com.ibm.wala.shrikeCT.LocalVariableTableWriter;
import java.util.Arrays;

public final class ClassInstrumenter {
    private final boolean[] deletedMethods;
    private final MethodData[] methods;
    private final CodeReader[] oldCode;
    private final ClassReader cr;
    private final ConstantPoolReader cpr;
    private boolean createFakeLineNumbers = false;
    private int fakeLineOffset;
    private static final ExceptionHandler[] noHandlers = new ExceptionHandler[0];

    public ClassInstrumenter(byte[] byArray) throws InvalidClassFileException {
        this(new ClassReader(byArray));
    }

    public void enableFakeLineNumbers(int n) {
        this.createFakeLineNumbers = true;
        this.fakeLineOffset = n;
    }

    public ClassInstrumenter(ClassReader classReader) throws InvalidClassFileException {
        if (classReader == null) {
            throw new IllegalArgumentException("cr is null");
        }
        this.cr = classReader;
        this.methods = new MethodData[classReader.getMethodCount()];
        this.oldCode = new CodeReader[this.methods.length];
        this.cpr = CTDecoder.makeConstantPoolReader(classReader);
        this.deletedMethods = new boolean[this.methods.length];
    }

    public ClassReader getReader() {
        return this.cr;
    }

    private void prepareMethod(int n) throws InvalidClassFileException {
        if (this.deletedMethods[n]) {
            this.methods[n] = null;
        } else if (this.methods[n] == null) {
            ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
            this.cr.initMethodAttributeIterator(n, attrIterator);
            while (attrIterator.isValid()) {
                if (attrIterator.getName().equals("Code")) {
                    MethodData methodData;
                    CodeReader codeReader = new CodeReader(attrIterator);
                    CTDecoder cTDecoder = new CTDecoder(codeReader, this.cpr);
                    try {
                        cTDecoder.decode();
                    }
                    catch (Decoder.InvalidBytecodeException invalidBytecodeException) {
                        throw new InvalidClassFileException(codeReader.getRawOffset(), invalidBytecodeException.getMessage());
                    }
                    this.methods[n] = methodData = new MethodData(cTDecoder, this.cr.getMethodAccessFlags(n), CTDecoder.convertClassToType(this.cr.getName()), this.cr.getMethodName(n), this.cr.getMethodType(n));
                    this.oldCode[n] = codeReader;
                    return;
                }
                attrIterator.advance();
            }
        }
    }

    public void deleteMethod(int n) {
        this.deletedMethods[n] = true;
    }

    public MethodData createEmptyMethodData(String string, String string2, int n) {
        IInstruction[] iInstructionArray = new Instruction[]{ReturnInstruction.make("V")};
        ExceptionHandler[][] exceptionHandlerArray = new ExceptionHandler[iInstructionArray.length][];
        Arrays.fill((Object[])exceptionHandlerArray, noHandlers);
        int[] nArray = new int[iInstructionArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = n2;
            ++n2;
        }
        MethodData methodData = null;
        try {
            methodData = new MethodData(n, Util.makeType(this.cr.getName()), string, string2, iInstructionArray, exceptionHandlerArray, nArray);
        }
        catch (InvalidClassFileException invalidClassFileException) {
            invalidClassFileException.printStackTrace();
        }
        return methodData;
    }

    public void visitMethods(MethodExaminer methodExaminer) throws InvalidClassFileException {
        int n = 0;
        while (n < this.methods.length) {
            this.prepareMethod(n);
            if (this.methods[n] != null) {
                methodExaminer.examineCode(this.methods[n]);
            }
            ++n;
        }
    }

    public MethodData visitMethod(int n) throws InvalidClassFileException {
        this.prepareMethod(n);
        return this.methods[n];
    }

    public CodeReader getMethodCode(int n) throws InvalidClassFileException {
        this.prepareMethod(n);
        return this.oldCode[n];
    }

    public void resetMethod(int n) {
        this.deletedMethods[n] = false;
        this.methods[n] = null;
    }

    public void replaceMethod(int n, MethodData methodData) {
        if (methodData == null) {
            throw new IllegalArgumentException("md is null");
        }
        this.deletedMethods[n] = false;
        this.methods[n] = methodData;
        this.oldCode[n] = null;
        methodData.setHasChanged();
    }

    public boolean isChanged() {
        int n = 0;
        while (n < this.methods.length) {
            if (this.deletedMethods[n] || this.methods[n] != null && this.methods[n].getHasChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public ClassWriter emitClass() throws InvalidClassFileException {
        ClassWriter classWriter = new ClassWriter();
        this.emitClassInto(classWriter);
        return classWriter;
    }

    private void emitClassInto(ClassWriter classWriter) throws InvalidClassFileException {
        classWriter.setMajorVersion(this.cr.getMajorVersion());
        classWriter.setMinorVersion(this.cr.getMinorVersion());
        classWriter.setRawCP(this.cr.getCP(), false);
        classWriter.setAccessFlags(this.cr.getAccessFlags());
        classWriter.setNameIndex(this.cr.getNameIndex());
        classWriter.setSuperNameIndex(this.cr.getSuperNameIndex());
        classWriter.setInterfaceNameIndices(this.cr.getInterfaceNameIndices());
        int n = this.cr.getFieldCount();
        int n2 = 0;
        while (n2 < n) {
            classWriter.addRawField(new ClassWriter.RawElement(this.cr.getBytes(), this.cr.getFieldRawOffset(n2), this.cr.getFieldRawSize(n2)));
            ++n2;
        }
        n2 = 0;
        while (n2 < this.methods.length) {
            MethodData methodData = this.methods[n2];
            if (!this.deletedMethods[n2]) {
                if (methodData == null || !methodData.getHasChanged()) {
                    classWriter.addRawMethod(new ClassWriter.RawElement(this.cr.getBytes(), this.cr.getMethodRawOffset(n2), this.cr.getMethodRawSize(n2)));
                } else {
                    CTCompiler cTCompiler = CTCompiler.make(classWriter, methodData);
                    cTCompiler.setPresetConstants(this.cpr);
                    try {
                        cTCompiler.compile();
                    }
                    catch (Error error) {
                        error.printStackTrace();
                        throw new Error("Error compiling method " + methodData + ": " + error.getMessage());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        throw new Error("Error compiling method " + methodData + ": " + exception.getMessage());
                    }
                    CodeReader codeReader = this.oldCode[n2];
                    int n3 = this.cr.getMethodAccessFlags(n2);
                    classWriter.addMethod(n3 &= 0xFFFFFEFF, this.cr.getMethodNameIndex(n2), this.cr.getMethodTypeIndex(n2), this.makeMethodAttributes(n2, classWriter, codeReader, cTCompiler.getOutput()));
                    Compiler.Output[] outputArray = cTCompiler.getAuxiliaryMethods();
                    if (outputArray != null) {
                        int n4 = 0;
                        while (n4 < outputArray.length) {
                            Compiler.Output output = outputArray[n4];
                            classWriter.addMethod(output.getAccessFlags(), output.getMethodName(), output.getMethodSignature(), this.makeMethodAttributes(n2, classWriter, codeReader, output));
                            ++n4;
                        }
                    }
                }
            }
            ++n2;
        }
        ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
        this.cr.initClassAttributeIterator(attrIterator);
        while (attrIterator.isValid()) {
            classWriter.addClassAttribute(new ClassWriter.RawElement(this.cr.getBytes(), attrIterator.getRawOffset(), attrIterator.getRawSize()));
            attrIterator.advance();
        }
    }

    private static CodeWriter makeNewCode(ClassWriter classWriter, Compiler.Output output) {
        CodeWriter codeWriter = new CodeWriter(classWriter);
        codeWriter.setMaxStack(output.getMaxStack());
        codeWriter.setMaxLocals(output.getMaxLocals());
        codeWriter.setCode(output.getCode());
        codeWriter.setRawHandlers(output.getRawHandlers());
        return codeWriter;
    }

    private LineNumberTableWriter makeNewLines(ClassWriter classWriter, CodeReader codeReader, Compiler.Output output) throws InvalidClassFileException {
        int[] nArray;
        int[] nArray2 = null;
        int[] nArray3 = LineNumberTableReader.makeBytecodeToSourceMap(codeReader);
        if (nArray3 != null) {
            nArray = output.getNewBytecodesToOldBytecodes();
            nArray2 = new int[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                if (n2 >= 0) {
                    nArray2[n] = nArray3[n2];
                }
                ++n;
            }
        } else if (this.createFakeLineNumbers) {
            nArray2 = new int[output.getCode().length];
            int n = 0;
            while (n < nArray2.length) {
                nArray2[n] = n + this.fakeLineOffset;
                ++n;
            }
        } else {
            return null;
        }
        nArray = LineNumberTableWriter.makeRawTable(nArray2);
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        LineNumberTableWriter lineNumberTableWriter = new LineNumberTableWriter(classWriter);
        lineNumberTableWriter.setRawTable(nArray);
        return lineNumberTableWriter;
    }

    private static LocalVariableTableWriter makeNewLocals(ClassWriter classWriter, CodeReader codeReader, Compiler.Output output) throws InvalidClassFileException {
        int[][] nArray = LocalVariableTableReader.makeVarMap(codeReader);
        if (nArray != null) {
            int[] nArray2 = output.getNewBytecodesToOldBytecodes();
            int[][] nArrayArray = new int[nArray2.length][];
            int[] nArray3 = null;
            int n = 0;
            while (n < nArray2.length) {
                int n2 = nArray2[n];
                if (n2 >= 0) {
                    nArrayArray[n] = nArray[n2];
                    nArray3 = nArrayArray[n];
                } else {
                    nArrayArray[n] = nArray3;
                }
                ++n;
            }
            int[] nArray4 = LocalVariableTableWriter.makeRawTable(nArrayArray);
            if (nArray4 == null || nArray4.length == 0) {
                return null;
            }
            LocalVariableTableWriter localVariableTableWriter = new LocalVariableTableWriter(classWriter);
            localVariableTableWriter.setRawTable(nArray4);
            return localVariableTableWriter;
        }
        return null;
    }

    private ClassWriter.Element[] makeMethodAttributes(int n, ClassWriter classWriter, CodeReader codeReader, Compiler.Output output) throws InvalidClassFileException {
        CodeWriter codeWriter = ClassInstrumenter.makeNewCode(classWriter, output);
        int n2 = 0;
        LineNumberTableWriter lineNumberTableWriter = null;
        LocalVariableTableWriter localVariableTableWriter = null;
        if (codeReader != null) {
            lineNumberTableWriter = this.makeNewLines(classWriter, codeReader, output);
            if (lineNumberTableWriter != null) {
                ++n2;
            }
            if ((localVariableTableWriter = ClassInstrumenter.makeNewLocals(classWriter, codeReader, output)) != null) {
                ++n2;
            }
        }
        ClassWriter.Element[] elementArray = new ClassWriter.Element[n2];
        int n3 = 0;
        if (lineNumberTableWriter != null) {
            elementArray[0] = lineNumberTableWriter;
            ++n3;
        }
        if (localVariableTableWriter != null) {
            elementArray[n3] = localVariableTableWriter;
        }
        codeWriter.setAttributes(elementArray);
        ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
        this.cr.initMethodAttributeIterator(n, attrIterator);
        int n4 = attrIterator.getRemainingAttributesCount();
        if (codeReader == null) {
            ++n4;
        }
        ClassWriter.Element[] elementArray2 = new ClassWriter.Element[n4];
        int n5 = 0;
        while (attrIterator.isValid()) {
            if (attrIterator.getName().equals("Code")) {
                elementArray2[n5] = codeWriter;
                codeWriter = null;
                if (codeReader == null) {
                    throw new Error("No old code provided, but Code attribute found");
                }
            } else {
                elementArray2[n5] = new ClassWriter.RawElement(this.cr.getBytes(), attrIterator.getRawOffset(), attrIterator.getRawSize());
            }
            ++n5;
            attrIterator.advance();
        }
        if (codeReader == null) {
            if (codeWriter == null) {
                throw new Error("Old code not provided but existing code was found and replaced");
            }
            elementArray2[n4 - 1] = codeWriter;
        }
        return elementArray2;
    }

    public static interface MethodExaminer {
        public void examineCode(MethodData var1);
    }
}

