/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.tools;

import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MethodEditor;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.info.LocalAllocator;
import java.util.Arrays;
import java.util.BitSet;

@Deprecated
public final class MethodOptimizer {
    private final MethodData data;
    private IInstruction[] instructions;
    private ExceptionHandler[][] handlers;
    private final MethodEditor editor;
    private int[][] uniqueStackDefLocations;
    private int[] uniqueStackUseLocations;
    private int[] stackSizes;
    private int[][] backEdges;
    static final int[] noEdges = new int[0];

    public MethodOptimizer(MethodData methodData, MethodEditor methodEditor) {
        if (methodData == null) {
            throw new IllegalArgumentException("null d");
        }
        this.data = methodData;
        this.editor = methodEditor;
    }

    public MethodOptimizer(MethodData methodData) {
        this(methodData, new MethodEditor(methodData));
    }

    public int findUniqueStackDef(int n, int n2) throws UnoptimizableCodeException {
        this.instructions = this.editor.getInstructions();
        this.handlers = this.editor.getHandlers();
        this.checkConsistentStackSizes();
        this.buildBackEdges();
        this.buildStackDefMap();
        return this.uniqueStackDefLocations[n][n2];
    }

    public void optimize() throws UnoptimizableCodeException {
        boolean bl;
        do {
            this.instructions = this.editor.getInstructions();
            this.handlers = this.editor.getHandlers();
            this.checkConsistentStackSizes();
            this.buildBackEdges();
            this.editor.beginPass();
            this.buildStackDefMap();
            this.pushBackLocalStores();
            this.forwardDups();
            bl = this.editor.applyPatches();
            this.editor.endPass();
        } while (bl);
    }

    private void buildBackEdges() {
        int n;
        ExceptionHandler[] exceptionHandlerArray;
        int[] nArray;
        int[] nArray2 = new int[this.instructions.length];
        int n2 = 0;
        while (n2 < this.instructions.length) {
            nArray = this.instructions[n2].getBranchTargets();
            int n3 = 0;
            while (n3 < nArray.length) {
                int n4 = nArray[n3];
                nArray2[n4] = nArray2[n4] + 1;
                ++n3;
            }
            exceptionHandlerArray = this.handlers[n2];
            n = 0;
            while (n < exceptionHandlerArray.length) {
                int n5 = exceptionHandlerArray[n].getHandler();
                nArray2[n5] = nArray2[n5] + 1;
                ++n;
            }
            ++n2;
        }
        this.backEdges = new int[this.instructions.length][];
        n2 = 0;
        while (n2 < this.backEdges.length) {
            this.backEdges[n2] = nArray2[n2] > 0 ? new int[nArray2[n2]] : noEdges;
            ++n2;
        }
        Arrays.fill(nArray2, 0);
        n2 = 0;
        while (n2 < this.instructions.length) {
            nArray = this.instructions[n2].getBranchTargets();
            int n6 = 0;
            while (n6 < nArray.length) {
                n = nArray[n6];
                this.backEdges[n][nArray2[n]] = n2;
                int n7 = n;
                nArray2[n7] = nArray2[n7] + 1;
                ++n6;
            }
            exceptionHandlerArray = this.handlers[n2];
            n = 0;
            while (n < exceptionHandlerArray.length) {
                int n8 = exceptionHandlerArray[n].getHandler();
                this.backEdges[n8][nArray2[n8]] = n2;
                int n9 = n8;
                nArray2[n9] = nArray2[n9] + 1;
                ++n;
            }
            ++n2;
        }
    }

    private int checkConsistentStackSizes() throws UnoptimizableCodeException {
        this.stackSizes = new int[this.instructions.length];
        Arrays.fill(this.stackSizes, -1);
        this.checkStackSizesAt(0, 0);
        int n = 0;
        int n2 = 0;
        while (n2 < this.stackSizes.length) {
            n = Math.max(n, this.stackSizes[n2]);
            ++n2;
        }
        return n;
    }

    private void checkStackSizesAt(int n, int n2) throws UnoptimizableCodeException {
        while (true) {
            Object object;
            if (n < 0 || n >= this.instructions.length) {
                throw new UnoptimizableCodeException("Code exits in an illegal way");
            }
            if (this.stackSizes[n] != -1) {
                if (this.stackSizes[n] != n2) {
                    throw new UnoptimizableCodeException("Mismatched stack sizes at " + n + ": " + n2 + " and " + this.stackSizes[n]);
                }
                return;
            }
            this.stackSizes[n] = n2;
            IInstruction iInstruction = this.instructions[n];
            if ((n2 -= iInstruction.getPoppedCount()) < 0) {
                throw new UnoptimizableCodeException("Stack underflow at " + n);
            }
            if (iInstruction instanceof DupInstruction) {
                object = (DupInstruction)iInstruction;
                n2 += ((DupInstruction)object).getSize() + ((DupInstruction)object).getPoppedCount();
            } else if (iInstruction.getPushedType(null) != null) {
                ++n2;
            }
            object = iInstruction.getBranchTargets();
            int n3 = 0;
            while (n3 < ((Object)object).length) {
                this.checkStackSizesAt((int)object[n3], n2);
                ++n3;
            }
            ExceptionHandler[] exceptionHandlerArray = this.handlers[n];
            int n4 = 0;
            while (n4 < exceptionHandlerArray.length) {
                this.checkStackSizesAt(exceptionHandlerArray[n4].getHandler(), 1);
                ++n4;
            }
            if (!iInstruction.isFallThrough()) {
                return;
            }
            ++n;
        }
    }

    private static boolean instructionKillsVar(IInstruction iInstruction, int n) {
        if (iInstruction instanceof StoreInstruction) {
            StoreInstruction storeInstruction = (StoreInstruction)iInstruction;
            return storeInstruction.getVarIndex() == n || Util.getWordSize(storeInstruction.getType()) == 2 && storeInstruction.getVarIndex() + 1 == n;
        }
        return false;
    }

    private void forwardDups() {
        int n = 0;
        while (n < this.instructions.length) {
            IInstruction iInstruction = this.instructions[n];
            if (iInstruction instanceof DupInstruction && ((DupInstruction)iInstruction).getDelta() == 0 && this.uniqueStackDefLocations[n][0] >= 0 && this.instructions[this.uniqueStackDefLocations[n][0]] instanceof LoadInstruction) {
                int n2 = this.uniqueStackDefLocations[n][0];
                final LoadInstruction loadInstruction = (LoadInstruction)this.instructions[n2];
                int n3 = 0;
                while (n3 < this.instructions.length) {
                    int[] nArray = this.uniqueStackDefLocations[n3];
                    if (nArray[0] == n) {
                        BitSet bitSet = this.getInstructionsOnPath(n2, n3);
                        boolean bl = false;
                        int n4 = loadInstruction.getVarIndex();
                        int n5 = 0;
                        while (n3 < this.instructions.length && !bl) {
                            if (bitSet.get(n5) && MethodOptimizer.instructionKillsVar(this.instructions[n5], n4)) {
                                bl = true;
                            }
                            ++n5;
                        }
                        if (!bl) {
                            this.editor.insertBefore(n3, new MethodEditor.Patch(){

                                public void emitTo(MethodEditor.Output output) {
                                    output.emit(PopInstruction.make(1));
                                    output.emit(loadInstruction);
                                }
                            });
                        }
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    private void pushBackLocalStores() {
        int n = 0;
        while (n < this.instructions.length) {
            IInstruction iInstruction = this.instructions[n];
            if (iInstruction instanceof StoreInstruction && this.uniqueStackDefLocations[n][0] >= 0 && this.uniqueStackDefLocations[n][0] != n - 1 && this.uniqueStackUseLocations[this.uniqueStackDefLocations[n][0]] == n) {
                final StoreInstruction storeInstruction = (StoreInstruction)iInstruction;
                int n2 = this.uniqueStackDefLocations[n][0];
                BitSet bitSet = this.getInstructionsOnPath(n2, n);
                boolean bl = false;
                int n3 = storeInstruction.getVarIndex();
                int n4 = 0;
                while (n4 < this.instructions.length && !bl) {
                    if (bitSet.get(n4) && MethodOptimizer.instructionKillsVar(this.instructions[n4], n3)) {
                        bl = true;
                    }
                    ++n4;
                }
                if (bl) {
                    final String string = storeInstruction.getType();
                    final int n5 = LocalAllocator.allocate(this.data, string);
                    this.editor.insertAfter(n2, new MethodEditor.Patch(){

                        public void emitTo(MethodEditor.Output output) {
                            output.emit(StoreInstruction.make(string, n5));
                        }
                    });
                    this.editor.insertBefore(n, new MethodEditor.Patch(){

                        public void emitTo(MethodEditor.Output output) {
                            output.emit(LoadInstruction.make(string, n5));
                        }
                    });
                } else {
                    this.editor.replaceWith(n, new MethodEditor.Patch(){

                        public void emitTo(MethodEditor.Output output) {
                        }
                    });
                    this.editor.insertAfter(n2, new MethodEditor.Patch(){

                        public void emitTo(MethodEditor.Output output) {
                            output.emit(storeInstruction);
                        }
                    });
                }
            }
            ++n;
        }
    }

    private void buildStackDefMap() {
        int n;
        int[][] nArrayArray = new int[this.instructions.length][];
        int n2 = 0;
        while (n2 < this.instructions.length) {
            nArrayArray[n2] = new int[this.stackSizes[n2]];
            Arrays.fill(nArrayArray[n2], -2);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.instructions.length) {
            if (this.instructions[n2] instanceof DupInstruction) {
                DupInstruction dupInstruction = (DupInstruction)this.instructions[n2];
                n = 0;
                while (n < 2 * dupInstruction.getSize() + dupInstruction.getDelta()) {
                    this.followStackDef(nArrayArray, n2, n2 + 1, this.stackSizes[n2 + 1] - 1 - n);
                    ++n;
                }
            } else if (this.instructions[n2].getPushedType(null) != null) {
                this.followStackDef(nArrayArray, n2, n2 + 1, this.stackSizes[n2 + 1] - 1);
            }
            ++n2;
        }
        this.uniqueStackDefLocations = new int[this.instructions.length][];
        n2 = 0;
        while (n2 < this.instructions.length) {
            this.uniqueStackDefLocations[n2] = new int[this.instructions[n2].getPoppedCount()];
            int n3 = this.instructions[n2].getPoppedCount();
            System.arraycopy(nArrayArray[n2], this.stackSizes[n2] - n3, this.uniqueStackDefLocations[n2], 0, n3);
            ++n2;
        }
        this.uniqueStackUseLocations = new int[this.instructions.length];
        Arrays.fill(this.uniqueStackUseLocations, -2);
        n2 = 0;
        while (n2 < this.instructions.length) {
            nArrayArray[n2] = new int[this.stackSizes[n2]];
            Arrays.fill(nArrayArray[n2], -2);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.instructions.length) {
            int n4 = this.instructions[n2].getPoppedCount();
            if (n4 == 1) {
                this.followStackUse(nArrayArray, n2, n2, this.stackSizes[n2] - 1);
            } else if (n4 > 1) {
                n = 0;
                while (n < n4) {
                    this.followStackUse(nArrayArray, -1, n2, this.stackSizes[n2] - 1 - n);
                    ++n;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.instructions.length) {
            if (this.instructions[n2].getPushedType(null) != null) {
                this.uniqueStackUseLocations[n2] = nArrayArray[n2 + 1][this.stackSizes[n2 + 1] - 1];
            }
            ++n2;
        }
    }

    private void followStackDef(int[][] nArray, int n, int n2, int n3) {
        int[] nArray2;
        while (n3 < (nArray2 = nArray[n2]).length) {
            if (nArray2[n3] == -2) {
                nArray2[n3] = n;
            } else {
                if (nArray2[n3] == n) {
                    return;
                }
                if (nArray2[n3] == -1) {
                    return;
                }
                nArray2[n3] = -1;
                n = -1;
            }
            int[] nArray3 = this.instructions[n2].getBranchTargets();
            int n4 = 0;
            while (n4 < nArray3.length) {
                this.followStackDef(nArray, n, nArray3[n4], n3);
                ++n4;
            }
            ExceptionHandler[] exceptionHandlerArray = this.handlers[n2];
            int n5 = 0;
            while (n5 < exceptionHandlerArray.length) {
                this.followStackDef(nArray, -1, exceptionHandlerArray[n5].getHandler(), 0);
                ++n5;
            }
            if (!this.instructions[n2].isFallThrough()) {
                return;
            }
            ++n2;
        }
        return;
    }

    private void followStackUse(int[][] nArray, int n, int n2, int n3) {
        int[] nArray2;
        while (n3 < (nArray2 = nArray[n2]).length) {
            if (nArray2[n3] == -2) {
                nArray2[n3] = n;
            } else {
                if (nArray2[n3] == n || nArray2[n3] == -1) {
                    return;
                }
                nArray2[n3] = -1;
                n = -1;
            }
            int[] nArray3 = this.backEdges[n2];
            int n4 = 0;
            while (n4 < nArray3.length) {
                this.followStackUse(nArray, n, nArray3[n4], n3);
                ++n4;
            }
            if (n2 == 0 || !this.instructions[n2 - 1].isFallThrough()) {
                return;
            }
            --n2;
        }
        return;
    }

    private BitSet getInstructionsOnPath(int n, int n2) {
        BitSet bitSet = new BitSet();
        this.getReachableInstructions(bitSet, n, n2);
        BitSet bitSet2 = new BitSet();
        this.getReachingInstructions(bitSet2, n, n2);
        bitSet.and(bitSet2);
        return bitSet;
    }

    private void getReachableInstructions(BitSet bitSet, int n, int n2) {
        while (n != n2) {
            bitSet.set(n);
            int[] nArray = this.instructions[n].getBranchTargets();
            int n3 = 0;
            while (n3 < nArray.length) {
                this.getReachableInstructions(bitSet, nArray[n3], n2);
                ++n3;
            }
            if (!this.instructions[n].isFallThrough()) {
                return;
            }
            ++n;
        }
        return;
    }

    private void getReachingInstructions(BitSet bitSet, int n, int n2) {
        while (n2 != n) {
            bitSet.set(n2);
            int[] nArray = this.backEdges[n2];
            int n3 = 0;
            while (n3 < nArray.length) {
                this.getReachingInstructions(bitSet, n, nArray[n3]);
                ++n3;
            }
            if (n2 == 0 || !this.instructions[n2 - 1].isFallThrough()) {
                return;
            }
            --n2;
        }
        return;
    }

    public static class UnoptimizableCodeException
    extends Exception {
        private static final long serialVersionUID = 2543170335674010642L;

        public UnoptimizableCodeException(String string) {
            super(string);
        }
    }
}

