/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassConstants;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrikeCT.InvalidClassFileException;

public final class ClassReader
implements ClassConstants {
    private final byte[] bytes;
    private int[] methodOffsets;
    private int[] fieldOffsets;
    private ConstantPoolParser cpParser;
    private int classInfoOffset;
    private int attrInfoOffset;
    private int interfaceCount;

    public ClassReader(byte[] byArray) throws InvalidClassFileException {
        this.bytes = byArray;
        this.parse();
    }

    private void checkLength(int n, int n2) throws InvalidClassFileException {
        if (this.bytes.length < n + n2) {
            throw new InvalidClassFileException(n, "file truncated, expected " + n2 + " bytes, saw only " + (this.bytes.length - n));
        }
    }

    private void parse() throws InvalidClassFileException {
        int n = 0;
        this.checkLength(n, 10);
        int n2 = this.getInt(n);
        int n3 = this.getUShort(n + 4);
        int n4 = this.getUShort(n + 6);
        int n5 = this.getUShort(n + 8);
        n += 10;
        if (n2 != -889275714) {
            throw new InvalidClassFileException(n, "bad magic number: " + n2);
        }
        if (n4 < 45 || n4 > 50) {
            throw new InvalidClassFileException(n, "unknown class file version: " + n4 + "." + n3);
        }
        this.cpParser = new ConstantPoolParser(this.bytes, n, n5);
        this.classInfoOffset = n += this.cpParser.getRawSize();
        this.checkLength(n, 8);
        this.interfaceCount = this.getUShort(n + 6);
        if (this.interfaceCount < 0) {
            throw new InvalidClassFileException(n, "negative interface count: " + this.interfaceCount);
        }
        this.checkLength(n += 8, this.interfaceCount * 2);
        this.checkLength(n += this.interfaceCount * 2, 2);
        int n6 = this.getUShort(n);
        if (n6 < 0) {
            throw new InvalidClassFileException(n, "negative field count: " + this.interfaceCount);
        }
        n = this.parseFields(n + 2, n6);
        this.checkLength(n, 2);
        int n7 = this.getUShort(n);
        if (n7 < 0) {
            throw new InvalidClassFileException(n, "negative method count: " + this.interfaceCount);
        }
        this.attrInfoOffset = n = this.parseMethods(n + 2, n7);
        this.checkLength(n, 2);
        int n8 = this.getUShort(n);
        n = this.skipAttributes(n + 2, n8);
        if (n != this.bytes.length) {
            throw new InvalidClassFileException(n, "extra data in class file");
        }
    }

    private int skipAttributes(int n, int n2) throws InvalidClassFileException {
        if (n2 < 0) {
            throw new InvalidClassFileException(n, "negative attribute count: " + this.interfaceCount);
        }
        int n3 = 0;
        while (n3 < n2) {
            this.checkLength(n, 6);
            int n4 = this.getInt(n + 2);
            if (n4 < 0) {
                throw new InvalidClassFileException(n, "negative attribute size: " + n4);
            }
            this.checkLength(n += 6, n4);
            n += n4;
            ++n3;
        }
        return n;
    }

    private int parseFields(int n, int n2) throws InvalidClassFileException {
        this.fieldOffsets = new int[n2 + 1];
        int n3 = 0;
        while (n3 < n2) {
            this.fieldOffsets[n3] = n;
            this.checkLength(n, 8);
            n = this.skipAttributes(n + 8, this.getUShort(n + 6));
            ++n3;
        }
        this.fieldOffsets[n2] = n;
        return n;
    }

    private int parseMethods(int n, int n2) throws InvalidClassFileException {
        this.methodOffsets = new int[n2 + 1];
        int n3 = 0;
        while (n3 < n2) {
            this.methodOffsets[n3] = n;
            this.checkLength(n, 8);
            n = this.skipAttributes(n + 8, this.getUShort(n + 6));
            ++n3;
        }
        this.methodOffsets[n2] = n;
        return n;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getMagic() {
        return this.getInt(0);
    }

    public int getMinorVersion() {
        return this.getUShort(4);
    }

    public int getMajorVersion() {
        return this.getUShort(6);
    }

    public int getAccessFlags() {
        return this.getUShort(this.classInfoOffset);
    }

    public int getNameIndex() {
        return this.getUShort(this.classInfoOffset + 2);
    }

    String getClassFromAddress(int n) throws InvalidClassFileException {
        int n2 = this.getUShort(n);
        if (n2 == 0) {
            return null;
        }
        try {
            return this.cpParser.getCPClass(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassFileException(n, "Invalid class constant pool index: " + n2);
        }
    }

    public String getName() throws InvalidClassFileException {
        String string = this.getClassFromAddress(this.classInfoOffset + 2);
        if (string == null) {
            throw new InvalidClassFileException(this.classInfoOffset + 2, "Null class name not allowed");
        }
        return string;
    }

    public int getSuperNameIndex() {
        return this.getUShort(this.classInfoOffset + 4);
    }

    public String getSuperName() throws InvalidClassFileException {
        return this.getClassFromAddress(this.classInfoOffset + 4);
    }

    public int getInterfaceCount() {
        return this.interfaceCount;
    }

    private void verifyInterfaceIndex(int n) {
        if (n < 0 || n >= this.interfaceCount) {
            throw new IllegalArgumentException("Invalid interface index: " + n);
        }
    }

    public int getInterfaceNameIndex(int n) {
        this.verifyInterfaceIndex(n);
        return this.getUShort(this.classInfoOffset + 8 + 2 * n);
    }

    public int[] getInterfaceNameIndices() {
        int[] nArray = new int[this.interfaceCount];
        int n = 0;
        while (n < this.interfaceCount) {
            nArray[n] = this.getUShort(this.classInfoOffset + 8 + 2 * n);
            ++n;
        }
        return nArray;
    }

    public String getInterfaceName(int n) throws InvalidClassFileException {
        this.verifyInterfaceIndex(n);
        String string = this.getClassFromAddress(this.classInfoOffset + 8 + 2 * n);
        if (string == null) {
            throw new InvalidClassFileException(this.classInfoOffset + 8 + 2 * n, "Null interface name not allowed");
        }
        return string;
    }

    public String[] getInterfaceNames() throws InvalidClassFileException {
        String[] stringArray = new String[this.interfaceCount];
        int n = 0;
        while (n < this.interfaceCount) {
            String string = this.getClassFromAddress(this.classInfoOffset + 8 + 2 * n);
            if (string == null) {
                throw new InvalidClassFileException(this.classInfoOffset + 8 + 2 * n, "Null interface name not allowed");
            }
            stringArray[n] = string;
            ++n;
        }
        return stringArray;
    }

    public ConstantPoolParser getCP() {
        return this.cpParser;
    }

    public int getInt(int n) {
        return (this.bytes[n] << 24) + ((this.bytes[n + 1] & 0xFF) << 16) + ((this.bytes[n + 2] & 0xFF) << 8) + (this.bytes[n + 3] & 0xFF);
    }

    public int getUShort(int n) {
        return ((this.bytes[n] & 0xFF) << 8) + (this.bytes[n + 1] & 0xFF);
    }

    public int getShort(int n) {
        return (this.bytes[n] << 8) + (this.bytes[n + 1] & 0xFF);
    }

    public byte getByte(int n) {
        return this.bytes[n];
    }

    public int getFieldCount() {
        return this.fieldOffsets.length - 1;
    }

    private void verifyFieldIndex(int n) {
        if (n < 0 || n >= this.fieldOffsets.length - 1) {
            throw new IllegalArgumentException("Invalid field index: " + n);
        }
    }

    public int getFieldAccessFlags(int n) {
        this.verifyFieldIndex(n);
        return this.getUShort(this.fieldOffsets[n]);
    }

    String getUtf8FromAddress(int n) throws InvalidClassFileException {
        int n2 = this.getUShort(n);
        if (n2 == 0) {
            return null;
        }
        try {
            return this.cpParser.getCPUtf8(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassFileException(n, "Invalid Utf8 constant pool index: " + n2);
        }
    }

    public String getFieldName(int n) throws InvalidClassFileException {
        this.verifyFieldIndex(n);
        return this.getUtf8FromAddress(this.fieldOffsets[n] + 2);
    }

    public String getFieldType(int n) throws InvalidClassFileException {
        this.verifyFieldIndex(n);
        return this.getUtf8FromAddress(this.fieldOffsets[n] + 4);
    }

    public int getFieldNameIndex(int n) {
        this.verifyFieldIndex(n);
        return this.getUShort(this.fieldOffsets[n] + 2);
    }

    public int getFieldTypeIndex(int n) {
        this.verifyFieldIndex(n);
        return this.getUShort(this.fieldOffsets[n] + 4);
    }

    public void initFieldAttributeIterator(int n, AttrIterator attrIterator) {
        if (attrIterator == null) {
            throw new IllegalArgumentException("iter is null");
        }
        this.verifyFieldIndex(n);
        attrIterator.init(this, this.fieldOffsets[n] + 6);
    }

    public int getFieldRawOffset(int n) {
        this.verifyFieldIndex(n);
        return this.fieldOffsets[n];
    }

    public int getFieldRawSize(int n) {
        this.verifyFieldIndex(n);
        return this.fieldOffsets[n + 1] - this.fieldOffsets[n];
    }

    public int getMethodCount() {
        return this.methodOffsets.length - 1;
    }

    private void verifyMethodIndex(int n) {
        if (n < 0 || n >= this.methodOffsets.length - 1) {
            throw new IllegalArgumentException("Invalid method index: " + n);
        }
    }

    public int getMethodRawOffset(int n) {
        this.verifyMethodIndex(n);
        return this.methodOffsets[n];
    }

    public int getMethodRawSize(int n) {
        this.verifyMethodIndex(n);
        return this.methodOffsets[n + 1] - this.methodOffsets[n];
    }

    public int getMethodAccessFlags(int n) {
        this.verifyMethodIndex(n);
        return this.getUShort(this.methodOffsets[n]);
    }

    public String getMethodName(int n) throws InvalidClassFileException {
        this.verifyMethodIndex(n);
        return this.getUtf8FromAddress(this.methodOffsets[n] + 2);
    }

    public String getMethodType(int n) throws InvalidClassFileException {
        this.verifyMethodIndex(n);
        return this.getUtf8FromAddress(this.methodOffsets[n] + 4);
    }

    public int getMethodNameIndex(int n) {
        this.verifyMethodIndex(n);
        return this.getUShort(this.methodOffsets[n] + 2);
    }

    public int getMethodTypeIndex(int n) {
        this.verifyMethodIndex(n);
        return this.getUShort(this.methodOffsets[n] + 4);
    }

    public void initMethodAttributeIterator(int n, AttrIterator attrIterator) {
        if (attrIterator == null) {
            throw new IllegalArgumentException("iter is null");
        }
        this.verifyMethodIndex(n);
        attrIterator.init(this, this.methodOffsets[n] + 6);
    }

    public void initClassAttributeIterator(AttrIterator attrIterator) {
        if (attrIterator == null) {
            throw new IllegalArgumentException("iter is null");
        }
        attrIterator.init(this, this.attrInfoOffset);
    }

    public static final class AttrIterator {
        ClassReader cr;
        int offset;
        int size;
        private int remaining;

        private void setSize() {
            if (this.remaining > 0) {
                this.size = 6 + this.cr.getInt(this.offset + 2);
            }
        }

        void init(ClassReader classReader, int n) {
            this.cr = classReader;
            this.offset = n + 2;
            this.remaining = classReader.getUShort(n);
            this.setSize();
        }

        void verifyValid() {
            if (this.remaining <= 0) {
                throw new IllegalArgumentException("Attempt to manipulate invalid AttrIterator");
            }
        }

        public ClassReader getClassReader() {
            this.verifyValid();
            return this.cr;
        }

        public int getRawOffset() {
            this.verifyValid();
            return this.offset;
        }

        public int getRawSize() {
            this.verifyValid();
            return this.size;
        }

        public int getDataOffset() {
            this.verifyValid();
            return this.offset + 6;
        }

        public int getDataSize() {
            this.verifyValid();
            return this.size - 6;
        }

        public int getRemainingAttributesCount() {
            return this.remaining;
        }

        public int getNameIndex() {
            this.verifyValid();
            return this.cr.getUShort(this.offset);
        }

        public String getName() throws InvalidClassFileException {
            this.verifyValid();
            String string = this.cr.getUtf8FromAddress(this.offset);
            if (string == null) {
                throw new InvalidClassFileException(this.offset, "Null attribute name");
            }
            return string;
        }

        public boolean isValid() {
            return this.remaining > 0;
        }

        public void advance() {
            this.verifyValid();
            this.offset += this.size;
            --this.remaining;
            this.setSize();
        }
    }
}

