/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassWriter;

public final class CodeWriter
extends ClassWriter.Element {
    private final int attrID;
    private int maxLocals = -1;
    private int maxStack = -1;
    private byte[] code;
    private int[] exnHandlers;
    private ClassWriter.Element[] attributes;

    public CodeWriter(ClassWriter classWriter) {
        if (classWriter == null) {
            throw new IllegalArgumentException("w is null");
        }
        this.attrID = classWriter.addCPUtf8("Code");
    }

    private void verify() {
        if (this.maxStack < 0) {
            throw new IllegalArgumentException("maxStack not set");
        }
        if (this.maxLocals < 0) {
            throw new IllegalArgumentException("maxLocals not set");
        }
        if (this.code == null) {
            throw new IllegalArgumentException("No bytecodes set");
        }
    }

    public int getCodeLength() throws IllegalStateException {
        if (this.code == null) {
            throw new IllegalStateException("code not initialized");
        }
        return this.code.length;
    }

    public int getSize() throws IllegalArgumentException {
        this.verify();
        int n = 14 + this.code.length + 2 + (this.exnHandlers == null ? 0 : this.exnHandlers.length) * 2 + 2;
        if (this.attributes != null) {
            int n2 = 0;
            while (n2 < this.attributes.length) {
                n += this.attributes[n2].getSize();
                ++n2;
            }
        }
        return n;
    }

    public int copyInto(byte[] byArray, int n) throws IllegalArgumentException {
        int n2;
        this.verify();
        int n3 = n;
        ClassWriter.setUShort(byArray, n, this.attrID);
        ClassWriter.setUShort(byArray, n + 6, this.maxStack);
        ClassWriter.setUShort(byArray, n + 8, this.maxLocals);
        ClassWriter.setInt(byArray, n + 10, this.code.length);
        System.arraycopy(this.code, 0, byArray, n += 14, this.code.length);
        ClassWriter.setUShort(byArray, n += this.code.length, (this.exnHandlers == null ? 0 : this.exnHandlers.length) / 4);
        n += 2;
        if (this.exnHandlers != null) {
            n2 = 0;
            while (n2 < this.exnHandlers.length) {
                ClassWriter.setUShort(byArray, n, this.exnHandlers[n2]);
                n += 2;
                ++n2;
            }
        }
        ClassWriter.setUShort(byArray, n, this.attributes == null ? 0 : this.attributes.length);
        n += 2;
        if (this.attributes != null) {
            n2 = 0;
            while (n2 < this.attributes.length) {
                n = this.attributes[n2].copyInto(byArray, n);
                ++n2;
            }
        }
        ClassWriter.setInt(byArray, n3 + 2, n - n3 - 6);
        return n;
    }

    public void setCode(byte[] byArray) throws IllegalArgumentException {
        if (byArray == null) {
            throw new IllegalArgumentException("code is null");
        }
        if (byArray.length > 65535) {
            throw new IllegalArgumentException("Code array is too long: " + byArray.length);
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Code array is empty");
        }
        this.code = byArray;
    }

    public void setRawHandlers(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("exnHandlers is null");
        }
        if (nArray.length % 4 != 0) {
            throw new IllegalArgumentException("Exception handlers array has bad length: " + nArray.length);
        }
        if (nArray.length / 4 > 65535) {
            throw new IllegalArgumentException("Too many exception handlers: " + nArray.length / 4);
        }
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 < 0 || n2 > 65535) {
                throw new IllegalArgumentException("Invalid exception handler entry at " + n);
            }
            ++n;
        }
        this.exnHandlers = nArray;
    }

    public void setMaxLocals(int n) {
        this.maxLocals = n;
    }

    public void setMaxStack(int n) {
        this.maxStack = n;
    }

    public void setAttributes(ClassWriter.Element[] elementArray) {
        this.attributes = elementArray;
    }
}

