/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassConstants;
import com.ibm.wala.shrikeCT.InvalidClassFileException;

public final class ConstantPoolParser
implements ClassConstants {
    private final byte[] bytes;
    private int[] cpOffsets;
    private String[] cpItems;
    private static final int MAX_CP_ITEMS = 0x1FFFFFFF;

    public ConstantPoolParser(byte[] byArray, int n, int n2) throws InvalidClassFileException {
        this.bytes = byArray;
        if (n < 0) {
            throw new IllegalArgumentException("invalid offset: " + n);
        }
        if (n2 < 0 || n2 > 0x1FFFFFFF) {
            throw new IllegalArgumentException("invalid itemCount: " + n2);
        }
        this.parseConstantPool(n, n2);
    }

    public byte[] getRawBytes() {
        return this.bytes;
    }

    public int getRawOffset() throws IllegalStateException {
        if (this.cpOffsets.length < 2) {
            throw new IllegalStateException();
        }
        return this.cpOffsets[1];
    }

    public int getRawSize() throws IllegalStateException {
        if (this.cpOffsets.length < 2) {
            throw new IllegalStateException();
        }
        return this.cpOffsets[this.cpOffsets.length - 1] - this.cpOffsets[1];
    }

    public int getItemCount() {
        return this.cpOffsets.length - 1;
    }

    private void checkLength(int n, int n2) throws InvalidClassFileException {
        if (this.bytes.length < n + n2) {
            throw new InvalidClassFileException(n, "file truncated, expected " + n2 + " bytes, saw only " + (this.bytes.length - n));
        }
    }

    public byte getItemType(int n) throws IllegalArgumentException {
        if (n < 1 || n >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + n + " out of range");
        }
        int n2 = this.cpOffsets[n];
        if (n2 == 0) {
            return 0;
        }
        return this.getByte(n2);
    }

    public String getCPClass(int n) throws InvalidClassFileException, IllegalArgumentException {
        if (n < 1 || n >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + n + " out of range");
        }
        int n2 = this.cpOffsets[n];
        if (n2 == 0 || this.getByte(n2) != 7) {
            throw new IllegalArgumentException("Constant pool item #" + n + " is not a Class");
        }
        String string = this.cpItems[n];
        if (string == null) {
            try {
                string = this.getCPUtf8(this.getUShort(n2 + 1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidClassFileException(n2, "Invalid class name at constant pool item #" + n + ": " + illegalArgumentException.getMessage());
            }
            this.cpItems[n] = string;
        }
        return string;
    }

    public String getCPString(int n) throws InvalidClassFileException, IllegalArgumentException {
        if (n < 1 || n >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + n + " out of range");
        }
        int n2 = this.cpOffsets[n];
        if (n2 == 0 || this.getByte(n2) != 8) {
            throw new IllegalArgumentException("Constant pool item #" + n + " is not a String");
        }
        String string = this.cpItems[n];
        if (string == null) {
            try {
                string = this.getCPUtf8(this.getUShort(n2 + 1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidClassFileException(n2, "Invalid string at constant pool item #" + n + ": " + illegalArgumentException.getMessage());
            }
            this.cpItems[n] = string;
        }
        return string;
    }

    private static boolean isRef(byte by) {
        switch (by) {
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public String getCPRefClass(int n) throws InvalidClassFileException, IllegalArgumentException {
        if (n < 1 || n >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + n + " out of range");
        }
        int n2 = this.cpOffsets[n];
        if (n2 == 0 || !ConstantPoolParser.isRef(this.getByte(n2))) {
            throw new IllegalArgumentException("Constant pool item #" + n + " is not a Ref");
        }
        try {
            return this.getCPClass(this.getUShort(n2 + 1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassFileException(n2, "Invalid Ref class at constant pool item #" + n + ": " + illegalArgumentException.getMessage());
        }
    }

    public String getCPRefName(int n) throws InvalidClassFileException, IllegalArgumentException {
        if (n < 1 || n >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + n + " out of range");
        }
        int n2 = this.cpOffsets[n];
        if (n2 == 0 || !ConstantPoolParser.isRef(this.getByte(n2))) {
            throw new IllegalArgumentException("Constant pool item #" + n + " is not a Ref");
        }
        try {
            return this.getCPNATName(this.getUShort(n2 + 3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassFileException(n2, "Invalid Ref NameAndType at constant pool item #" + n + ": " + illegalArgumentException.getMessage());
        }
    }

    public String getCPRefType(int n) throws InvalidClassFileException, IllegalArgumentException {
        if (n < 1 || n >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + n + " out of range");
        }
        int n2 = this.cpOffsets[n];
        if (n2 == 0 || !ConstantPoolParser.isRef(this.getByte(n2))) {
            throw new IllegalArgumentException("Constant pool item #" + n + " is not a Ref");
        }
        try {
            return this.getCPNATType(this.getUShort(n2 + 3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassFileException(n2, "Invalid Ref NameAndType at constant pool item #" + n + ": " + illegalArgumentException.getMessage());
        }
    }

    public String getCPNATName(int n) throws InvalidClassFileException, IllegalArgumentException {
        if (n < 1 || n >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + n + " out of range");
        }
        int n2 = this.cpOffsets[n];
        if (n2 == 0 || this.getByte(n2) != 12) {
            throw new IllegalArgumentException("Constant pool item #" + n + " is not a NameAndType");
        }
        try {
            return this.getCPUtf8(this.getUShort(n2 + 1));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassFileException(n2, "Invalid NameAndType name at constant pool item #" + n + ": " + illegalArgumentException.getMessage());
        }
    }

    public String getCPNATType(int n) throws InvalidClassFileException, IllegalArgumentException {
        if (n < 1 || n >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + n + " out of range");
        }
        int n2 = this.cpOffsets[n];
        if (n2 == 0 || this.getByte(n2) != 12) {
            throw new IllegalArgumentException("Constant pool item #" + n + " is not a NameAndType");
        }
        try {
            return this.getCPUtf8(this.getUShort(n2 + 3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassFileException(n2, "Invalid NameAndType type at constant pool item #" + n + ": " + illegalArgumentException.getMessage());
        }
    }

    public int getCPInt(int n) throws InvalidClassFileException, IllegalArgumentException {
        if (n < 1 || n >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + n + " out of range");
        }
        int n2 = this.cpOffsets[n];
        if (n2 == 0 || this.getByte(n2) != 3) {
            throw new IllegalArgumentException("Constant pool item #" + n + " is not an Integer");
        }
        return this.getInt(n2 + 1);
    }

    public float getCPFloat(int n) throws InvalidClassFileException, IllegalArgumentException {
        if (n < 1 || n >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + n + " out of range");
        }
        int n2 = this.cpOffsets[n];
        if (n2 == 0 || this.getByte(n2) != 4) {
            throw new IllegalArgumentException("Constant pool item #" + n + " is not a Float");
        }
        return this.getFloat(n2 + 1);
    }

    public long getCPLong(int n) throws InvalidClassFileException, IllegalArgumentException {
        if (n < 1 || n >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + n + " out of range");
        }
        int n2 = this.cpOffsets[n];
        if (n2 == 0 || this.getByte(n2) != 5) {
            throw new IllegalArgumentException("Constant pool item #" + n + " is not a Long");
        }
        return this.getLong(n2 + 1);
    }

    public double getCPDouble(int n) throws InvalidClassFileException, IllegalArgumentException {
        if (n < 1 || n >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + n + " out of range");
        }
        int n2 = this.cpOffsets[n];
        if (n2 == 0 || this.getByte(n2) != 6) {
            throw new IllegalArgumentException("Constant pool item #" + n + " is not a Double");
        }
        return this.getDouble(n2 + 1);
    }

    private InvalidClassFileException invalidUtf8(int n, int n2) {
        return new InvalidClassFileException(n2, "Constant pool item #" + n + " starting at " + this.cpOffsets[n] + ", is an invalid Java Utf8 string (byte is " + this.getByte(n2) + ")");
    }

    public String getCPUtf8(int n) throws InvalidClassFileException, IllegalArgumentException {
        if (n < 1 || n >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + n + " out of range");
        }
        int n2 = this.cpOffsets[n];
        if (n2 == 0 || this.getByte(n2) != 1) {
            throw new IllegalArgumentException("Constant pool item #" + n + " is not a Utf8");
        }
        String string = this.cpItems[n];
        if (string == null) {
            int n3 = this.getUShort(n2 + 1);
            int n4 = n3 + n2 + 3;
            StringBuffer stringBuffer = new StringBuffer(n3);
            n2 += 3;
            while (n2 < n4) {
                byte by;
                byte by2 = this.getByte(n2);
                if ((by2 & 0x80) == 0) {
                    if (by2 == 0) {
                        throw this.invalidUtf8(n, n2);
                    }
                    stringBuffer.append((char)by2);
                    ++n2;
                    continue;
                }
                if ((by2 & 0xE0) == 192) {
                    if (n2 + 1 >= n4) {
                        throw this.invalidUtf8(n, n2);
                    }
                    by = this.getByte(n2 + 1);
                    if ((by & 0xC0) != 128) {
                        throw this.invalidUtf8(n, n2);
                    }
                    stringBuffer.append((char)(((by2 & 0x1F) << 6) + (by & 0x3F)));
                    n2 += 2;
                    continue;
                }
                if ((by2 & 0xF0) == 224) {
                    if (n2 + 2 >= n4) {
                        throw this.invalidUtf8(n, n2);
                    }
                    by = this.getByte(n2 + 1);
                    byte by3 = this.getByte(n2 + 2);
                    if ((by & 0xC0) != 128 || (by3 & 0xC0) != 128) {
                        throw this.invalidUtf8(n, n2);
                    }
                    stringBuffer.append((char)(((by2 & 0xF) << 12) + ((by & 0x3F) << 6) + (by3 & 0x3F)));
                    n2 += 3;
                    continue;
                }
                throw this.invalidUtf8(n, n2);
            }
            this.cpItems[n] = string = stringBuffer.toString();
        }
        return string;
    }

    private void parseConstantPool(int n, int n2) throws InvalidClassFileException {
        this.cpOffsets = new int[n2 + 1];
        this.cpItems = new String[n2];
        int n3 = 1;
        while (n3 < n2) {
            int n4;
            this.cpOffsets[n3] = n;
            byte by = this.getByte(n);
            switch (by) {
                case 7: 
                case 8: {
                    n4 = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n4 = 4;
                    break;
                }
                case 5: 
                case 6: {
                    n4 = 8;
                    ++n3;
                    break;
                }
                case 1: {
                    n4 = 2 + this.getUShort(n + 1);
                    break;
                }
                default: {
                    throw new InvalidClassFileException(n, "unknown constant pool entry type" + by);
                }
            }
            this.checkLength(n, n4);
            n += n4 + 1;
            ++n3;
        }
        this.cpOffsets[n2] = n;
    }

    private byte getByte(int n) {
        return this.bytes[n];
    }

    private int getUShort(int n) {
        return ((this.bytes[n] & 0xFF) << 8) + (this.bytes[n + 1] & 0xFF);
    }

    private int getInt(int n) {
        return (this.bytes[n] << 24) + ((this.bytes[n + 1] & 0xFF) << 16) + ((this.bytes[n + 2] & 0xFF) << 8) + (this.bytes[n + 3] & 0xFF);
    }

    private long getLong(int n) {
        return ((long)this.getInt(n) << 32) + ((long)this.getInt(n + 4) & 0xFFFFFFFFL);
    }

    private float getFloat(int n) {
        return Float.intBitsToFloat(this.getInt(n));
    }

    private double getDouble(int n) {
        return Double.longBitsToDouble(this.getLong(n));
    }
}

