/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassWriter;

public final class ConstantValueWriter
extends ClassWriter.Element {
    private final int attrID;
    private int index = -1;
    private final ClassWriter w;

    public ConstantValueWriter(ClassWriter classWriter) {
        if (classWriter == null) {
            throw new IllegalArgumentException("w is null");
        }
        this.w = classWriter;
        this.attrID = classWriter.addCPUtf8("ConstantValue");
    }

    public ConstantValueWriter(ClassWriter classWriter, long l) {
        this(classWriter);
        this.setLong(l);
    }

    public ConstantValueWriter(ClassWriter classWriter, int n) {
        this(classWriter);
        this.setInt(n);
    }

    public ConstantValueWriter(ClassWriter classWriter, float f) {
        this(classWriter);
        this.setFloat(f);
    }

    public ConstantValueWriter(ClassWriter classWriter, double d) {
        this(classWriter);
        this.setDouble(d);
    }

    public ConstantValueWriter(ClassWriter classWriter, String string) {
        this(classWriter);
        this.setString(string);
    }

    private void verify() {
        if (this.index < 0) {
            throw new IllegalArgumentException("The value's constant pool index is not set");
        }
    }

    public int getSize() {
        this.verify();
        return 8;
    }

    public int copyInto(byte[] byArray, int n) throws IllegalArgumentException {
        this.verify();
        ClassWriter.setUShort(byArray, n, this.attrID);
        ClassWriter.setInt(byArray, n + 2, 2);
        ClassWriter.setUShort(byArray, n + 6, this.index);
        return n + 8;
    }

    public void setLong(long l) {
        this.index = this.w.addCPLong(l);
    }

    public void setDouble(double d) {
        this.index = this.w.addCPDouble(d);
    }

    public void setInt(int n) {
        this.index = this.w.addCPInt(n);
    }

    public void setFloat(float f) {
        this.index = this.w.addCPFloat(f);
    }

    public void setString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null value");
        }
        this.index = this.w.addCPString(string);
    }

    public void setValueCPIndex(int n) throws IllegalArgumentException {
        if (n < 1 || n > 65535) {
            throw new IllegalArgumentException("Invalid CP index: " + n);
        }
        this.index = n;
    }
}

